/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes.utils;

import com.indy.engine.actionCodes.utils.Messages;
import com.indy.engine.core.IDatatypeConverter;
import com.indy.engine.core.UtilsService;
import com.indy.engine.core.actionCodes.convert.AbstractDataTypeConverter;
import com.indy.engine.core.actionCodes.convert.AbstractParser;
import com.indy.engine.core.actionCodes.convert.JdbcConverter;
import com.indy.engine.core.actionCodes.convert.ParserProvider;
import com.indy.engine.core.actionCodes.convert.Unparser;
import com.indy.engine.core.api.impl.jdbc.JdbcWriterProperties;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.UUID;

public class XmlDataTypeProvider
extends AbstractDataTypeConverter {
    IDatatypeConverter datatypeConverter;
    public static final int dateTimeType = 1;
    public static final int dateType = 2;
    public static final int timeType = 3;
    public static final int booleanType = 4;
    public static final int doubleType = 5;
    public static final int decimalType = 6;
    public static final int base64BinaryType = 7;
    public static final int hexBinaryType = 8;
    public static final int byteType = 9;
    public static final int floatType = 10;
    public static final int stringType = 11;
    public static final int integerType = 12;
    public static final int intType = 13;
    public static final int shortType = 14;
    public static final int anySimpleType = 15;
    public static final int IDType = 16;
    public static final int IDREFType = 17;
    public static final int longType = 18;
    private boolean getDateHasTimestamp;
    private boolean setDateHasTimestamp;
    DefaultXmlConverter unparser = new DefaultXmlConverter(this);

    public XmlDataTypeProvider() throws EngineExceptionI {
        try {
            this.datatypeConverter = UtilsService.getXmlUtils().getDatatypeConverter();
        }
        catch (Exception e) {
            throw new EngineExceptionI(e);
        }
    }

    @Override
    public int getDataType(String name) {
        if (name != null && !name.isEmpty()) {
            if (name.equals("dateTime")) {
                return 1;
            }
            if (name.equals("date")) {
                return 2;
            }
            if (name.equals("time")) {
                return 3;
            }
            if (name.equals("boolean")) {
                return 4;
            }
            if (name.equals("long") || name.equals("unsignedLong")) {
                return 18;
            }
            if (name.equals("double")) {
                return 5;
            }
            if (name.equals("decimal")) {
                return 6;
            }
            if (name.equals("base64Binary")) {
                return 7;
            }
            if (name.equals("hexBinary")) {
                return 8;
            }
            if (name.equals("byte")) {
                return 9;
            }
            if (name.equals("float")) {
                return 10;
            }
            if (name.equals("string")) {
                return 11;
            }
            if (name.equals("integer") || name.equals("negativeInteger") || name.equals("nonNegativeInteger") || name.equals("nonPositiveInteger") || name.equals("unsignedInt")) {
                return 12;
            }
            if (name.equals("int")) {
                return 13;
            }
            if (name.equals("short") || name.equals("unsignedShort")) {
                return 14;
            }
            if (name.equals("ID")) {
                return 16;
            }
            if (name.equals("IDREF")) {
                return 17;
            }
            return 15;
        }
        return -1;
    }

    public int getJavaDataType(int datatype) {
        switch (datatype) {
            case 1: {
                return 93;
            }
            case 2: {
                return 91;
            }
            case 3: {
                return 92;
            }
            case 4: {
                return 16;
            }
            case 18: {
                return -5;
            }
            case 5: {
                return 8;
            }
            case 6: {
                return 3;
            }
            case 7: 
            case 8: {
                return -4;
            }
            case 9: {
                return 4;
            }
            case 10: {
                return 6;
            }
            case 11: 
            case 15: 
            case 16: 
            case 17: {
                return 12;
            }
            case 12: {
                return 4;
            }
            case 13: {
                return 4;
            }
            case 14: {
                return 5;
            }
        }
        return 12;
    }

    @Override
    public ParserProvider getParserProvider() {
        return new DefaultXmlParserProvider(this);
    }

    @Override
    public Unparser getUnparser() {
        return this.unparser;
    }

    public static class DefaultXmlConverter
    extends Unparser {
        public DefaultXmlConverter(AbstractDataTypeConverter dataTypeProvider) throws EngineExceptionI {
            super(dataTypeProvider);
        }

        @Override
        public String printBoolean(boolean b, int targetType) {
            return this.datatypeConverter.printBoolean(b);
        }

        @Override
        public String printDateTime(Calendar cal, int targetType) {
            return this.datatypeConverter.printDateTime(cal);
        }

        @Override
        public String printDecimal(BigDecimal dec, int targetType) {
            return this.datatypeConverter.printDecimal(dec);
        }

        @Override
        public String printDouble(Double d, int targetType) {
            return this.datatypeConverter.printDouble(d);
        }

        @Override
        public String printFloat(Float d, int targetType) {
            return this.datatypeConverter.printFloat(d.floatValue());
        }

        @Override
        public String printString(String str, int targetType) {
            return str;
        }

        @Override
        public String print(Object val, int valueType) {
            if (val == null) {
                return null;
            }
            switch (valueType) {
                case 15: {
                    return this.datatypeConverter.printAnySimpleType((String)val);
                }
                case 7: {
                    return this.datatypeConverter.printBase64Binary((byte[])val);
                }
                case 4: {
                    return this.datatypeConverter.printBoolean((Boolean)val);
                }
                case 9: {
                    return this.datatypeConverter.printByte((Byte)val);
                }
                case 1: {
                    if (val instanceof Calendar) {
                        return this.datatypeConverter.printDateTime((Calendar)val);
                    }
                    Calendar c = Calendar.getInstance();
                    c.setTime((Date)val);
                    return this.datatypeConverter.printDateTime(c);
                }
                case 2: {
                    if (val instanceof Calendar) {
                        return this.datatypeConverter.printDate((Calendar)val);
                    }
                    Calendar c = Calendar.getInstance();
                    c.setTime((Date)val);
                    return this.datatypeConverter.printDate(c);
                }
                case 5: 
                case 6: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 16: 
                case 17: 
                case 18: {
                    return String.valueOf(val);
                }
                case 8: {
                    return this.datatypeConverter.printHexBinary((byte[])val);
                }
            }
            return String.valueOf(val);
        }

        @Override
        public String printBytes(byte[] bytes, int targetType) {
            return this.datatypeConverter.printBase64Binary(bytes);
        }
    }

    public static class DefaultXmlParserProvider
    extends ParserProvider {
        DateFormat df = new SimpleDateFormat("yyyy");
        AbstractParser<Short> shortParser = new AbstractParser.AbstractShortParser(){

            @Override
            public Short parse(String value) {
                return datatypeConverter.parseShort(value);
            }
        };
        AbstractParser<Integer> intParser = new AbstractParser.AbstractIntegerParser(){

            @Override
            public Integer parse(String value) {
                return datatypeConverter.parseInt(value);
            }
        };
        AbstractParser<BigInteger> integerParser = new AbstractParser.AbstractBigIntegerParser(){

            @Override
            public BigInteger parse(String value) {
                return datatypeConverter.parseInteger(value);
            }
        };
        AbstractParser<String> stringParser = new AbstractParser.AbstractStringParser(){

            @Override
            public String parse(String value) {
                return datatypeConverter.parseString(value);
            }
        };
        AbstractParser<Float> floatParser = new AbstractParser.AbstractFloatParser(){

            @Override
            public Float parse(String value) {
                return Float.valueOf(datatypeConverter.parseFloat(value));
            }
        };
        AbstractParser<Byte> byteParser = new AbstractParser.AbstractByteParser(){

            @Override
            public Byte parse(String value) {
                return datatypeConverter.parseByte(value);
            }
        };
        AbstractParser<byte[]> hexBinaryParser = new AbstractParser<byte[]>(){

            @Override
            public byte[] parse(String value) {
                return datatypeConverter.parseHexBinary(value);
            }

            @Override
            public void setJdbcStatement(PreparedStatement ps, int index, byte[] value, boolean wasNull, int targetColType, JdbcWriterProperties converter) throws SQLException {
                JdbcConverter.convertBytes(ps, index, value, targetColType);
            }
        };
        AbstractParser<byte[]> base64BinaryParser = new AbstractParser<byte[]>(){

            @Override
            public byte[] parse(String value) {
                return datatypeConverter.parseBase64Binary(value);
            }

            @Override
            public void setJdbcStatement(PreparedStatement ps, int index, byte[] value, boolean wasNull, int targetColType, JdbcWriterProperties converter) throws SQLException {
                JdbcConverter.convertBytes(ps, index, value, targetColType);
            }
        };
        AbstractParser<String> base64BinaryParserToFile = new AbstractParser<String>(){

            @Override
            public String parse(String value) throws EngineExceptionI {
                byte[] ret = datatypeConverter.parseBase64Binary(value);
                File file = new File(dataTypeProvider.getExtractBase64BinaryPath(), "base64Binary_" + UUID.randomUUID().toString() + ".data");
                try {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (FileOutputStream os = new FileOutputStream(file);){
                        ((OutputStream)os).write(ret);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    throw new EngineExceptionI(Messages.getString("XmlDataTypeProvider.0"), e);
                }
                return file.getAbsolutePath();
            }

            @Override
            public void setJdbcStatement(PreparedStatement ps, int index, String value, boolean wasNull, int targetColType, JdbcWriterProperties converter) throws SQLException {
                JdbcConverter.convertString(ps, index, value, targetColType, false, converter);
            }
        };
        AbstractParser<BigDecimal> decimalParser = new AbstractParser.AbstractBigDecimalParser(){

            @Override
            public BigDecimal parse(String value) {
                return datatypeConverter.parseDecimal(value);
            }
        };
        AbstractParser<Long> longParser = new AbstractParser.AbstractLongParser(){

            @Override
            public Long parse(String value) {
                return datatypeConverter.parseLong(value);
            }
        };
        AbstractParser<Double> doubleParser = new AbstractParser.AbstractDoubleParser(){

            @Override
            public Double parse(String value) {
                return datatypeConverter.parseDouble(value);
            }
        };
        AbstractParser<Boolean> booleanParser = new AbstractParser.AbstractBooleanParser(){

            @Override
            public Boolean parse(String value) {
                return datatypeConverter.parseBoolean(value);
            }
        };
        AbstractParser<Time> timeParser = new AbstractParser.AbstractTimeParser(){

            @Override
            public Time parse(String value) {
                return new Time(datatypeConverter.parseTime(value).getTimeInMillis());
            }
        };
        AbstractParser<Date> dateParser = new AbstractParser.AbstractDateParser(){

            @Override
            public Date parse(String value) {
                if (value != null && value.length() >= 4) {
                    String year = value.substring(0, 4);
                    try {
                        int _year = Integer.valueOf(year);
                        if (_year < 1583) {
                            String _value = "1583" + value.substring(4);
                            long l = datatypeConverter.parseDate(_value).getTimeInMillis();
                            long offset = df.parse("1583").getTime() - df.parse(year).getTime();
                            return new Date(l -= offset);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return new Date(datatypeConverter.parseDate(value).getTimeInMillis());
            }
        };
        AbstractParser<Timestamp> dateTimeParser = new AbstractParser.AbstractTimestampParser(){

            @Override
            public Timestamp parse(String value) {
                if (value != null && value.length() >= 4) {
                    String year = value.substring(0, 4);
                    try {
                        int _year = Integer.valueOf(year);
                        if (_year < 1583) {
                            String _value = "1583" + value.substring(4);
                            long l = datatypeConverter.parseDateTime(_value).getTimeInMillis();
                            long offset = df.parse("1583").getTime() - df.parse(year).getTime();
                            return new Timestamp(l -= offset);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return new Timestamp(datatypeConverter.parseDateTime(value).getTimeInMillis());
            }
        };

        public DefaultXmlParserProvider(AbstractDataTypeConverter dataTypeProvider) {
            super(dataTypeProvider);
        }

        @Override
        public AbstractParser getParser(int type) {
            switch (type) {
                case 1: {
                    return this.dateTimeParser;
                }
                case 2: {
                    return this.dateParser;
                }
                case 3: {
                    return this.timeParser;
                }
                case 4: {
                    return this.booleanParser;
                }
                case 18: {
                    return this.longParser;
                }
                case 5: {
                    return this.doubleParser;
                }
                case 6: {
                    return this.decimalParser;
                }
                case 7: {
                    if (this.dataTypeProvider.isExtractBase64binaryToFile()) {
                        return this.base64BinaryParserToFile;
                    }
                    return this.base64BinaryParser;
                }
                case 8: {
                    return this.hexBinaryParser;
                }
                case 9: {
                    return this.byteParser;
                }
                case 10: {
                    return this.floatParser;
                }
                case 12: {
                    return this.integerParser;
                }
                case 13: {
                    return this.intParser;
                }
                case 14: {
                    return this.shortParser;
                }
                case 11: 
                case 16: 
                case 17: {
                    return this.stringParser;
                }
            }
            return this.stringParser;
        }
    }
}

