/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.core.actionCodes.json.internal;

import com.indy.engine.core.actionCodes.json.internal.JsonObjectException;
import com.indy.engine.core.actionCodes.json.internal.Messages;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class JsonXmlReader {
    BufferedReader bufferedReader;
    protected static final char START_OBJECT = '{';
    protected static final char END_OBJECT = '}';
    protected static final char STRING = '\"';
    protected static final char PAIR_SEPARATOR = ':';
    protected static final char OBJECT_SEPARATOR = ',';
    protected static final char START_ARRAY = '[';
    protected static final char END_ARRAY = ']';
    protected static final char ESCAPE_CHAR = '\\';
    private static final String[] literals = new String[]{"null", "true", "false"};
    protected int countQuote = 0;
    protected int charCount = 0;
    protected int lineCount = 0;
    protected int columnCount = 0;
    protected boolean allRead = false;

    public JsonXmlReader(InputStream is) {
        this.bufferedReader = new BufferedReader(new InputStreamReader(is));
    }

    public abstract JsonObject readNext() throws Exception;

    public boolean hasNext() {
        return !this.allRead;
    }

    public void close() throws Exception {
        this.bufferedReader.close();
    }

    public char[] asCharArray(JsonObject o) throws Exception {
        return o.getName().toCharArray();
    }

    public static class JsonObject {
        private final Logger logger = LogManager.getLogger(this.getClass());
        int eventType;
        String name;
        boolean isLiteral = false;
        int columnCount;
        int lineCount;
        int charNumber;
        int attributePosition;

        public JsonObject(int eventType, String name, boolean isLiteral, int columnCount, int lineCount, int charNumber) throws JsonObjectException {
            this.eventType = eventType;
            this.name = name;
            this.isLiteral = isLiteral;
            this.columnCount = columnCount;
            this.lineCount = lineCount;
            this.charNumber = charNumber;
            if (isLiteral) {
                this.checkLiteral();
            }
        }

        public JsonObject(int eventType, String name, boolean isLiteral, int columnCount, int lineCount, int charNumber, int pos) throws JsonObjectException {
            this(eventType, name, isLiteral, columnCount, lineCount, charNumber);
            this.attributePosition = pos;
        }

        private void checkLiteral() throws JsonObjectException {
            String[] stringArray = literals;
            int n = literals.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s.equals(this.name)) {
                    return;
                }
                ++n2;
            }
            try {
                Double.valueOf(this.name);
                return;
            }
            catch (Exception ex) {
                this.logger.debug("Not a number", (Throwable)ex);
                throw new JsonObjectException(Messages.getString("JsonXmlReader.0"), this.name, this.charNumber, this.lineCount, this.columnCount);
            }
        }

        public int getEventType() {
            return this.eventType;
        }

        public String getName() {
            return this.name;
        }

        public boolean isLiteral() {
            return this.isLiteral;
        }

        public int getColumnCount() {
            return this.columnCount;
        }

        public int getLineCount() {
            return this.lineCount;
        }

        public int getCharNumber() {
            return this.charNumber;
        }

        public int getAttributePosition() {
            return this.attributePosition;
        }

        String getType() {
            switch (this.eventType) {
                case 2: {
                    return "END_ELEMENT";
                }
                case 4: {
                    return "CHARACTERS";
                }
                case 8: {
                    return "END_DOCUMENT";
                }
                case 6: {
                    return "SPACE";
                }
                case 7: {
                    return "START_DOCUMENT";
                }
                case 1: {
                    return "START_ELEMENT";
                }
            }
            return "unknown";
        }
    }
}

