/*
 * Decompiled with CFR 0.152.
 */
package com.indy.runtime.json;

import com.indy.runtime.json.JSonEvent;
import jakarta.xml.bind.DatatypeConverter;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.LinkedList;
import javax.xml.stream.XMLStreamException;

public class JsonEventWriter
implements AutoCloseable {
    private PrintWriter writer;
    private CharsetEncoder usedcharsetEncoder;
    private boolean skipStringEscaping = false;
    private boolean skipSlashCharacterEscaping = false;
    LinkedList<Element> parents = new LinkedList();
    boolean first = true;
    boolean last = false;
    int indentationLevel = 0;

    public Writer getWriter() {
        return this.writer;
    }

    public JsonEventWriter(OutputStream outputStream, String charsetName) throws XMLStreamException {
        Charset usedCharSet;
        if (charsetName != null) {
            try {
                this.writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream, charsetName)));
            }
            catch (UnsupportedEncodingException e) {
                throw new XMLStreamException(e);
            }
            usedCharSet = Charset.forName(charsetName);
        } else {
            this.writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream)));
            usedCharSet = Charset.defaultCharset();
        }
        this.usedcharsetEncoder = usedCharSet.newEncoder();
    }

    public void setSkipStringEscaping(boolean escape) {
        this.skipStringEscaping = escape;
    }

    public void setSkipSlashCharacterEscaping(boolean skipSlashCharacterEscaping) {
        this.skipSlashCharacterEscaping = skipSlashCharacterEscaping;
    }

    public void add(JSonEvent event) {
        this.add(event, false);
    }

    public void add(JSonEvent event, boolean prettyPrint) {
        Element parent;
        block50: {
            block49: {
                Element element = parent = this.parents.size() > 0 ? this.parents.getLast() : null;
                if (parent == null || parent.type != Type.Array && parent.type != Type.Object) break block49;
                switch (JsonEventWriter.$SWITCH_TABLE$com$indy$runtime$json$JSonEvent$Type()[event.getType().ordinal()]) {
                    case 7: {
                        if (parent.type == Type.Array) break block50;
                    }
                    case 1: 
                    case 5: 
                    case 8: 
                    case 9: {
                        if (parent.firstChild) {
                            parent.firstChild = false;
                            break;
                        }
                        this.writer.write(",");
                        if (prettyPrint) {
                            this.writer.write("\n");
                            break;
                        }
                    }
                    {
                        break block50;
                    }
                }
                break block50;
            }
            if (parent != null && parent.type == Type.Member) {
                this.parents.removeLast();
            }
        }
        if (parent == null && !this.first && this.last) {
            this.writer.write("\n");
        }
        if (prettyPrint) {
            switch (event.getType()) {
                case END_ARRAY: 
                case END_OBJECT: {
                    this.indentationLevel -= 2;
                    this.writer.write("\n");
                }
            }
            if (!JSonEvent.Type.MEMBER.equals((Object)event.getType())) {
                int i = 0;
                while (i < this.indentationLevel) {
                    this.writer.write(" ");
                    ++i;
                }
            }
        }
        block7 : switch (event.getType()) {
            case START_ITEM_ARRAY: {
                if (parent != null && parent.hasArrayOpen) break;
                parent.hasArrayOpen = true;
            }
            case START_ARRAY: {
                this.writer.write("[");
                Element elt = new Element();
                elt.type = Type.Array;
                this.parents.add(elt);
                break;
            }
            case END_ARRAY: {
                this.writer.write("]");
                this.parents.removeLast();
                break;
            }
            case END_DOCUMENT: {
                break;
            }
            case END_OBJECT: {
                this.writer.write("}");
                this.parents.removeLast();
                break;
            }
            case MEMBER: {
                if (parent == null || parent.type != Type.Object) break;
                Element elt = new Element();
                elt.type = Type.Member;
                this.parents.add(elt);
                this.writer.write("\"");
                this.writer.write(this.skipStringEscaping ? event.getName() : JsonEventWriter.escapeString(event.getName(), this.usedcharsetEncoder, this.skipSlashCharacterEscaping));
                this.writer.write("\"");
                this.writer.write(":");
                break;
            }
            case START_DOCUMENT: {
                break;
            }
            case START_OBJECT: {
                this.writer.write("{");
                Element elt = new Element();
                elt.type = Type.Object;
                this.parents.add(elt);
                break;
            }
            case STRING: {
                this.writer.write("\"");
                this.writer.write(this.skipStringEscaping ? event.getName() : JsonEventWriter.escapeString(event.getName(), this.usedcharsetEncoder, this.skipSlashCharacterEscaping));
                this.writer.write("\"");
                break;
            }
            case VALUE: {
                if (event.getBsonDataType() != -2) {
                    switch (event.getBsonDataType()) {
                        case 5: {
                            this.writer.write("{\"$binary\":");
                            this.writer.write("\"");
                            this.writer.write(event.getName());
                            this.writer.write("\", \"$type\":\"0\"");
                            this.writer.write("}");
                            break block7;
                        }
                        case 1: 
                        case 8: 
                        case 16: {
                            this.writer.write(event.getName());
                            break block7;
                        }
                        case 9: {
                            this.writer.write("{\"$date\":");
                            String data = event.getName();
                            if (data.contains("-")) {
                                this.writer.write(String.valueOf(DatatypeConverter.parseDateTime((String)data).getTime().getTime()));
                            } else {
                                this.writer.write(data);
                            }
                            this.writer.write("}");
                            break block7;
                        }
                        case 18: {
                            this.writer.write("{\"$numberLong\":");
                            this.writer.write("\"");
                            this.writer.write(event.getName());
                            this.writer.write("\"");
                            this.writer.write("}");
                            break block7;
                        }
                        case 13: {
                            this.writer.write("{\"$code\":");
                            this.writer.write("\"");
                            this.writer.write(event.getName());
                            this.writer.write("\"");
                            this.writer.write("}");
                            break block7;
                        }
                        case 15: {
                            this.writer.write("{\"$code\":");
                            this.writer.write("\"");
                            this.writer.write(event.getName());
                            this.writer.write("\"");
                            this.writer.write("}");
                            break block7;
                        }
                        case 14: {
                            this.writer.write("{\"$symbol\":");
                            this.writer.write("\"");
                            this.writer.write(event.getName());
                            this.writer.write("\"");
                            this.writer.write("}");
                            break block7;
                        }
                        case 11: {
                            this.writer.write("{\"$regex\":");
                            this.writer.write("\"");
                            this.writer.write(event.getName());
                            this.writer.write("\"");
                            this.writer.write("}");
                            break block7;
                        }
                        case 7: {
                            this.writer.write("{\"$oid\":");
                            this.writer.write("\"");
                            this.writer.write(event.getName());
                            this.writer.write("\"");
                            this.writer.write("}");
                            break block7;
                        }
                    }
                    this.writer.write(event.getName());
                    break;
                }
                this.writer.write(event.getName());
            }
        }
        if (event.getType() == JSonEvent.Type.START_DOCUMENT) {
            this.first = true;
        }
        if (event.getType() != JSonEvent.Type.START_DOCUMENT) {
            this.first = false;
        }
        if (event.getType() == JSonEvent.Type.END_DOCUMENT) {
            this.last = true;
        }
        if (event.getType() != JSonEvent.Type.END_DOCUMENT) {
            this.last = false;
        }
        if (prettyPrint) {
            switch (event.getType()) {
                case START_ARRAY: 
                case START_OBJECT: {
                    this.indentationLevel += 2;
                    this.writer.write("\n");
                }
            }
        }
    }

    static String escapeString(String val, CharsetEncoder charsetEncoder, boolean skipSlashCharacterEscaping) {
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < val.length()) {
            char c = val.charAt(i);
            switch (c) {
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': {
                    String hex = Integer.toHexString(c).toUpperCase();
                    b.append("\\u");
                    b.append(String.format("%4s", hex).replace(" ", "0"));
                    break;
                }
                case '\b': {
                    b.append("\\b");
                    break;
                }
                case '\t': {
                    b.append("\\t");
                    break;
                }
                case '\n': {
                    b.append("\\n");
                    break;
                }
                case '\u000b': {
                    String hex = Integer.toHexString(c).toUpperCase();
                    b.append("\\u");
                    b.append(String.format("%4s", hex).replace(" ", "0"));
                    break;
                }
                case '\f': {
                    b.append("\\f");
                    break;
                }
                case '\r': {
                    b.append("\\r");
                    break;
                }
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    String hex = Integer.toHexString(c).toUpperCase();
                    b.append("\\u");
                    b.append(String.format("%4s", hex).replace(" ", "0"));
                    break;
                }
                case '\"': {
                    b.append("\\\"");
                    break;
                }
                case '/': {
                    if (!skipSlashCharacterEscaping) {
                        b.append("\\");
                    }
                    b.append("/");
                    break;
                }
                case '\\': {
                    b.append("\\\\");
                    break;
                }
                default: {
                    String hex;
                    if (!charsetEncoder.canEncode(c)) break;
                    CharBuffer buf = CharBuffer.wrap(new char[]{c});
                    try {
                        charsetEncoder.encode(buf);
                        b.append(c);
                        break;
                    }
                    catch (CharacterCodingException e) {
                        hex = Integer.toHexString(c).toUpperCase();
                        b.append("\\u");
                        b.append(String.format("%4s", hex).replace(" ", "0"));
                    }
                }
            }
            ++i;
        }
        return b.toString();
    }

    @Override
    public void close() {
        this.writer.close();
    }

    public void flush() {
        this.writer.flush();
    }

    class Element {
        Type type;
        boolean firstChild = true;
        boolean hasArrayOpen = false;

        Element() {
        }
    }

    class Parent {
        Type type;

        Parent() {
        }
    }

    static enum Type {
        Array,
        Object,
        Member;

    }
}

