/*
 * Decompiled with CFR 0.152.
 */
package com.indy.runtime.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class SSLUtils {
    private SSLUtils() {
    }

    public static TrustManager[] loadTrustStore(String keyStoreFile, String keyStoreType, String keyStorePassword) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        char[] keystorepass = keyStorePassword.toCharArray();
        File keystoreFile = new File(keyStoreFile);
        KeyStore keyStore = null;
        keyStore = KeyStore.getInstance(keyStoreType);
        keyStore.load(new FileInputStream(keystoreFile), keystorepass);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        return trustManagerFactory.getTrustManagers();
    }

    public static KeyManager[] loadKeyStore(String keyStoreFile, String keyStoreType, String keyStorePassword) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, CertificateException, IOException {
        char[] keystorepass = keyStorePassword.toCharArray();
        File keystoreFile = new File(keyStoreFile);
        KeyStore keyStore = null;
        keyStore = KeyStore.getInstance(keyStoreType);
        keyStore.load(new FileInputStream(keystoreFile), keystorepass);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, keystorepass);
        return keyManagerFactory.getKeyManagers();
    }
}

