/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.conf.custom.toolbar;

import com.indy.ui.conf.custom.internal.ConfigurationProvider;
import com.indy.ui.conf.custom.preference.ConfPreferenceConstants;
import com.indy.ui.custom.out.services.IConfigurationAuthenticator;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.stambia.cfc.IConfigurationProvider;
import java.util.Collection;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;

public class ListCfc
extends WorkbenchWindowControlContribution {
    private ComboViewer cv;
    private Runnable cfcChangeHook = () -> {
        this.handledInputChanges();
        this.cv.getCombo().setEnabled(true);
        this.cv.refresh(true);
    };
    private IConfigurationProvider provider;

    public void dispose() {
        this.provider.setConfigurationHandler(null);
        super.dispose();
    }

    protected Control createControl(Composite parent) {
        parent.getParent().setRedraw(true);
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout());
        ((GridLayout)c.getLayout()).marginHeight = 0;
        ((GridLayout)c.getLayout()).marginWidth = 0;
        this.cv = new ComboViewer(c, 8);
        GridData gd = new GridData(4, 4, true, true);
        gd.minimumWidth = ConfPreferenceConstants.getInteger("configurations.width");
        this.cv.getCombo().setLayoutData((Object)gd);
        this.cv.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.cv.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                Collection confs = ListCfc.this.provider.getAllConfiguration();
                return confs.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.cv.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (ConfigurationProvider.defaultConf == e1) {
                    return -1;
                }
                if (ConfigurationProvider.defaultConf == e2) {
                    return 1;
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.cv.getCombo().setEnabled(false);
        this.cv.getCombo().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String conf = ListCfc.this.cv.getCombo().getItem(ListCfc.this.cv.getCombo().getSelectionIndex());
                IConfigurationAuthenticator authenticator = (IConfigurationAuthenticator)E4InjectorHelper.getService(IConfigurationAuthenticator.class);
                if (authenticator.validateConfigurationCredentials(conf, IConfigurationAuthenticator.Mode.SELECTION)) {
                    ListCfc.this.provider.setConfiguration(conf);
                } else {
                    ListCfc.this.handledInputChanges();
                }
            }
        });
        this.provider = (IConfigurationProvider)E4InjectorHelper.getService(IConfigurationProvider.class);
        this.provider.setConfigurationHandler(this.cfcChangeHook);
        return c;
    }

    public boolean isDynamic() {
        return true;
    }

    private void handledInputChanges() {
        this.cv.setInput((Object)"");
        IConfigurationProvider evaluationConfig = (IConfigurationProvider)E4InjectorHelper.getService(IConfigurationProvider.class);
        String conf = evaluationConfig.getConfiguration().getCode().getLocalPart();
        String def = "Default";
        int i = -1;
        int index = -1;
        int indexD = -1;
        String[] stringArray = this.cv.getCombo().getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            ++i;
            if (item.equals(conf)) {
                index = i;
                break;
            }
            if (item.equals(def)) {
                indexD = i;
            }
            ++n2;
        }
        if (index > -1) {
            this.cv.getCombo().select(index);
            evaluationConfig.setConfiguration(conf);
        } else if (indexD > -1) {
            evaluationConfig.setConfiguration(null);
            this.cv.getCombo().select(indexD);
        }
    }

    protected int computeWidth(Control control) {
        int width = super.computeWidth(control) + 10;
        return width < 100 ? 100 : width;
    }
}

