/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.ant;

import com.indy.engine.common.delivery.DeliveryBuilder;
import com.semarchy.xdi.designer.generation.ant.Helper;
import com.semarchy.xdi.designer.generation.ant.Messages;
import com.semarchy.xdi.designer.generation.xsl.gene.process.internal.configuration.MdConfigurationCompilation;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class MdConfigurationCallback
extends Task {
    public static final String XDG_MERGED_MD_PATH = "com.semarchy.xdi.designer.generation.ant.MdConfigurationCallback.xdgMergedMdPath";
    private String folderPath;
    private String modelName;
    private String extPrefix;
    private String extSuffix;
    private boolean externalize;
    private boolean preserveExternalizationOffset = false;

    public void setFolderPath(String folderPath) {
        this.folderPath = folderPath;
    }

    public void setExternalize(boolean externalize) {
        this.externalize = externalize;
    }

    public void setExtPrefix(String extPrefix) {
        this.extPrefix = extPrefix;
    }

    public void setExtSuffix(String extSuffix) {
        this.extSuffix = extSuffix;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public void setPreserveExternalizationOffset(boolean preserveExternalizationOffset) {
        this.preserveExternalizationOffset = preserveExternalizationOffset;
    }

    public void execute() throws BuildException {
        MdConfigurationCompilation mdCompiler = Helper.getHelper(this.getProject().getBaseDir().getPath(), this.getProject().getProperty("levelIconsPerDefType")).getMdCompiler();
        String outputFile = this.folderPath.replace("\\", "/").replace("/wrk1", "/wrk2");
        String configurationName = this.getProject().getProperty("conf");
        String configurationFileName = this.getProject().getProperty("conf.file");
        Properties properties = null;
        if (configurationFileName != null && !configurationFileName.isEmpty()) {
            try {
                properties = this.loadConfigurationFile(configurationFileName);
            }
            catch (FileNotFoundException ex) {
                this.log(String.format(Messages.MdConfigurationCallback_0, configurationFileName), 2);
            }
        }
        this.log(String.format(Messages.MdConfigurationCallback_1, this.folderPath, outputFile, configurationName));
        try {
            MdConfigurationCompilation.Result res = mdCompiler.compileMd(this.externalize, outputFile, this.folderPath, this.modelName, configurationName, this.extPrefix, this.extSuffix, properties, this.preserveExternalizationOffset);
            String xdgPath = res.getXDGAggregatedFile();
            if (xdgPath != null) {
                this.getProject().setProperty(XDG_MERGED_MD_PATH, xdgPath);
                this.log(String.format("%s=%s", XDG_MERGED_MD_PATH, xdgPath));
                this.log(String.format("resolution %s=${%s}", XDG_MERGED_MD_PATH, XDG_MERGED_MD_PATH));
            }
        }
        catch (Exception ex) {
            this.log(Messages.MdConfigurationCallback_2, ex, 0);
            throw new BuildException(ex.getMessage(), (Throwable)ex);
        }
    }

    private Properties loadConfigurationFile(String configurationFileName) throws FileNotFoundException {
        File file = new File(configurationFileName);
        if (!file.exists() || !file.isFile()) {
            throw new FileNotFoundException(String.format(Messages.MdConfigurationCallback_3, configurationFileName));
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream inputStream = new FileInputStream(file);){
                return DeliveryBuilder.readDeliveryConf((InputStream)inputStream, (String)StandardCharsets.UTF_8.name());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.log(String.format(Messages.MdConfigurationCallback_4, configurationFileName), e, 1);
            return null;
        }
    }
}

