/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.mapping;

import com.indy.map.Map;
import com.indy.map.compute.graph.Graph;
import com.indy.map.compute.graph.GraphBuilderFactory;
import com.indy.map.compute.graph.ISortedGraph;
import com.indy.map.ref.RMap;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IMappingBuilderDelegate;
import com.semarchy.xdi.designer.core.services.XDIModelURIResolver;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.core.utils.URIUtils;
import com.semarchy.xdi.designer.generation.mapping.Messages;
import com.semarchy.xdi.designer.generation.mapping.MetadataAndProcessBuilder;
import com.semarchy.xdi.designer.generation.mapping.internal.MappingBuilderV2;
import com.semarchy.xdi.designer.generation.mapping.internal.debug.DebugTool;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={IMappingBuilderDelegate.class})
public class MapBuilder
implements IMappingBuilderDelegate {
    private static final String MAPPING_BUILD_MODE_LEGACY = "com.semarchy.xdi.designer.generation.mapping.build.legacymode";
    private static final String MAPPING_BUILD_DIAGNOSTIC_MODE = "com.semarchy.xdi.designer.generation.mapping.build.diagnosticmode";
    @Reference
    EnvironmentInfo envInfos;
    Logger logger = LogManager.getLogger(MapBuilder.class);
    private File diagnosticFolder = null;

    private void doBuild(Map map, boolean fromWorkspace) throws Exception {
        if (!((RMap)map.getMapReference()).hasErrors()) {
            if (Boolean.TRUE.equals(Boolean.valueOf(this.envInfos.getProperty(MAPPING_BUILD_DIAGNOSTIC_MODE)))) {
                if (this.diagnosticFolder == null) {
                    this.diagnosticFolder = ((XDIModelURIResolver)E4InjectorHelper.getService(XDIModelURIResolver.class)).resolve(URI.createPlatformResourceURI((String)"global/__diagnosticMappingBuild/"));
                    this.diagnosticFolder.mkdirs();
                }
                MetadataAndProcessBuilder.build(map, fromWorkspace);
                MappingBuilderV2 builder = new MappingBuilderV2(map, fromWorkspace, true, Boolean.TRUE.equals(Boolean.valueOf(this.envInfos.getProperty("com.semarchy.xdi.xdg.harvesting.enabled"))));
                URI[] resURI = builder.build();
                DebugTool tool = new DebugTool();
                try {
                    tool.compareMdResult(this.diagnosticFolder, resURI[0], URIUtils.getMappingBuiltMdFile((URI)map.eResource().getURI()));
                }
                catch (Exception ex) {
                    this.logger.error("Diagnostic error", (Throwable)ex);
                }
                try {
                    tool.compareProcResult(this.diagnosticFolder, resURI[1], URIUtils.getMappingBuiltProcFile((URI)map.eResource().getURI()));
                }
                catch (Exception ex) {
                    this.logger.error("Diagnostic error", (Throwable)ex);
                }
            } else if (Boolean.TRUE.equals(Boolean.valueOf(this.envInfos.getProperty(MAPPING_BUILD_MODE_LEGACY)))) {
                MetadataAndProcessBuilder.build(map, fromWorkspace);
            } else {
                MappingBuilderV2 builder = new MappingBuilderV2(map, fromWorkspace, false, Boolean.TRUE.equals(Boolean.valueOf(this.envInfos.getProperty("com.semarchy.xdi.xdg.harvesting.enabled"))));
                builder.build();
            }
        } else if (fromWorkspace) {
            throw new Exception(NLS.bind((String)Messages.MapBuilder_1, (Object)map.eResource().getURI().toPlatformString(true)));
        }
    }

    public void prebuildMapping(Resource resource) throws Throwable {
        Map map = null;
        for (EObject o : resource.getContents()) {
            if (o.eContents().isEmpty()) continue;
            map = (Map)o.eContents().get(0);
            break;
        }
        if (map != null) {
            this.doBuild(map, false);
        }
    }

    public void buildMapping(Resource resource) throws Exception {
        Map map = null;
        for (EObject o : resource.getContents()) {
            if (o.eContents().isEmpty()) continue;
            map = (Map)o.eContents().get(0);
            break;
        }
        if (map != null) {
            this.doBuild(map, true);
        }
    }

    public boolean canBeBuilt(Resource resource) {
        Map map = null;
        for (EObject o : resource.getContents()) {
            if (o.eContents().isEmpty()) continue;
            map = (Map)o.eContents().get(0);
            break;
        }
        return map != null && !((RMap)map.getMapReference()).hasErrors();
    }

    public List<String> getPrebuiltFilesPath(URI mappingURI) throws Exception {
        String id = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).getSourceId(mappingURI);
        ArrayList<String> res = new ArrayList<String>();
        Bundle bundle = Platform.getBundle((String)"com.indy.gmf.map");
        IPath path = Platform.getStateLocation((Bundle)bundle);
        path = path.append("/tempBuiltFiles");
        res.add(path.append(id + ".md").toFile().getAbsolutePath());
        res.add(path.append(id + ".proc").toFile().getAbsolutePath());
        File[] files = path.toFile().listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File ff = fileArray[n2];
                if (ff.getName().startsWith(id + "-ref-") && ff.getName().endsWith(".md")) {
                    res.add(ff.getAbsolutePath());
                }
                ++n2;
            }
        }
        return res;
    }

    public Collection<String> getAllDependancies(URI f) {
        HashSet<String> res = new HashSet<String>();
        try {
            Graph g = GraphBuilderFactory.INSTANCE.getGraphBuilder(GraphBuilderFactory.GraphType.RESOURCE_DEPENDENCY, Collections.singleton(f));
            if (g instanceof ISortedGraph) {
                for (URI uri : ((ISortedGraph)g).getAllSortedModelItem()) {
                    String id = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).getSourceId(uri);
                    if (id == null) continue;
                    res.add(id);
                }
            }
        }
        catch (Exception t) {
            this.logger.error("Failed to compute dependancies for {}", (Object)f, (Object)t);
        }
        return res;
    }
}

