/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.mapping.internal.debug;

import com.semarchy.xdi.designer.generation.mapping.internal.debug.SimpleLineComparator;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;

class MdDiffAnalizer {
    private MdDiffAnalizer() {
    }

    static boolean hasDiff(InputStream newModel, InputStream legacyModel) throws IOException {
        MdDiffAnalizer a = new MdDiffAnalizer();
        return a.checkRelevantDiff(newModel, legacyModel);
    }

    boolean checkRelevantDiff(InputStream newModel, InputStream legacyModel) throws IOException {
        RangeDifference[] diffs;
        SimpleLineComparator legacyComparator = new SimpleLineComparator(legacyModel, StandardCharsets.UTF_8);
        SimpleLineComparator newComparator = new SimpleLineComparator(newModel, StandardCharsets.UTF_8);
        RangeDifference[] rangeDifferenceArray = diffs = RangeDifferencer.findDifferences((IRangeComparator)newComparator, (IRangeComparator)legacyComparator);
        int n = diffs.length;
        int n2 = 0;
        while (n2 < n) {
            RangeDifference diff = rangeDifferenceArray[n2];
            if (diff.kind() == 2) {
                HashMap<String, Set<String>> legacyValues = new HashMap<String, Set<String>>();
                int j = diff.rightStart();
                while (j <= diff.rightEnd()) {
                    ValueEntry e = this.parseLine(legacyComparator.lines.get(j));
                    legacyValues.put(e.key, e.values);
                    ++j;
                }
                HashMap<String, Set<String>> newValues = new HashMap<String, Set<String>>();
                int j2 = diff.leftStart();
                while (j2 <= diff.leftEnd()) {
                    ValueEntry e = this.parseLine(newComparator.lines.get(j2));
                    newValues.put(e.key, e.values);
                    ++j2;
                }
                if (!this.isDiffExpected(legacyValues, newValues)) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    private boolean isDiffExpected(Map<String, Set<String>> legacyValues, Map<String, Set<String>> newValues) {
        List<String> expectedNewProps = List.of("sourceContainers", "sourceNames", "number", "mdNodeFieldReference");
        for (Map.Entry<String, Set<String>> e : newValues.entrySet()) {
            boolean addedExpected = expectedNewProps.contains(e.getKey());
            if (!(legacyValues.containsKey(e.getKey()) ? !e.getValue().containsAll((Collection)legacyValues.get(e.getKey())) : !addedExpected)) continue;
            return false;
        }
        for (Map.Entry<String, Set<String>> e : legacyValues.entrySet()) {
            if (!newValues.containsKey(e.getKey())) {
                return false;
            }
            if (newValues.get(e.getKey()).containsAll((Collection)e.getValue())) continue;
            return false;
        }
        return true;
    }

    private ValueEntry parseLine(String line) {
        String data = line.strip();
        int separator = data.indexOf(":");
        ValueEntry res = new ValueEntry();
        res.key = data.substring(0, separator);
        String vals = data.substring(separator + 1);
        if (vals.startsWith("[") && vals.endsWith("]")) {
            vals = vals.substring(1, vals.length() - 1);
            Stream.of(vals.split(",")).sorted(Comparable::compareTo).forEach(s -> {
                boolean bl = valueEntry.values.add((String)s);
            });
        } else {
            res.values.add(vals);
        }
        return res;
    }

    private class ValueEntry {
        String key;
        Set<String> values = new LinkedHashSet<String>();

        private ValueEntry() {
        }
    }
}

