/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.mapping.internal.debug;

import com.semarchy.xdi.designer.generation.mapping.internal.debug.DebugMdModel;
import com.semarchy.xdi.designer.generation.mapping.internal.debug.DebugProcModel;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class ProcModelSerializer {
    BufferedWriter writer;

    ProcModelSerializer() {
    }

    static void serializeModel(DebugProcModel model, File outputFile) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile, StandardCharsets.UTF_8));){
            ProcModelSerializer serializer = new ProcModelSerializer();
            serializer.writer = writer;
            serializer.serialize(model);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private List<Field> getFields(Class c) {
        Predicate<Field> filter = f -> !Collection.class.isAssignableFrom(f.getType()) || ((ParameterizedType)f.getGenericType()).getActualTypeArguments()[0] == String.class;
        Stream<Field> fields = Arrays.asList(c.getDeclaredFields()).stream().filter(filter).filter(f -> !f.isAnnotationPresent(Ignored.class));
        if (DebugProcModel.ProcStep.class.isAssignableFrom(c)) {
            fields = Stream.concat(fields, Arrays.asList(DebugProcModel.ProcStep.class.getDeclaredFields()).stream().filter(filter));
        }
        return fields.sorted((f1, f2) -> f1.getName().compareTo(f2.getName())).collect(Collectors.toList());
    }

    private void serialize(DebugProcModel model) throws Exception {
        for (DebugProcModel.ProcStep s : model.steps.stream().sorted((s1, s2) -> s1.name.compareTo(s2.name)).collect(Collectors.toList())) {
            String stepType = null;
            stepType = s instanceof DebugProcModel.ProcStepReference ? "ProcessRef" : (s instanceof DebugProcModel.ProcActionCode ? "ActionCode" : (s instanceof DebugProcModel.SubStep ? "Subprocess" : "Process"));
            this.writer.write(String.format("-%s:%s", stepType, s.name));
            this.writer.newLine();
            this.serializeSimpleProperties(s, this.getFields(s.getClass()), 2);
            s.mdLinks.stream().sorted((s1, s2) -> s1.name.compareTo(s2.name)).forEach(l -> {
                try {
                    this.writer.write("-Metadata: ");
                    this.writer.write(l.name);
                    this.writer.newLine();
                    this.serializeSimpleProperties(l, this.getFields(l.getClass()), 4);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            s.params.stream().sorted((s1, s2) -> s1.name.compareTo(s2.name)).forEach(l -> {
                try {
                    this.writer.write("-Parameter: ");
                    this.writer.write(l.name);
                    this.writer.newLine();
                    this.serializeSimpleProperties(l, this.getFields(l.getClass()), 4);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        model.links.entrySet().stream().sorted((e1, e2) -> ((String)e1.getKey()).compareTo((String)e2.getKey())).forEach(e -> {
            for (String trg : ((Collection)e.getValue()).stream().sorted((s1, s2) -> s1.compareTo((String)s2)).collect(Collectors.toList())) {
                try {
                    this.writer.write("-Link: ");
                    this.writer.newLine();
                    this.writeOffset(2);
                    this.writer.write("-src:");
                    this.writer.write((String)e.getKey());
                    this.writer.newLine();
                    this.writer.write("-trg:");
                    this.writer.write(trg);
                    this.writer.newLine();
                }
                catch (Exception e1) {
                    throw new RuntimeException(e1);
                }
            }
        });
    }

    private void writeOffset(int offset) throws IOException {
        int i = 0;
        while (i < offset) {
            this.writer.write(" ");
            ++i;
        }
    }

    private void serializeSimpleProperties(Object bean, List<Field> fields, int offset) throws Exception {
        for (Field f : fields) {
            Object res = f.get(bean);
            if (res == null && (!(res instanceof DebugMdModel.PlaceHolder) || ((DebugMdModel.PlaceHolder)res).isNull())) continue;
            this.writeOffset(offset);
            this.writer.write(f.getName() + ":");
            if (Collection.class.isAssignableFrom(f.getType())) {
                String w = ((Collection)res).stream().map(o -> o.toString()).sorted().collect(Collectors.joining(",", "[", "]"));
                this.writer.write(w);
            } else {
                this.writer.write(res.toString());
            }
            this.writer.newLine();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Ignored {
    }
}

