/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.proc.diagram.non_rcp.custom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class CustomCompletionProcessor
implements IContentAssistProcessor {
    private static final ICompletionProposal[] NO_PROPOSALS = new ICompletionProposal[0];
    private static final IContextInformation[] NO_CONTEXTS = new IContextInformation[0];
    private char[] characters;
    private List values;

    public CustomCompletionProcessor(List values) {
        this.values = values;
        this.characters = new char[values.size()];
        Iterator it = values.iterator();
        int i = 0;
        while (it.hasNext()) {
            String value = (String)it.next();
            this.characters[i] = value.charAt(0);
        }
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        try {
            String prefix = this.getPrefix(viewer, offset);
            if (prefix == null || prefix.length() == 0) {
                return NO_PROPOSALS;
            }
            List suggestions = this.getSuggestions(prefix);
            ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
            for (String string : suggestions) {
                if (string.length() <= 0) continue;
                result.add(this.createProposal(string, prefix, offset));
            }
            return result.toArray(new ICompletionProposal[result.size()]);
        }
        catch (BadLocationException x) {
            return NO_PROPOSALS;
        }
    }

    private ICompletionProposal createProposal(String string, String prefix, int offset) {
        return new CompletionProposal(string, offset, string.length(), offset + string.length());
    }

    private List getSuggestions(String prefix) {
        ArrayList<String> suggestions = new ArrayList<String>();
        for (String value : this.values) {
            if (!value.startsWith(prefix)) continue;
            suggestions.add(new String(value));
        }
        return suggestions;
    }

    private String getPrefix(ITextViewer viewer, int offset) throws BadLocationException {
        IDocument doc = viewer.getDocument();
        if (doc == null || offset > doc.getLength()) {
            return null;
        }
        int length = 0;
        while (--offset >= 0 && Character.isJavaIdentifierPart(doc.getChar(offset))) {
            ++length;
        }
        return doc.get(offset + 1, length);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return NO_CONTEXTS;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.characters;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return this.characters;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }
}

