/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.proc.diagram.non_rcp.custom.action;

import com.indy.gmf.proc.ActionCode;
import com.indy.gmf.proc.Parameter;
import com.indy.gmf.proc.XslVariable;
import com.indy.gmf.proc.XslVariableType;
import com.indy.gmf.proc.diagram.non_rcp.messages.Messages;
import com.indy.libraries.build.utils.StringUtils;
import com.semarchy.xdi.designer.generation.xsl.global.XPathEvaluatorI;
import java.io.StringReader;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.xpath.XPathConstants;
import net.sf.saxon.AugmentedSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.xml.sax.InputSource;

public class ParseAction
implements IObjectActionDelegate {
    private EObject selectedElement;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        String code = null;
        if (this.selectedElement instanceof Parameter) {
            code = ((Parameter)this.selectedElement).getValue();
        } else if (this.selectedElement instanceof ActionCode) {
            code = ((ActionCode)this.selectedElement).getCode();
        } else if (this.selectedElement instanceof XslVariable) {
            code = ((XslVariable)this.selectedElement).getCode();
            if (((XslVariable)this.selectedElement).getType().equals((Object)XslVariableType.XPATH)) {
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ParseAction_0, (String)Messages.ParseAction_1);
                return;
            }
        }
        if (code == null || code.trim().isEmpty()) {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ParseAction_6, (String)Messages.ParseAction_7);
            return;
        }
        try {
            String preparedForParsingCode = StringUtils.prepareToParse1((String)code);
            NodeInfo n = ParseAction.parseXslExpression(preparedForParsingCode);
            XPathEvaluatorI xe = new XPathEvaluatorI(n.getConfiguration());
            xe.initNamespaces();
            Object o = xe.evaluate("//indyParse:xsl", (Object)n, XPathConstants.NODESET);
            if (o instanceof List) {
                for (Object o2 : (List)o) {
                    if (!(o2 instanceof NodeInfo)) continue;
                    String str = ((NodeInfo)o2).getStringValue();
                    ParseAction.parseXslExpression(str);
                }
            }
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ParseAction_3, (String)Messages.ParseAction_4);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ParseAction_5, (String)e.getMessage());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        GraphicalEditPart localselectedElement = (GraphicalEditPart)((StructuredSelection)selection).getFirstElement();
        if (localselectedElement != null) {
            this.selectedElement = localselectedElement.resolveSemanticElement();
        }
    }

    public static NodeInfo parseXslExpression(String expression) throws XPathException {
        Builder b;
        expression = "<root xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:proc=\"http://www.example.org/proc\" xmlns:deliv=\"http://www.stambia.com/deliv\" xmlns:jStr=\"java:com.semarchy.xdi.designer.generation.xsl.StringI\" xmlns:rdbms=\"http://www.example.org/rdbms\" xmlns:mdj=\"java:com.semarchy.xdi.designer.generation.xsl.global.Functions\" xmlns:mdv=\"java:com.semarchy.xdi.designer.generation.xsl.global.Variables\" xmlns:tech=\"http://www.stambia.com/tech\" xmlns:saxon=\"http://saxon.sf.net/\" >" + (String)expression;
        expression = (String)expression + "</root>";
        Configuration c = new Configuration();
        Controller controller = new Controller(c);
        StringReader sr = new StringReader((String)expression);
        InputSource is = new InputSource(sr);
        is.setSystemId("jiiji");
        SAXSource source = new SAXSource(is);
        source.setSystemId("jiiji");
        Builder s = b = controller.makeBuilder();
        source = AugmentedSource.makeAugmentedSource((Source)source);
        ((AugmentedSource)source).setStripSpace(4);
        if (controller.getExecutable().stripsInputTypeAnnotations()) {
            s = controller.getConfiguration().getAnnotationStripper((Receiver)s);
        }
        Sender sender = new Sender(controller.makePipelineConfiguration());
        sender.send((Source)source, (Receiver)s);
        NodeInfo node = b.getCurrentRoot();
        b.reset();
        return node;
    }
}

