/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.proc.diagram.non_rcp.edit.parts.figure;

import com.indy.ui.custom.out.tools.FigureColoringHelper;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.SlidableAnchor;
import org.eclipse.swt.graphics.Color;

public class CustomSizedNodeFigure
extends DefaultSizeNodeFigure {
    private WeakReference<ZoomManager> zoomManager;
    private Rectangle unAnchorableRegion;
    private List<IBackgroundColorChangeListener> bgListeners = new ArrayList<IBackgroundColorChangeListener>();
    boolean translateAcnhor = false;

    public CustomSizedNodeFigure(Dimension defSize) {
        this(defSize.width, defSize.height);
    }

    public boolean setUnAnchorableRegion(Rectangle bounds) {
        Rectangle oldBounds = this.unAnchorableRegion;
        this.unAnchorableRegion = bounds;
        if (bounds == null) {
            return oldBounds != null;
        }
        return !bounds.equals((Object)this.unAnchorableRegion);
    }

    public void setZoomManager(ZoomManager mgr) {
        this.zoomManager = new WeakReference<ZoomManager>(mgr);
    }

    public CustomSizedNodeFigure(int width, int height) {
        super(width, height);
        this.setMinimumSize(new Dimension(80, 40));
        this.setBackgroundColor(FigureColoringHelper.getColorAction());
    }

    public void addBackGroundColorListener(IBackgroundColorChangeListener listener) {
        this.bgListeners.add(listener);
    }

    public void removeBackGroundColorListener(IBackgroundColorChangeListener listener) {
        this.bgListeners.add(listener);
    }

    public void setBackgroundColor(Color bg) {
        Color old = this.getBackgroundColor();
        super.setBackgroundColor(bg);
        this.notifyBgColorChanged(old, bg);
    }

    private void notifyBgColorChanged(Color old, Color bg) {
        for (IBackgroundColorChangeListener l : this.bgListeners) {
            l.backgroundColorChanged(old, bg);
        }
    }

    public void setBounds(Rectangle rect) {
        super.setBounds(rect);
    }

    protected ConnectionAnchor createAnchor(PrecisionPoint p) {
        if (p == null) {
            return this.createDefaultAnchor();
        }
        return new CustomAnchor((IFigure)this, p);
    }

    protected ConnectionAnchor createDefaultAnchor() {
        return new CustomAnchor((IFigure)this);
    }

    public void setTranslateAnchor(boolean value) {
        this.translateAcnhor = value;
    }

    public class CustomAnchor
    extends SlidableAnchor {
        private boolean isWire;

        private CustomAnchor() {
            this.isWire = false;
        }

        private CustomAnchor(IFigure f, PrecisionPoint p) {
            super(f, p);
            this.isWire = false;
        }

        private CustomAnchor(IFigure f) {
            super(f);
            this.isWire = false;
        }

        protected PointList getIntersectionPoints(Point ownReference, Point foreignReference) {
            if (CustomSizedNodeFigure.this.translateAcnhor || this.isWire) {
                double zoom = CustomSizedNodeFigure.this.zoomManager.get() != null ? ((ZoomManager)CustomSizedNodeFigure.this.zoomManager.get()).getZoom() : 1.0;
                Rectangle r = CustomSizedNodeFigure.this.getBounds().getCopy();
                CustomSizedNodeFigure.this.translateToAbsolute((Translatable)r);
                if (CustomSizedNodeFigure.this.translateAcnhor) {
                    r = r.expand(20.0 * zoom, 20.0 * zoom);
                }
                if (this.isWire) {
                    r = r.expand(5.0 * zoom, 5.0 * zoom);
                }
                LineSeg seg = new LineSeg(ownReference, foreignReference);
                PointList pl = seg.getLinesIntersections(new LineSeg(r.getTopLeft(), r.getTopRight()));
                pl.addAll(seg.getLinesIntersections(new LineSeg(r.getTopLeft(), r.getBottomLeft())));
                pl.addAll(seg.getLinesIntersections(new LineSeg(r.getBottomLeft(), r.getBottomRight())));
                pl.addAll(seg.getLinesIntersections(new LineSeg(r.getTopRight(), r.getBottomRight())));
                ArrayList<Integer> toRemove = new ArrayList<Integer>();
                int i = 0;
                while (i < pl.size()) {
                    if (pl.getPoint((int)i).x < r.x || pl.getPoint((int)i).x > r.x + r.width || pl.getPoint((int)i).y < r.y || pl.getPoint((int)i).y > r.y + r.height) {
                        toRemove.add(i);
                    }
                    ++i;
                }
                int k = 0;
                for (Integer i2 : toRemove) {
                    pl.removePoint(i2 - k++);
                }
                return pl;
            }
            Rectangle r = CustomSizedNodeFigure.this.getBounds().getCopy();
            CustomSizedNodeFigure.this.translateToAbsolute((Translatable)r);
            PointList pl = this.getPolygonPoints();
            LineSeg seg = new LineSeg(ownReference, foreignReference);
            return seg.getLineIntersectionsWithLineSegs(pl);
        }

        protected Point getLocation(Point ownReference, Point foreignReference) {
            PointList intersections = this.getIntersectionPoints(ownReference, foreignReference);
            if (intersections != null && intersections.size() != 0) {
                Point location = PointListUtilities.pickClosestPoint((PointList)intersections, (Point)foreignReference);
                return location;
            }
            return null;
        }

        public void setIsWire(boolean b) {
            this.isWire = b;
        }
    }

    public static interface IBackgroundColorChangeListener {
        public void backgroundColorChanged(Color var1, Color var2);
    }
}

