/*
 * Decompiled with CFR 0.152.
 */
package com.indy.shell.parser;

import com.indy.shell.Messages;
import com.indy.shell.parser.ShellCommand;
import com.indy.shell.parser.ShellCommandParameter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CommandAnalyzer {
    private void setValue(Object trg, Field field, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, SecurityException {
        boolean b = field.isAccessible();
        try {
            field.setAccessible(true);
            if (field.getType() == Boolean.TYPE) {
                field.setBoolean(trg, Boolean.valueOf(value));
            } else if (field.getType() == Boolean.class) {
                field.set(trg, Boolean.valueOf(value));
            } else if (field.getType() == Integer.class || field.getType() == Integer.TYPE) {
                field.setInt(trg, Integer.valueOf(value));
            } else if (field.getType() == Long.class || field.getType() == Long.TYPE) {
                field.setLong(trg, Long.valueOf(value));
            } else if (field.getType().isEnum()) {
                field.set(trg, field.getType().getMethod("valueOf", String.class).invoke(null, value));
            } else {
                field.set(trg, value);
            }
        }
        finally {
            field.setAccessible(b);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void prepare(Object o, String commandArguments) throws Exception {
        Class<?> c = o.getClass();
        if (!c.isAnnotationPresent(ShellCommand.class)) return;
        Parser p = new Parser();
        CmdLine cmdLine = p.parse(commandArguments);
        Field[] fieldArray = c.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (f.isAnnotationPresent(ShellCommandParameter.class)) {
                ShellCommandParameter anno = f.getAnnotation(ShellCommandParameter.class);
                if (!anno.commutator().isEmpty()) {
                    CommuterArg arg = cmdLine.commuterMap.get(anno.commutator());
                    if (arg != null) {
                        if (arg.value != null) {
                            this.setValue(o, f, arg.value);
                        } else if (!anno.defaultValue().isEmpty()) {
                            this.setValue(o, f, anno.defaultValue());
                        } else {
                            if (f.getType() != Boolean.class && f.getType() != Boolean.TYPE) throw new Exception(String.format(Messages.CommandAnalyzer_2, anno.commutator()));
                            this.setValue(o, f, "true");
                        }
                    }
                } else {
                    int position = anno.position();
                    if (position >= cmdLine.args.size()) {
                        throw new Exception(Messages.bind((String)Messages.CommandAnalyzer_4, (Object)f.getName(), (Object)anno.position()));
                    }
                    Arg a = cmdLine.args.get(position);
                    if (a instanceof CommuterArg) {
                        throw new Exception(Messages.bind((String)Messages.CommandAnalyzer_4, (Object)f.getName(), (Object)anno.position()));
                    }
                    this.setValue(o, f, a.value);
                }
            }
            ++n2;
        }
    }

    private class Arg {
        String value;

        Arg(String value) {
            this.value = value;
        }
    }

    private class CmdLine {
        List<Arg> args = new ArrayList<Arg>();
        HashMap<String, CommuterArg> commuterMap = new HashMap();

        private CmdLine() {
        }

        void addArg(Arg arg) {
            this.args.add(arg);
            if (arg instanceof CommuterArg) {
                CommuterArg a = (CommuterArg)arg;
                this.commuterMap.put(a.commuter.substring(1), a);
            }
        }
    }

    private class CommuterArg
    extends Arg {
        String commuter;

        CommuterArg(String commuter, String value) {
            super(value);
            this.commuter = commuter;
        }
    }

    class Parser {
        Parser() {
        }

        public CmdLine parse(String arguments) throws Exception {
            CmdLine res = new CmdLine();
            StringBuffer buf = new StringBuffer();
            ArrayList<String> args = new ArrayList<String>();
            int i = 0;
            while (i < arguments.length()) {
                char c = arguments.charAt(i);
                block0 : switch (c) {
                    case '\"': {
                        int j = i + 1;
                        while (j < arguments.length()) {
                            char cc = arguments.charAt(j);
                            if (cc == '\"') {
                                i = j;
                                break block0;
                            }
                            buf.append(cc);
                            ++j;
                        }
                        break;
                    }
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        if (buf.length() == 0) break;
                        args.add(buf.toString());
                        buf = new StringBuffer();
                        break;
                    }
                    default: {
                        buf.append(c);
                    }
                }
                ++i;
            }
            if (buf != null && buf.length() > 0) {
                args.add(buf.toString());
            }
            i = 0;
            while (i < args.size()) {
                String k = (String)args.get(i);
                if (k.equals("-")) {
                    throw new Exception(String.format(Messages.CommandAnalyzer_missingArgumentName, i));
                }
                if (k.startsWith("-")) {
                    String s;
                    String commuter = k;
                    String value = null;
                    int next = i + 1;
                    if (next < args.size() && !(s = (String)args.get(next)).startsWith("-")) {
                        value = s;
                        i = next;
                    }
                    res.addArg(new CommuterArg(commuter, value));
                } else {
                    res.addArg(new Arg(k));
                }
                ++i;
            }
            return res;
        }
    }
}

