/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;

public class DropShadow {
    public static ImageData dropShadow(ImageData originalImageData, Color color, int radius, int highlightRadius, int opacity) {
        double highlightRadiusIncrease;
        if (originalImageData == null) {
            return null;
        }
        if (color == null) {
            return null;
        }
        if (radius == 0) {
            return originalImageData;
        }
        int shift = (int)((double)radius * 1.5);
        double d = radius < highlightRadius * 2 ? 0.15 : (highlightRadiusIncrease = radius < highlightRadius * 3 ? 0.09 : 0.02);
        opacity = opacity > 255 ? 255 : (opacity < 0 ? 0 : opacity);
        ImageData newImageData = new ImageData(originalImageData.width + radius * 2, originalImageData.height + radius * 2, 24, new PaletteData(255, 65280, 0xFF0000));
        int[] pixels = new int[originalImageData.width];
        int row = radius;
        while (row < radius + originalImageData.height) {
            originalImageData.getPixels(0, row - radius, originalImageData.width, pixels, 0);
            int col = 0;
            while (col < pixels.length) {
                pixels[col] = newImageData.palette.getPixel(originalImageData.palette.getRGB(pixels[col]));
                ++col;
            }
            newImageData.setPixels(radius, row, originalImageData.width, pixels, 0);
            ++row;
        }
        int colorInt = newImageData.palette.getPixel(color.getRGB());
        pixels = new int[newImageData.width];
        int i = 0;
        while (i < newImageData.width) {
            pixels[i] = colorInt;
            ++i;
        }
        byte[] alphas = new byte[newImageData.width];
        int row2 = 0;
        while (row2 < newImageData.height) {
            if (row2 < radius) {
                byte intensity = (byte)((double)opacity * ((double)(row2 + 1) / (double)radius));
                int col = 0;
                while (col < alphas.length / 2 + alphas.length % 2) {
                    if (col < radius) {
                        double hypotenuse = Math.sqrt(Math.pow(radius - col - 1, 2.0) + Math.pow(radius - 1 - row2, 2.0));
                        byte by = (byte)((double)opacity * Math.max(((double)radius - hypotenuse) / (double)radius, 0.0));
                        alphas[alphas.length - col - 1] = by;
                        alphas[col + shift] = by;
                        if (hypotenuse < Math.min((double)highlightRadius, (double)radius * 0.5)) {
                            byte by2 = (byte)Math.min(255.0, (double)(alphas[col + shift] & 0xFF) * (1.0 + highlightRadiusIncrease * Math.max(((double)radius - hypotenuse) / (double)radius, 0.0)));
                            alphas[alphas.length - col - 1] = by2;
                            alphas[col + shift] = by2;
                        }
                    } else {
                        byte by = (byte)((double)row2 > Math.max((double)(radius - highlightRadius - 1), (double)radius * 0.5) ? Math.min(255.0, (double)(intensity & 0xFF) * (1.0 + highlightRadiusIncrease * (double)row2 / (double)radius)) : (double)intensity);
                        alphas[alphas.length - col - 1] = by;
                        alphas[col + shift] = by;
                    }
                    ++col;
                }
                if (row2 + shift < newImageData.height) {
                    newImageData.setAlphas(newImageData.width - radius, row2 + shift, radius, alphas, alphas.length - radius);
                    newImageData.setPixels(newImageData.width - radius, row2 + shift, radius, pixels, alphas.length - radius);
                }
                newImageData.setAlphas(0, newImageData.height - 1 - row2, newImageData.width, alphas, 0);
                newImageData.setPixels(0, newImageData.height - 1 - row2, newImageData.width, pixels, 0);
            } else if (row2 <= newImageData.height / 2) {
                double intensity = 0.0;
                int col = 0;
                while (col < alphas.length) {
                    if (col < radius) {
                        intensity = (double)opacity * ((double)(col + 1) / (double)radius);
                        if ((double)col > Math.max((double)(radius - highlightRadius - 1), (double)radius * 0.5)) {
                            intensity = Math.min(255.0, intensity * (1.0 + highlightRadiusIncrease * (double)col / (double)radius));
                        }
                        alphas[newImageData.width - col - 1] = (byte)intensity;
                        alphas[col] = 0;
                    } else if (col <= newImageData.width / 2 + newImageData.width % 2) {
                        alphas[newImageData.width - col - 1] = -1;
                        alphas[col] = -1;
                    }
                    ++col;
                }
                newImageData.setPixels(0, newImageData.height - 1 - row2, radius, pixels, 0);
                newImageData.setPixels(originalImageData.width + radius, newImageData.height - 1 - row2, radius, pixels, 0);
                newImageData.setAlphas(0, newImageData.height - 1 - row2, newImageData.width, alphas, 0);
                if (row2 >= shift + radius) {
                    newImageData.setPixels(0, row2, radius, pixels, 0);
                    newImageData.setPixels(originalImageData.width + radius, row2, radius, pixels, 0);
                    newImageData.setAlphas(0, row2, newImageData.width, alphas, 0);
                } else {
                    newImageData.setPixels(0, row2, radius, pixels, 0);
                    newImageData.setAlphas(0, row2, newImageData.width - radius, alphas, 0);
                }
            }
            ++row2;
        }
        return newImageData;
    }
}

