/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out;

import com.indy.ui.custom.out.CustomInternalWorksapceJob;
import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.internal.localstore.IHistoryStore;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class HistoryRestorationHelper {
    private static Logger logger = LogManager.getLogger(HistoryRestorationHelper.class);

    private HistoryRestorationHelper() {
    }

    public static boolean setWorkspaceAutoBuild(boolean flag) {
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceDescription description = workspace.getDescription();
            if (flag != description.isAutoBuilding()) {
                description.setAutoBuilding(flag);
                workspace.setDescription(description);
                return !description.isAutoBuilding();
            }
            return description.isAutoBuilding();
        }
        catch (Exception ex) {
            logger.error("unexpected", (Throwable)ex);
            return false;
        }
    }

    public static void scheduleRestoreFromHistory(String restoreJobName, Collection<IFile> modifiedResource, Logger logger) {
        CustomInternalWorksapceJob job = new CustomInternalWorksapceJob(restoreJobName, () -> {
            boolean autoBuild = HistoryRestorationHelper.setWorkspaceAutoBuild(false);
            try {
                HistoryRestorationHelper.restoreFilesFromHistory(modifiedResource, logger);
            }
            finally {
                HistoryRestorationHelper.setWorkspaceAutoBuild(autoBuild);
            }
        });
        job.setUser(true);
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.schedule();
    }

    private static void restoreFilesFromHistory(Collection<IFile> modifiedResourceURI, Logger logger) {
        IHistoryStore historyStore = ((Workspace)ResourcesPlugin.getWorkspace()).getFileSystemManager().getHistoryStore();
        for (IFile f : modifiedResourceURI) {
            IPath path = f.getFullPath();
            IFileState[] states = historyStore.getStates(path, (IProgressMonitor)new NullProgressMonitor());
            IFileState lastState = null;
            IFileState[] iFileStateArray = states;
            int n = states.length;
            int n2 = 0;
            while (n2 < n) {
                IFileState s = iFileStateArray[n2];
                if (lastState == null) {
                    lastState = s;
                } else if (lastState.getModificationTime() < s.getModificationTime()) {
                    lastState = s;
                }
                ++n2;
            }
            try {
                f.setContents(lastState, 3, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                logger.error("Failed to undo refactor on {}", (Object)f.getFullPath(), (Object)e);
            }
        }
    }
}

