/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out;

import com.indy.ui.custom.out.Activator;
import com.indy.ui.custom.out.EngineVariable;
import com.indy.ui.custom.out.Messages;
import com.semarchy.xdi.designer.core.Constants;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.semarchy.xdi.designer.core.utils.EMFResourceUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.workspace.impl.WorkspaceCommandStackImpl;
import org.eclipse.gmf.runtime.emf.core.resources.GMFResource;
import org.eclipse.gmf.runtime.emf.core.util.CrossReferenceAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.osgi.framework.Bundle;

public class Util {
    public static boolean isTextEditorLocked = false;
    public static int currentKeyPressed = -1;
    static int MODE_INEXISTENT = 1;
    static int MODE_EQUALS = 2;
    static int MODE_DIFF = 3;
    public static final String OPTION_DISABLE_ALL_MAP_ADAPTER = "STB_OPTION_DISABLE_ALL_MAP_ADAPTER";
    public static Util INSTANCE = new Util();
    static final int BUFFER = 2048;

    public static boolean testNotifiedAttribute(Notification notification, int eventType, int ... id) {
        if (notification != null && notification.getFeature() instanceof EAttribute && notification.getEventType() == eventType) {
            int[] nArray = id;
            int n = id.length;
            int n2 = 0;
            while (n2 < n) {
                int _id = nArray[n2];
                if (((EAttribute)notification.getFeature()).getFeatureID() == _id) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static String getNewChildAlias(EObject owner, EReference childrenFeature, EStructuralFeature Namefeature, String name, int number) {
        if (name != null) {
            String _name = name.replaceAll("[^A-Z^a-z^0-9_]", "_");
            _name = number == 1 ? _name : _name + "_" + number;
            for (EObject a : (EList)owner.eGet((EStructuralFeature)childrenFeature)) {
                Object obj = a.eGet(Namefeature);
                if (obj == null || !obj.toString().equals(_name)) continue;
                return Util.getNewChildAlias(owner, childrenFeature, Namefeature, name, number + 1);
            }
            return _name;
        }
        return null;
    }

    public static int getCurrentKeyCodePressed() {
        return currentKeyPressed;
    }

    public static void executeCommandWithoutUndo(InternalTransactionalEditingDomain internalDomain, Command c) {
        try {
            if (internalDomain.getCommandStack() instanceof TransactionalCommandStack) {
                HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                options.put("no_undo", Boolean.TRUE);
                ((TransactionalCommandStack)internalDomain.getCommandStack()).execute(c, options);
            } else {
                internalDomain.getCommandStack().execute(c);
            }
            if (internalDomain.getCommandStack() instanceof WorkspaceCommandStackImpl) {
                WorkspaceCommandStackImpl o = (WorkspaceCommandStackImpl)internalDomain.getCommandStack();
                OperationHistoryFactory.getOperationHistory().dispose(o.getDefaultUndoContext(), true, true, true);
            }
        }
        catch (Throwable e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "com.indy.ui.custom.out", Messages.Util_9 + c.getLabel(), e));
        }
    }

    public static Shell getCurrentShellOrCreateShell() {
        return Display.getCurrent() != null ? Display.getCurrent().getActiveShell() : (Display.getDefault() != null ? Display.getDefault().getActiveShell() : new Shell());
    }

    public static boolean compareStream(InputStream inputStream1, InputStream inputStream2) throws IOException {
        int i = 0;
        int j = 0;
        while ((i = inputStream1.read()) == (j = inputStream2.read()) && i != -1 && j != -1) {
        }
        inputStream1.close();
        inputStream2.close();
        return i == j;
    }

    public static EObject getMatchingEObjectById(List<EObject> list, EObject target) throws Exception {
        if (!target.eIsProxy()) {
            for (EObject tt : list) {
                String id2;
                String id1;
                if (tt.eResource() == null) {
                    if (!tt.eIsProxy() || !(tt = EcoreUtil.resolve((EObject)tt, (EObject)target)).eIsProxy()) continue;
                    id1 = ((InternalEObject)tt).eProxyURI().fragment();
                    id2 = target.eResource().getURIFragment(target);
                    if (id1 == null || id2 == null || !id1.equals(id2)) continue;
                    return tt;
                }
                id1 = tt.eResource().getURIFragment(tt);
                id2 = target.eResource().getURIFragment(target);
                if (id1 == null || id2 == null || !id1.equals(id2)) continue;
                return tt;
            }
        } else {
            System.out.println(Messages.Util_10);
        }
        return null;
    }

    private static List<CompareFile> analyseDifferential(Bundle bundle, String projectName, String pattern, boolean force, boolean recursive, IProgressMonitor monitor) {
        Enumeration _enum = bundle.findEntries(projectName, pattern, recursive);
        ArrayList<CompareFile> diff = new ArrayList<CompareFile>();
        while (_enum.hasMoreElements()) {
            IFile _file;
            URL o = (URL)_enum.nextElement();
            String file = o.getPath();
            if (monitor != null) {
                monitor.setTaskName(Messages.Util_0 + file);
            }
            if (file.contains("/CVS/") || file.endsWith("/") || (_file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(file))).getType() != 1 || _file.getFileExtension() == null || _file.getFileExtension().equals("") || !force && _file.exists()) continue;
            try {
                InputStream f2;
                if (!_file.exists()) {
                    Util util = INSTANCE;
                    util.getClass();
                    diff.add(util.new CompareFile(_file, o, MODE_INEXISTENT));
                    continue;
                }
                InputStream f1 = _file.getContents();
                boolean b = Util.compareStream(f1, f2 = o.openStream());
                if (!b) {
                    Util util = INSTANCE;
                    util.getClass();
                    diff.add(util.new CompareFile(_file, o, MODE_DIFF));
                    continue;
                }
                Util util = INSTANCE;
                util.getClass();
                diff.add(util.new CompareFile(_file, o, MODE_EQUALS));
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return diff;
    }

    public static void initEnv(Bundle bundle, String projectName, String pattern, boolean force, boolean forceReplace, boolean recursive, IProgressMonitor monitor) {
        Util.initEnv(Util.analyseDifferential(bundle, projectName, pattern, forceReplace, recursive, monitor), monitor, forceReplace);
    }

    private static void initEnv(List<CompareFile> list, IProgressMonitor monitor, boolean forceReplace) {
        for (CompareFile compareFile : list) {
            if (monitor != null) {
                monitor.setTaskName(Messages.Util_1 + String.valueOf(compareFile.file.getFullPath()));
            }
            if (compareFile.mode == MODE_DIFF) {
                try {
                    compareFile.file.delete(true, monitor);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (compareFile.mode != MODE_INEXISTENT || !forceReplace) continue;
            EngineVariable.INSTANCE.getReplaceFileWithOutConfirm().add(compareFile.file.getFullPath().toString());
        }
        for (CompareFile compareFile : list) {
            monitor.setTaskName(Messages.Util_17 + String.valueOf(compareFile.file.getFullPath()));
            if (compareFile.mode != MODE_DIFF && compareFile.mode != MODE_INEXISTENT) continue;
            try {
                Util.mkdirs((IResource)compareFile.file, monitor);
                compareFile.file.create(compareFile.url.openStream(), true, monitor);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void mkdirs(IResource resource, IProgressMonitor monitor) {
        if (resource.getProject().exists() && !resource.getProject().isOpen()) {
            try {
                resource.getProject().open(monitor);
            }
            catch (CoreException e1) {
                e1.printStackTrace();
            }
        }
        if (!resource.getParent().exists()) {
            Util.mkdirs((IResource)resource.getParent(), monitor);
        }
        if (resource instanceof IProject) {
            try {
                ((IProject)resource).create(monitor);
                ((IProject)resource).open(monitor);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else if (resource instanceof IFolder) {
            try {
                ((IFolder)resource).create(0, true, monitor);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public static void updateCrossReferenceAdapter(ResourceSet rs) {
        EList list = rs.eAdapters();
        Adapter adapter = null;
        if (list != null) {
            for (Adapter _adapter : list) {
                if (!(_adapter instanceof CrossReferenceAdapter)) continue;
                adapter = _adapter;
                break;
            }
        }
        if (adapter != null) {
            list.remove(adapter);
            list.add((Object)new CrossReferenceAdapter(false));
        }
    }

    public static void removeCrossCrossReferenceAdapter(ResourceSet rs) {
        try {
            EList list = rs.eAdapters();
            Adapter adapter = null;
            if (list != null) {
                for (Adapter _adapter : list) {
                    if (!(_adapter instanceof CrossReferenceAdapter)) continue;
                    adapter = _adapter;
                    break;
                }
            }
            if (adapter != null) {
                list.remove(adapter);
            }
        }
        catch (Throwable t) {
            Activator.getDefault().getLog().log((IStatus)new Status(2, "com.indy.ui.custom.out", Messages.Util_25, t));
        }
    }

    public static EObject getRootElement(IFile file, ResourceSet rs) {
        URI uri = Util.convertIFileToEMFURI(file);
        Resource r = rs.getResource(uri, true);
        return EMFResourceUtil.getRootElement((Resource)r);
    }

    public static Image greydImage(Image image) {
        ImageData fullImageData = image.getImageData();
        return new Image(image.getDevice(), fullImageData);
    }

    public static MessageConsole findConsole(String name) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        MessageConsole myConsole = new MessageConsole(name, null);
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }

    public static URI convertIFileToEMFURI(IFile file) {
        return Util.convertIPathToEMFURI2(file.getFullPath());
    }

    public static URI convertIPathToEMFURI2(IPath path) {
        return URI.createPlatformResourceURI((String)path.toString(), (boolean)true);
    }

    public static IFile convertResourceToFile(Resource resource) {
        if (resource != null) {
            URI uri = resource.getURI();
            uri = resource.getResourceSet().getURIConverter().normalize(uri);
            return Util.convertEMFURIToFile(uri);
        }
        return null;
    }

    public static URI convertIPathToURI(IPath path) {
        IFile[] tmpFile = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation(path);
        if (tmpFile.length > 0) {
            return Util.convertIFileToEMFURI(tmpFile[0]);
        }
        return null;
    }

    public static URI getResourceLineageURI(URI resourceURI) {
        if (resourceURI.isPlatformResource()) {
            StringBuffer buf = new StringBuffer();
            int i = 1;
            while (i < resourceURI.trimFragment().trimFileExtension().segmentCount()) {
                buf.append("/");
                buf.append(resourceURI.segment(i));
                if (i == 1) {
                    buf.append("/indy.build");
                }
                ++i;
            }
            return URI.createURI((String)("platform:/resource" + buf.toString() + ".cross"));
        }
        return null;
    }

    public static IFile convertEMFURIToFile(URI uri) {
        String scheme;
        if (uri != null && "platform".equals(scheme = uri.scheme()) && uri.segmentCount() > 1 && "resource".equals(uri.segment(0))) {
            StringBuffer platformResourcePath = new StringBuffer();
            int j = 1;
            int size = uri.segmentCount();
            while (j < size) {
                platformResourcePath.append('/');
                platformResourcePath.append(URI.decode((String)uri.segment(j)));
                ++j;
            }
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformResourcePath.toString()));
        }
        return null;
    }

    public static String removeLastFileExtension(String string) {
        if (string.lastIndexOf(".") > 0) {
            return string.substring(0, string.lastIndexOf("."));
        }
        return string;
    }

    public static String getLastFileExtension(String string) {
        if (string.lastIndexOf(".") > 0) {
            return string.substring(string.lastIndexOf(".") + 1);
        }
        return null;
    }

    public static URI getTargetPath(URI sourcePath, String targetExtension) {
        IPath path = Util.getTargetPath((IPath)new Path(sourcePath.toString()), targetExtension);
        String str = "";
        if (path != null) {
            if (!sourcePath.isPlatform()) {
                return Util.convertIPathToEMFURI2(path);
            }
            return URI.createURI((String)path.toString());
        }
        return null;
    }

    public static void mkDirRecursively(IPath path, IProgressMonitor monitor) throws CoreException {
        IFolder current;
        IFolder parent;
        IPath _parent = path.removeLastSegments(1);
        if (!_parent.removeLastSegments(1).isRoot() && !(parent = ResourcesPlugin.getWorkspace().getRoot().getFolder(_parent)).exists()) {
            Util.mkDirRecursively(path.removeLastSegments(1), monitor);
        }
        if (!(current = ResourcesPlugin.getWorkspace().getRoot().getFolder(path)).exists() && !current.getName().equals("indy.build")) {
            current.create(true, true, monitor);
        }
    }

    public static void checkLinkedBuildFolder(IFolder buildFolder, IProgressMonitor monitor) {
        if (!"indy.build".equals(buildFolder.getName()) || buildFolder.getParent() != buildFolder.getProject()) {
            return;
        }
        boolean isLinked = buildFolder.isLinked();
        Path linkPath = new Path("WORKSPACE_LOC");
        linkPath = linkPath.append("/.indy.build");
        linkPath = linkPath.append(buildFolder.getProject().getName());
        if (isLinked) {
            File linkPathFile;
            java.net.URI pathURI = java.net.URI.create(buildFolder.getPathVariableManager().getURIValue("WORKSPACE_LOC").toString() + "/.indy.build/" + URI.encodeFragment((String)buildFolder.getProject().getName(), (boolean)true));
            File file = new File(buildFolder.getLocation().toOSString());
            if (!file.equals(linkPathFile = new File(pathURI))) {
                isLinked = false;
            }
        }
        if (!isLinked) {
            if (buildFolder.exists()) {
                try {
                    IResource[] iResourceArray = buildFolder.members();
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource r = iResourceArray[n2];
                        r.delete(true, monitor);
                        ++n2;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            try {
                buildFolder.createLink((IPath)linkPath, 272, monitor);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static List<IPath> getWorkDirectories(IPath sourcePath) {
        ArrayList<IPath> retour = new ArrayList<IPath>();
        if (sourcePath.getFileExtension() != null) {
            if (sourcePath.getFileExtension().equals("map")) {
                retour.add(Util.getWorkMapDirectory(sourcePath));
                retour.add(Util.getMapDiagramDirectory(sourcePath));
            } else if (sourcePath.getFileExtension().equals("proc")) {
                if (sourcePath.segmentCount() > 1 && !"indy.build".equals(sourcePath.segment(1))) {
                    retour.add(Util.getProcDiagramDirectory(sourcePath));
                    retour.add(Util.getWorkMapDirectory(sourcePath));
                }
            } else if (sourcePath.getFileExtension().equals("md")) {
                retour.add(Util.getWorkMapDirectory(sourcePath));
            }
        }
        return retour;
    }

    private static IPath getStartSegment(IPath path) {
        String str = "";
        int depth = path.getFileExtension() != null ? 1 : 0;
        int j = 0;
        int i = path.segmentCount() - 1;
        while (i >= 0) {
            ++j;
            String seg = path.segment(i);
            if (seg.equals(Constants.indyWorkBuildDirectoryName) || seg.equals(Constants.indyWorkDiagramDirectoryName)) {
                depth = j;
                break;
            }
            --i;
        }
        IPath retour = path.removeLastSegments(depth);
        return retour;
    }

    private static IPath getWorkMapDirectory(IPath sourcePath) {
        IPath p = new Path(sourcePath.segment(0)).append(Constants.indyWorkBuildDirectoryName);
        int i = 1;
        while (i < sourcePath.segmentCount() - 1) {
            p = p.append(sourcePath.segment(i));
            ++i;
        }
        return p;
    }

    public static IPath getMapDiagramDirectory(IPath sourcePath) {
        return Util.getStartSegment(sourcePath).append(Constants.indyWorkDiagramDirectoryName).append(Constants.indyMapDiagramDirectory);
    }

    public static IPath getProcDiagramDirectory(IPath sourcePath) {
        return Util.getStartSegment(sourcePath).append(Constants.indyWorkDiagramDirectoryName).append(Constants.indyProcDiagramDirectory);
    }

    public static void changePathIntoGMFResource(IPath gmfPath, Map<String, String> oldIdToNewId) {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource re = rs.getResource(Util.convertIPathToEMFURI2(gmfPath), true);
        Map map = ((GMFResource)re).getDefaultSaveOptions();
        Util util = INSTANCE;
        util.getClass();
        map.put("URI_HANDLER", util.new URIHandlerImpl2(oldIdToNewId));
        HashMap saveOptions = new HashMap();
        try {
            re.save(((GMFResource)re).getDefaultSaveOptions());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void changeIdIntoGMFResource(IPath gmfPath, final Map<String, String> oldIdToNewId, IPath fromPath, IPath toPath) {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource re = rs.getResource(Util.convertIPathToEMFURI2(gmfPath), true);
        ((GMFResource)re).getDefaultSaveOptions().put("com.indy.ui.custom.out.gmf.option.save.deresolveStambiaURI", Boolean.TRUE);
        ((GMFResource)re).getDefaultSaveOptions().put("URI_HANDLER", new URIHandlerImpl(){

            public URI deresolve(URI uri) {
                String fragment = uri.fragment();
                if (oldIdToNewId != null) {
                    for (String key : oldIdToNewId.keySet()) {
                        if (!fragment.contains(key)) continue;
                        String newId = (String)oldIdToNewId.get(key);
                        fragment = fragment.replaceAll(key, (String)oldIdToNewId.get(key));
                    }
                }
                return URI.createURI((String)"resource").appendFragment(fragment);
            }

            public URI resolve(URI uri) {
                return super.resolve(uri);
            }
        });
        HashMap saveOptions = new HashMap();
        try {
            re.save(((GMFResource)re).getDefaultSaveOptions());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static IPath getTargetPath(IPath sourcePath, String targetExtension) {
        String ss = "2";
        if (sourcePath.getFileExtension() == null || sourcePath.getFileExtension().equals(targetExtension)) {
            return sourcePath;
        }
        if (targetExtension.equals("proc_diagram")) {
            if (sourcePath.getFileExtension().equals("proc")) {
                if (sourcePath.segment(sourcePath.segmentCount() - 2).equals(Constants.indyMapDirectory)) {
                    IPath ff = Util.getMapDiagramDirectory(sourcePath);
                    return Util.getMapDiagramDirectory(sourcePath).append(sourcePath.removeFileExtension().addFileExtension(targetExtension).lastSegment());
                }
                return Util.getProcDiagramDirectory(sourcePath).append(sourcePath.removeFileExtension().addFileExtension(targetExtension).lastSegment());
            }
            if (sourcePath.getFileExtension().equals("map")) {
                return Util.getMapDiagramDirectory(sourcePath).append(sourcePath.removeFileExtension().addFileExtension(targetExtension).lastSegment());
            }
        } else if (targetExtension.equals("map_diagram")) {
            if (sourcePath.getFileExtension().equals("map")) {
                return Util.getMapDiagramDirectory(sourcePath).append(sourcePath.removeFileExtension().addFileExtension(targetExtension).lastSegment());
            }
            if (sourcePath.getFileExtension().equals("proc")) {
                return Util.getMapDiagramDirectory(sourcePath).append(sourcePath.removeFileExtension().addFileExtension(targetExtension).lastSegment());
            }
        }
        if (targetExtension.equals("proc") && sourcePath.getFileExtension().equals("map")) {
            return Util.getWorkMapDirectory(sourcePath).append(sourcePath.removeFileExtension().addFileExtension(targetExtension).lastSegment());
        }
        return null;
    }

    public static String rightPad(String val, int nb) {
        Object retour = val;
        int i = val.length();
        while (i < nb) {
            retour = (String)retour + " ";
            ++i;
        }
        return retour;
    }

    public static String extractActionType(IAction action) {
        String[] actionIdsParts = action.getId().split("\\.");
        if (actionIdsParts.length < 6) {
            throw new RuntimeException(Messages.bind((String)Messages.Util_94, (Object)action.getId()));
        }
        StringBuffer buf = new StringBuffer();
        int i = 5;
        while (i < actionIdsParts.length) {
            if (buf.length() > 0) {
                buf.append(".");
            }
            buf.append(actionIdsParts[i]);
            ++i;
        }
        return buf.toString();
    }

    public static List<Field> forceNull(Object o, String ... list) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Class<?> clazz = o.getClass();
        while (clazz != null) {
            List<String> list2 = Arrays.asList(list);
            Field[] fieldArray = clazz.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (list2.size() == 0 || list2.contains(field.getName())) {
                    try {
                        field.setAccessible(true);
                        field.set(o, null);
                        fields.add(field);
                    }
                    catch (SecurityException securityException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    public static Field getField(Object o, String fieldName) {
        Class<?> clazz = o.getClass();
        while (clazz != null) {
            try {
                Field f = clazz.getDeclaredField(fieldName);
                if (f != null) {
                    return f;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    private static IPath getBuiltFolder(URI mappingFile) {
        if (mappingFile != null && "map".equals(mappingFile.fileExtension())) {
            Path p = new Path("indy.build");
            int i = 2;
            while (i < mappingFile.segmentCount() - 1) {
                p = p.append("/" + URI.decode((String)mappingFile.segment(i)));
                ++i;
            }
            return p;
        }
        return null;
    }

    public class CompareFile {
        URL url;
        IFile file;
        int mode;

        public CompareFile(IFile file, URL url, int mode) {
            this.file = file;
            this.mode = mode;
            this.url = url;
        }

        public boolean isEquals() {
            return this.mode == MODE_EQUALS;
        }
    }

    public class URIHandlerImpl2
    extends URIHandlerImpl {
        Map<String, String> oldIdToNewId;

        public URIHandlerImpl2(Map<String, String> oldIdToNewId) {
            this.oldIdToNewId = oldIdToNewId;
        }

        public URI deresolve(URI uri) {
            URI retour = uri;
            if (this.oldIdToNewId != null) {
                Object fragment = retour.fragment();
                if (this.oldIdToNewId.get(fragment) != null) {
                    fragment = this.oldIdToNewId.get(fragment);
                } else if (fragment != null) {
                    String newFileId;
                    String curId = CacheHelper.extractEltID((String)fragment);
                    String curFileId = CacheHelper.extractFileID((String)fragment);
                    String newId = this.oldIdToNewId.get(curId);
                    if (newId != null) {
                        fragment = newId + ((String)fragment).substring(((String)fragment).indexOf("?"));
                    }
                    if ((newFileId = this.oldIdToNewId.get(curFileId)) != null) {
                        if (((String)fragment).contains("fileId=" + curFileId + "$")) {
                            fragment = ((String)fragment).replace("fileId=" + curFileId + "$", "fileId=" + newFileId + "$");
                        } else if (((String)fragment).contains("fileId=" + curFileId + "?")) {
                            fragment = ((String)fragment).replace("fileId=" + curFileId + "?", "fileId=" + newFileId + "?");
                        }
                    }
                }
                if (fragment != null) {
                    retour = !((String)fragment).contains("fileId=") ? URI.createURI((String)"").appendFragment((String)fragment) : ("udf".equals(uri.scheme()) ? super.deresolve(uri) : URI.createURI((String)"resource").appendFileExtension(uri.fileExtension()).appendFragment((String)fragment));
                }
            }
            return retour;
        }

        public URI resolve(URI uri) {
            return super.resolve(uri);
        }
    }
}

