/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out.common;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.jface.viewers.ISelection;

public abstract class TextViewerPositionBackup {
    private WeakHashMap<String, Object> backupMap = new WeakHashMap();
    private Queue<String> keyQueue = new LinkedList<String>();
    private Set<String> keys = new HashSet<String>();
    private int maxSize = 50;

    public ISelection getPosition(Object obj) {
        return (ISelection)this.backupMap.get(this.getKey(obj));
    }

    protected abstract String getKey(Object var1);

    public void dispose() {
        this.keyQueue.clear();
        this.backupMap.clear();
        this.backupMap.clear();
    }

    public void setPosition(Object obj, ISelection info) {
        if (obj == null) {
            return;
        }
        String key = this.getKey(obj);
        if (key == null) {
            return;
        }
        if (obj != null) {
            if (info == null || info.isEmpty()) {
                this.keys.remove(key);
                this.keyQueue.remove(key);
                this.backupMap.remove(key);
            } else {
                if (this.keys.add(key)) {
                    while (this.keyQueue.size() >= this.maxSize) {
                        this.backupMap.remove(this.keyQueue.poll());
                    }
                    this.keyQueue.add(key);
                }
                this.backupMap.put(key, info);
            }
        }
    }

    class Position {
        int selectionPosition;
        int selectionOffset;

        public Position(int position, int offset) {
            this.selectionOffset = offset;
            this.selectionPosition = position;
        }
    }
}

