/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out.common.properties;

import com.indy.ui.custom.out.common.properties.UIControl;
import com.indy.ui.custom.out.common.properties.UIControlDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;

class UIControlDropTargetListener
implements DropTargetListener {
    DndFeedbackDrawer drawer;
    private UIControl ui;
    private UIControlDescriptor desc;

    UIControlDropTargetListener(UIControl ui, UIControlDescriptor desc) {
        this.ui = ui;
        this.desc = desc;
        this.drawer = new DndFeedbackDrawer(ui.getMainControl());
    }

    public void dragEnter(DropTargetEvent event) {
        if (event.detail == 16) {
            if ((event.operations & 1) != 0) {
                event.detail = 1;
                this.border(true);
            } else {
                event.detail = 0;
                event.feedback = 0;
                this.border(false);
            }
        }
    }

    public void dragLeave(DropTargetEvent event) {
        event.detail = 0;
        event.feedback = 0;
        this.border(false);
    }

    public void dragOperationChanged(DropTargetEvent event) {
        if (event.detail == 16) {
            if ((event.operations & 1) != 0) {
                event.detail = 1;
            } else {
                event.detail = 0;
                event.feedback = 0;
            }
        }
    }

    private List<EObject> getEObjects(Object o) {
        if (o == null) {
            return Collections.emptyList();
        }
        ArrayList<EObject> objects = new ArrayList<EObject>();
        IStructuredSelection selection = (IStructuredSelection)Platform.getAdapterManager().getAdapter(o, IStructuredSelection.class);
        if (selection == null) {
            EObject e = (EObject)Platform.getAdapterManager().getAdapter(o, EObject.class);
            if (e != null) {
                objects.add(e);
            }
        } else {
            for (Object oo : selection.toList()) {
                EObject e = (EObject)Platform.getAdapterManager().getAdapter(oo, EObject.class);
                if (e == null) continue;
                objects.add(e);
            }
        }
        return objects;
    }

    private void border(boolean show) {
        if (show != this.drawer.enabled) {
            this.drawer.enabled = show;
            this.ui.getMainControl().getParent().redraw();
        }
    }

    public void dragOver(DropTargetEvent event) {
        event.feedback = 9;
        if (LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType)) {
            Object o = LocalSelectionTransfer.getTransfer().nativeToJava(event.currentDataType);
            if (this.getEObjects(o).isEmpty() && !"macosx".equals(Platform.getOS())) {
                event.detail = 0;
                event.feedback = 0;
                this.border(false);
            } else {
                this.border(true);
            }
            this.ui.getMainControl().getParent().redraw();
        }
    }

    private URI getURI(EObject eObj) {
        if (eObj.eIsProxy()) {
            return ((InternalEObject)eObj).eProxyURI();
        }
        return EcoreUtil.getURI((EObject)eObj);
    }

    private void handleAsString(EObject eoBj, URI uri) {
        String val = eoBj.eClass().getInstanceTypeName() + "#" + uri.fragment();
        this.desc.getPropertySetter().changeValue(val);
        this.ui.setValue(val);
    }

    private void handleAsReference(URI uri) {
        Object newValue = null;
        AnyType proxy = XMLTypeFactory.eINSTANCE.createAnyType();
        ((InternalEObject)proxy).eSetProxyURI(uri);
        if (this.desc.isUnbounded()) {
            Object curValues = this.desc.getValueProvider().getValueFromObject();
            ArrayList<AnyType> collection = new ArrayList<AnyType>();
            if (curValues instanceof Collection) {
                collection.addAll((Collection)curValues);
            }
            collection.add(proxy);
            newValue = collection;
        } else {
            newValue = proxy;
        }
        this.desc.getPropertySetter().changeValue(newValue);
        if (this.desc instanceof UIControlDescriptor.IRefreshable) {
            ((UIControlDescriptor.IRefreshable)((Object)this.desc)).refreshUIControl();
        }
    }

    public void drop(DropTargetEvent event) {
        if (!LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType)) {
            return;
        }
        Object o = LocalSelectionTransfer.getTransfer().nativeToJava(event.currentDataType);
        for (EObject eoBj : this.getEObjects(o)) {
            URI uri = this.getURI(eoBj);
            if (this.desc.getType() == UIControlDescriptor.Type.STRING) {
                this.handleAsString(eoBj, uri);
                continue;
            }
            if (this.desc.getType() != UIControlDescriptor.Type.REFERENCE) continue;
            this.handleAsReference(uri);
        }
        this.border(false);
    }

    public void dropAccept(DropTargetEvent event) {
        if (!LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType)) {
            event.detail = 0;
        }
    }

    private class DndFeedbackDrawer
    implements PaintListener {
        private Control control;
        boolean enabled = false;

        DndFeedbackDrawer(Control control) {
            this.control = control;
            control.getParent().addPaintListener((PaintListener)this);
        }

        public void paintControl(PaintEvent e) {
            if (this.enabled) {
                Point p = this.control.getLocation();
                Point sz = this.control.getSize();
                Rectangle rect = new Rectangle(p.x - 1, p.y - 1, sz.x + 1, sz.y + 1);
                e.gc.setAlpha(150);
                e.gc.setForeground(e.display.getSystemColor(26));
                e.gc.drawRectangle(rect);
            }
        }
    }
}

