/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out.demo;

import com.indy.ui.custom.out.demo.Messages;
import java.io.File;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class ImportDemoWizard
extends Wizard
implements IImportWizard {
    public static final String SAMPLES_BASE_URL = "com.indy.ui.help.redirects/Components/";
    private String relativePath;
    private Bundle bundle;
    private IWorkspaceRoot root;
    private String projectName;
    private String defaultPojectName;
    private boolean showProject = true;

    public ImportDemoWizard(String bundleRelativePathProjectFolder, Bundle bundle, String defaultPojectName) {
        this.relativePath = bundleRelativePathProjectFolder;
        this.bundle = bundle;
        this.projectName = defaultPojectName;
        this.defaultPojectName = defaultPojectName;
        this.root = ResourcesPlugin.getWorkspace().getRoot();
    }

    public void addPages() {
        WizardPage p = new WizardPage(Messages.ImportDemoWizard_1){

            public boolean isPageComplete() {
                return this.getErrorMessage() == null;
            }

            public void createControl(Composite parent) {
                Composite main = new Composite(parent, 0);
                main.setLayout((Layout)new GridLayout(2, false));
                Label l = new Label(main, 0);
                l.setLayoutData((Object)new GridData());
                l.setText(Messages.ImportDemoWizard_2);
                Text name = new Text(main, 2048);
                name.setLayoutData((Object)new GridData(4, 1, true, false));
                name.setText(ImportDemoWizard.this.projectName);
                name.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        IProject p = (this).ImportDemoWizard.this.root.getProject(((Text)e.widget).getText());
                        if (p != null && p.exists()) {
                            this.setErrorMessage(Messages.ImportDemoWizard_3);
                        } else {
                            this.setErrorMessage(null);
                            (this).ImportDemoWizard.this.projectName = ((Text)e.widget).getText();
                        }
                        this.getWizard().getContainer().updateButtons();
                    }
                });
                Button b = new Button(main, 32);
                b.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
                b.setText(Messages.ImportDemoWizard_4);
                b.setSelection(true);
                b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        (this).ImportDemoWizard.this.showProject = ((Button)e.widget).getSelection();
                    }
                });
                this.setControl((Control)main);
                IProject p = ImportDemoWizard.this.root.getProject(ImportDemoWizard.this.projectName);
                if (p != null && p.exists()) {
                    this.setErrorMessage(Messages.ImportDemoWizard_5);
                } else {
                    this.setErrorMessage(null);
                }
            }
        };
        p.setDescription(Messages.ImportDemoWizard_6);
        p.setTitle(Messages.ImportDemoWizard_7);
        this.addPage((IWizardPage)p);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean performFinish() {
        final IProject p = this.root.getProject(this.projectName);
        WorkspaceJob job = new WorkspaceJob(Messages.ImportDemoWizard_8){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                block13: {
                    SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
                    try {
                        p.create((IProgressMonitor)m.newChild(1));
                        p.open((IProgressMonitor)m.newChild(1));
                        try {
                            IProjectDescription description = p.getDescription();
                            description.setNatureIds(new String[]{"com.indy.ui.custom.out.nature.sample"});
                            description.setComment(ImportDemoWizard.this.defaultPojectName.replace("Sample - ", ""));
                            if (ResourcesPlugin.getWorkspace().validateNatureSet(description.getNatureIds()).isOK()) {
                                p.setDescription(description, (IProgressMonitor)m.newChild(1));
                            }
                        }
                        catch (CoreException description) {
                            // empty catch block
                        }
                        p.setDefaultCharset("UTF-8");
                        Enumeration e = ImportDemoWizard.this.bundle.findEntries("/" + ImportDemoWizard.this.relativePath, "*", true);
                        while (e != null && e.hasMoreElements()) {
                            URL url = (URL)e.nextElement();
                            URL fileURL = FileLocator.toFileURL((URL)url);
                            File fd = new File(fileURL.getPath());
                            if (!fd.isFile()) continue;
                            StringBuffer b = new StringBuffer();
                            String[] u = url.getPath().split("/");
                            boolean skip = false;
                            int i = 3;
                            while (i < u.length) {
                                if (u[i].startsWith(".")) {
                                    skip = true;
                                    break;
                                }
                                b.append("/");
                                b.append(u[i]);
                                ++i;
                            }
                            if (skip) continue;
                            try {
                                IFile f = p.getFile((IPath)new Path(b.toString()));
                                java.nio.file.Path p2 = Paths.get(f.getLocationURI());
                                Files.createDirectories(p2.getParent(), new FileAttribute[0]);
                                Files.copy(url.openStream(), p2, new CopyOption[0]);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (e == null) {
                            return new Status(4, "com.indy.ui.custom.out", String.format(Messages.ImportDemoWizard_0, ImportDemoWizard.this.relativePath, ImportDemoWizard.this.bundle.getSymbolicName()));
                        }
                        p.refreshLocal(2, (IProgressMonitor)m.newChild(1));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        if (p == null || !p.exists()) break block13;
                        try {
                            p.delete(true, true, (IProgressMonitor)m.newChild(1));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return new Status(4, "com.indy.ui.custom.out", Messages.ImportDemoWizard_19, (Throwable)ex);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)this.root);
        job.schedule();
        try {
            job.join();
            boolean res = job.getResult().isOK();
            if (res) {
                if (this.showProject) {
                    String urlComponentPage = this.geturlComponentPage(this.defaultPojectName);
                    PlatformUI.getWorkbench().getHelpSystem().displayHelp(SAMPLES_BASE_URL + urlComponentPage);
                }
                IViewPart v = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.ui.internal.introview");
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().hideView(v);
            }
            return res;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
    }

    private String geturlComponentPage(String projectName) {
        StringBuilder sb = new StringBuilder();
        sb.append(projectName.replace("Sample - ", "").replace(" ", "-").toLowerCase());
        sb.append("/overview");
        return sb.toString();
    }
}

