/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out.emf;

import com.indy.ui.custom.out.Activator;
import com.indy.ui.custom.out.Messages;
import com.indy.ui.custom.out.Util;
import com.indy.ui.custom.out.emf.SharingReadOnlyEditingDomainFactory;
import com.semarchy.xdi.designer.core.models.LightWeightCrossReferencer;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.log.LogService;

public class SharedResourceDisposer {
    public void releaseDependancies(EditingDomain editingDomain, IEditorInput editorInput) {
        if (editingDomain == null) {
            return;
        }
        try {
            Resource resource = this.getDomainModel(editingDomain, editorInput);
            if (resource == null) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "com.indy.ui.custom.out", Messages.bind((String)Messages.SharedResourceDisposer_0, (Object)this.getClass().getName(), (Object)editorInput)));
                return;
            }
            ArrayList<Resource> requiredResources = new ArrayList<Resource>();
            try {
                IEditorReference[] iEditorReferenceArray = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
                int n = iEditorReferenceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference ref = iEditorReferenceArray[n2];
                    try {
                        TransactionalEditingDomain ed;
                        IEditorPart p;
                        if (("com.indy.gmf.proc.diagram.non_rcp.part.ProcDiagramEditorID".equals(ref.getId()) || "com.indy.map.diagram.part.MapDiagramEditorID".equals(ref.getId())) && (p = ref.getEditor(false)) != null && p.getEditorInput() != editorInput && p instanceof IEditingDomainProvider && (ed = (TransactionalEditingDomain)((IEditingDomainProvider)p).getEditingDomain()) != null) {
                            for (Resource r : this.getDependancies(this.getDomainModel((EditingDomain)ed, ref.getEditorInput()), new HashSet<Resource>())) {
                                if (requiredResources.contains(r)) continue;
                                requiredResources.add(r);
                            }
                        }
                    }
                    catch (Exception ex) {
                        ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger(SharedResourceDisposer.class).warn("Failed to gather dependencies from openedEditors", (Object)ex);
                    }
                    ++n2;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            SharingReadOnlyEditingDomainFactory.getInstance().releaseUnusedResources(requiredResources);
        }
        catch (Exception ex) {
            ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger(SharedResourceDisposer.class).warn("Failed to release dependencies from openedEditors", (Object)ex);
        }
    }

    private Resource getDomainModel(EditingDomain editingDomain, IEditorInput editorInput) {
        Resource resource = null;
        if (editorInput instanceof URIEditorInput) {
            URI uri = ((URIEditorInput)editorInput).getURI();
            if (uri.fileExtension() != null) {
                if (uri.fileExtension().equals("map_diagram") || uri.fileExtension().equals("proc_diagram")) {
                    if (uri.isPlatformPlugin()) {
                        String procId = uri.trimFileExtension().trimFragment().lastSegment();
                        try {
                            ICacheService cacheService = (ICacheService)E4InjectorHelper.getService(ICacheService.class);
                            uri = cacheService.findResourceURIByFileId(procId);
                            if (uri != null) {
                                resource = editingDomain.getResourceSet().getResource(uri, false);
                            }
                        }
                        catch (Exception ex) {
                            Activator.getDefault().getLog().log((IStatus)new Status(4, "com.indy.ui.custom.out", ex.getMessage(), (Throwable)ex));
                        }
                    } else {
                        String resourceName = uri.trimFileExtension().trimFragment().lastSegment();
                        String extension = uri.fileExtension().replace("_diagram", "");
                        uri = uri.trimFileExtension().trimFragment().trimSegments(3).appendSegment(resourceName).appendFileExtension(extension);
                        resource = editingDomain.getResourceSet().getResource(uri, false);
                        if (resource == null && uri.fragment() != null) {
                            resource = editingDomain.getResourceSet().getResource(uri.trimFragment(), false);
                        }
                    }
                } else if (uri.fileExtension().equals("map") || uri.fileExtension().equals("proc")) {
                    resource = editingDomain.getResourceSet().getResource(uri, false);
                }
            }
        } else {
            IFile file = (IFile)editorInput.getAdapter(IResource.class);
            if (file != null && file.getFileExtension() != null) {
                if (file.getFileExtension().equals("map_diagram") || file.getFileExtension().equals("proc_diagram")) {
                    URI uri = Util.convertIFileToEMFURI(file);
                    String resourceName = uri.trimFileExtension().trimFragment().lastSegment();
                    String extension = uri.fileExtension().replace("_diagram", "");
                    uri = uri.trimFileExtension().trimFragment().trimSegments(3).appendSegment(resourceName).appendFileExtension(extension);
                    resource = editingDomain.getResourceSet().getResource(uri, false);
                    if (resource == null && uri.fragment() != null) {
                        resource = editingDomain.getResourceSet().getResource(uri.trimFragment(), false);
                    }
                } else if (file.getFileExtension().equals("map") || file.getFileExtension().equals("proc")) {
                    URI uri = Util.convertIFileToEMFURI(file);
                    if (uri != null) {
                        resource = editingDomain.getResourceSet().getResource(uri, false);
                    }
                    if (resource == null && uri.fragment() != null) {
                        resource = editingDomain.getResourceSet().getResource(uri.trimFragment(), false);
                    }
                }
            }
        }
        return resource;
    }

    private List<Resource> getDependancies(Object object, HashSet<Resource> handled) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        try {
            Map map = null;
            map = object instanceof EObject ? new LightWeightCrossReferencer(Collections.singleton(object)).findExternalCrossReferences() : new LightWeightCrossReferencer((Resource)object).findExternalCrossReferences();
            for (EObject o : map.keySet()) {
                Resource _r = o.eResource();
                if (_r == null || resources.contains(_r)) continue;
                resources.add(_r);
            }
            ArrayList<Resource> l = new ArrayList<Resource>();
            for (Resource r : resources) {
                if (!handled.add(r)) continue;
                for (Resource r2 : this.getDependancies(r, handled)) {
                    if (resources.contains(r2) || l.contains(r2)) continue;
                    l.add(r2);
                }
            }
            resources.addAll(l);
        }
        catch (Exception ex) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "com.indy.ui.custom.out", Messages.SharedResourceDisposer_15, (Throwable)ex));
        }
        return resources;
    }
}

