/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out.emf;

import com.indy.ui.custom.out.Messages;
import com.indy.ui.custom.out.Util;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;

public class StambiaURIHelper
extends URIEditorInput {
    private final int TYPE_MAP = 1;
    private final int TYPE_PROC = 2;
    private URI semanticUri;
    private URI diagramUri;
    private URI semanticResourceUri;
    private URI diagramResourceUri;
    private String semanticSoruceId;
    private URI semanticRefURI;

    public StambiaURIHelper(URI uri, URI semanticRefURI) throws Exception {
        super(uri);
        this.semanticRefURI = semanticRefURI;
        this.computeInternalUris();
    }

    public URI getSemanticRefURI() {
        return this.semanticRefURI;
    }

    public String getSemanticSourceID() {
        if (this.semanticSoruceId == null) {
            ICacheService cacheService = (ICacheService)E4InjectorHelper.getService(ICacheService.class);
            this.semanticSoruceId = cacheService.getSourceId(this.semanticUri.trimFragment());
        }
        return this.semanticSoruceId;
    }

    public URI getDiagramUri() {
        return this.diagramUri;
    }

    public URI getSemanticResourceUri() {
        return this.semanticResourceUri;
    }

    public URI getDiagramResourceUri() {
        return this.diagramResourceUri;
    }

    private void computeInternalUris() throws Exception {
        boolean isDiagram = false;
        int type = -1;
        if (this.getURI().fileExtension() != null) {
            if (this.getURI().fileExtension().contains("_diagram")) {
                isDiagram = true;
            }
            if (this.getURI().fileExtension().startsWith("map")) {
                type = 1;
            } else if (this.getURI().fileExtension().startsWith("proc")) {
                type = 2;
            }
        }
        ICacheService cacheService = (ICacheService)E4InjectorHelper.getService(ICacheService.class);
        if (!isDiagram) {
            this.semanticUri = this.getURI();
            this.semanticSoruceId = cacheService.getSourceId(this.getURI().trimFragment());
            if (this.semanticSoruceId == null) {
                this.semanticSoruceId = cacheService.getSourceId(this.getURI());
            }
            if (this.semanticSoruceId == null) {
                throw new Exception(Messages.bind((String)Messages.StambiaURIHelper_3, (Object)this.semanticSoruceId));
            }
            this.semanticResourceUri = cacheService.findResourceURIByFileId(this.semanticSoruceId);
            if (this.semanticResourceUri == null) {
                throw new Exception(Messages.bind((String)Messages.StambiaURIHelper_5, (Object)this.semanticSoruceId));
            }
            if (this.getURI().isPlatformPlugin()) {
                if (this.getURI().segment(1).equals("com.indy.environment")) {
                    Path p = new Path("");
                    int i = 1;
                    while (i < this.semanticResourceUri.segmentCount() - 1) {
                        p = p.append(URI.decode((String)this.semanticResourceUri.segment(i)));
                        ++i;
                    }
                    p = p.append("indy.diagram");
                    switch (type) {
                        case 1: {
                            p = p.append("map");
                            break;
                        }
                        case 2: {
                            p = p.append("proc");
                        }
                    }
                    p = p.append(URI.decode((String)this.semanticResourceUri.trimFileExtension().trimFragment().lastSegment()));
                    switch (type) {
                        case 1: {
                            p = p.addFileExtension("map_diagram");
                            break;
                        }
                        case 2: {
                            p = p.addFileExtension("proc_diagram");
                        }
                    }
                    this.diagramResourceUri = URI.createPlatformPluginURI((String)p.toString(), (boolean)true);
                } else {
                    this.diagramResourceUri = URI.createPlatformPluginURI((String)"com.indy.gmf.map.diagram", (boolean)true).appendSegment(this.semanticSoruceId + "-proc").appendFileExtension("proc_diagram");
                }
            } else if (type == 2 && "indy.build".equals(this.semanticResourceUri.segment(2))) {
                this.diagramResourceUri = URI.createPlatformPluginURI((String)"com.indy.gmf.map.diagram", (boolean)true).appendSegment(this.semanticSoruceId).appendFileExtension("proc_diagram");
            } else {
                Path p = new Path("");
                int i = 1;
                while (i < this.semanticResourceUri.segmentCount() - 1) {
                    p = p.append(URI.decode((String)this.semanticResourceUri.segment(i)));
                    ++i;
                }
                p = p.append("indy.diagram");
                switch (type) {
                    case 1: {
                        p = p.append("map");
                        break;
                    }
                    case 2: {
                        p = p.append("proc");
                    }
                }
                p = p.append(URI.decode((String)this.semanticResourceUri.trimFileExtension().trimFragment().lastSegment()));
                switch (type) {
                    case 1: {
                        p = p.addFileExtension("map_diagram");
                        break;
                    }
                    case 2: {
                        p = p.addFileExtension("proc_diagram");
                    }
                }
                this.diagramResourceUri = Util.convertIPathToEMFURI2((IPath)p);
            }
        } else {
            this.diagramResourceUri = this.getURI().trimFragment();
            this.diagramUri = this.getURI();
            switch (type) {
                case 1: {
                    if (!this.diagramUri.isPlatformResource()) {
                        throw new RuntimeException(Messages.StambiaURIHelper_34 + String.valueOf(this.diagramUri));
                    }
                    Path p = new Path("");
                    int i = 1;
                    while (i < this.diagramUri.segmentCount() - 3) {
                        p = p.append(URI.decode((String)this.diagramUri.segment(i)));
                        ++i;
                    }
                    p = p.append(URI.decode((String)this.diagramUri.trimFileExtension().trimFragment().lastSegment()));
                    this.semanticResourceUri = URI.createPlatformResourceURI((String)p.toString(), (boolean)true);
                    break;
                }
                case 2: {
                    if (!this.diagramUri.isPlatformResource()) {
                        String builtProcId = this.diagramUri.trimFileExtension().trimFragment().lastSegment();
                        this.semanticResourceUri = cacheService.findResourceURIByFileId(builtProcId);
                        break;
                    }
                    Path p = new Path("");
                    int i = 1;
                    while (i < this.diagramUri.segmentCount() - 3) {
                        p = p.append(URI.decode((String)this.diagramUri.segment(i)));
                        ++i;
                    }
                    p = p.append(URI.decode((String)this.diagramUri.trimFileExtension().trimFragment().lastSegment()));
                    p = p.addFileExtension("proc");
                    this.semanticResourceUri = URI.createPlatformResourceURI((String)p.toString(), (boolean)true);
                }
            }
            if (this.semanticSoruceId == null) {
                this.semanticSoruceId = cacheService.getSourceId(this.semanticResourceUri);
            }
        }
    }
}

