/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out.emf.internal;

import com.indy.ui.custom.out.Messages;
import com.indy.ui.custom.out.emf.IResourceLocker;
import com.indy.ui.custom.out.emf.StambiaURIHelper;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class ResourceLockerImpl
implements IResourceLocker {
    private HashMap<String, Collection<URI>> lockMap = new HashMap();
    private List<IResourceLocker.IResourceLockerListener> listeners = new ArrayList<IResourceLocker.IResourceLockerListener>();

    @Override
    public void aquireLock(URI resourceURI, String editingDomainID) throws IResourceLocker.AlreadyLockedException, Exception {
        Assert.isNotNull((Object)resourceURI);
        Assert.isNotNull((Object)editingDomainID);
        if (!this.canLock(resourceURI, editingDomainID)) {
            throw new IResourceLocker.AlreadyLockedException(this.findLockOwner(resourceURI), resourceURI);
        }
        this.releaseLock(resourceURI, this.findLockOwner(resourceURI));
        Collection<URI> uris = this.lockMap.get(editingDomainID);
        if (uris == null) {
            uris = new HashSet<URI>();
            this.lockMap.put(editingDomainID, uris);
        }
        uris.add(resourceURI.trimFragment());
        this.fireLockAcquired(resourceURI.trimFragment(), editingDomainID);
    }

    private String findLockOwner(URI resourceURI) {
        URI u = resourceURI.trimFragment();
        for (String id : this.lockMap.keySet()) {
            Collection<URI> l = this.lockMap.get(id);
            if (l == null || !l.contains(u)) continue;
            return id;
        }
        return null;
    }

    @Override
    public boolean canLock(URI resourceURI, String editingDomainID) {
        ICacheService.SourceState st;
        ICacheService s;
        Assert.isNotNull((Object)resourceURI);
        Assert.isNotNull((Object)editingDomainID);
        URI u = resourceURI.trimFragment();
        StambiaURIHelper helper = null;
        try {
            helper = new StambiaURIHelper(u, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (String id : this.lockMap.keySet()) {
            ICacheService.SourceState st2;
            ICacheService s2;
            Collection<URI> l = this.lockMap.get(id);
            if (l == null || !l.contains(u)) continue;
            if (editingDomainID.equals(id)) {
                return false;
            }
            TransactionalEditingDomain domain = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain(id);
            if (domain == null) {
                throw new RuntimeException(Messages.bind((String)Messages.ResourceLockerImpl_0, (Object)resourceURI.toPlatformString(true), (Object)id));
            }
            Resource resource = domain.getResourceSet().getResource(u, false);
            if (resource == null) continue;
            if (resource.isModified()) {
                return false;
            }
            if (!u.isPlatformPlugin() || !u.segment(1).equals("com.indy.environment") || (s2 = (ICacheService)E4InjectorHelper.getService(ICacheService.class)) == null || !s2.isInit() || (st2 = s2.getSourceState(u)) == null || st2.isOverridde()) continue;
            return false;
        }
        return helper == null || !u.isPlatformPlugin() || !u.segment(1).equals("com.indy.environment") || (s = (ICacheService)E4InjectorHelper.getService(ICacheService.class)) == null || !s.isInit() || (st = s.getSourceState(u)) == null || st.isOverridde();
    }

    @Override
    public boolean hasLock(URI resourceURI, String editingDomainID) {
        Assert.isNotNull((Object)resourceURI);
        if (this.lockMap.get(editingDomainID) != null) {
            URI u = resourceURI.trimFragment();
            return this.lockMap.get(editingDomainID).contains(u);
        }
        return false;
    }

    @Override
    public void releaseLock(URI resourceURI, String editingDomainID) {
        if (editingDomainID == null) {
            return;
        }
        Assert.isNotNull((Object)resourceURI);
        if (this.lockMap.get(editingDomainID) != null) {
            URI u = resourceURI.trimFragment();
            boolean b = this.lockMap.get(editingDomainID).remove(u);
            if (b) {
                this.fireLockReleased(u, editingDomainID);
            }
        }
    }

    @Override
    public void addListener(IResourceLocker.IResourceLockerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IResourceLocker.IResourceLockerListener listener) {
        this.listeners.remove(listener);
    }

    private void fireLockReleased(URI resourceURI, String editingDomainID) {
        for (IResourceLocker.IResourceLockerListener l : this.listeners) {
            l.handleLockReleased(resourceURI, editingDomainID);
        }
    }

    private void fireLockAcquired(URI resourceURI, String editingDomainID) {
        for (IResourceLocker.IResourceLockerListener l : this.listeners) {
            l.handleLockAcquired(resourceURI, editingDomainID);
        }
    }

    @Override
    public void releaseEditingDomain(String editingDomainID) {
        this.lockMap.remove(editingDomainID);
    }

    @Override
    public boolean isLockedByAnotherEditingDomain(URI resourceURI, String editingDomainId) {
        String ownerId = this.findLockOwner(resourceURI);
        if (ownerId == null || editingDomainId.equals(ownerId)) {
            URI u = resourceURI.trimFragment();
            StambiaURIHelper helper = null;
            try {
                ICacheService.SourceState st;
                ICacheService s;
                helper = new StambiaURIHelper(u, null);
                if (helper != null && u.isPlatformPlugin() && u.segment(1).equals("com.indy.environment") && (s = (ICacheService)E4InjectorHelper.getService(ICacheService.class)) != null && s.isInit() && (st = s.getSourceState(u)) != null && !st.isOverridde()) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    @Override
    public String getLockOwnerEditingDomainId(URI resourceURI) {
        return this.findLockOwner(resourceURI);
    }
}

