/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out.fixes;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;

public class MacOsTextHelper {
    private static final Map paintListeners = Collections.synchronizedMap(new WeakHashMap());

    public static void handle(Composite textControlComposite, Composite tabbedClientComposite) {
        if (!"macosx".equals(Platform.getOS())) {
            return;
        }
        Layout layout = tabbedClientComposite.getLayout();
        if (layout instanceof GridLayout) {
            ((GridLayout)layout).marginWidth = 4;
            ((GridLayout)layout).marginTop = 2;
            if (paintListeners.get(tabbedClientComposite) == null) {
                paintListeners.put(tabbedClientComposite, new Helper(tabbedClientComposite, textControlComposite));
            }
        }
    }

    public static class Helper
    implements PaintListener,
    Listener {
        private boolean focusOnCreatedList = false;
        private WeakReference<Composite> contentComposite;

        Helper(Composite contentComposite, Composite textControlComposite) {
            this.contentComposite = new WeakReference<Composite>(contentComposite);
            List _l = new List(textControlComposite, 0);
            if (textControlComposite.getLayout() instanceof GridLayout) {
                GridData gridData = new GridData(1, 1, false, false, ((GridLayout)textControlComposite.getLayout()).numColumns, 1);
                gridData.heightHint = 1;
                _l.setLayoutData((Object)gridData);
            }
            _l.addListener(15, (Listener)this);
            _l.addListener(16, (Listener)this);
            contentComposite.addPaintListener((PaintListener)this);
        }

        public void handleEvent(Event event) {
            if (event.type == 16) {
                this.focusOnCreatedList = false;
                this.redrawTopComposite();
            } else if (event.type == 15) {
                this.focusOnCreatedList = true;
                this.redrawTopComposite();
            }
        }

        private void redrawTopComposite() {
            Composite c = (Composite)this.contentComposite.get();
            if (c != null && !c.isDisposed()) {
                c.redraw();
            }
        }

        public void paintControl(PaintEvent e) {
            if (this.focusOnCreatedList) {
                Rectangle r = ((Control)e.widget).getBounds();
                r = new Rectangle(r.x + 4, r.y + 4, r.width - 8, r.height - 8);
                Region reg = new Region();
                reg.add(((Control)e.widget).getBounds());
                reg.subtract(r);
                e.gc.setClipping(reg);
                e.gc.setLineWidth(2);
                e.gc.setForeground(((Control)e.widget).getDisplay().getSystemColor(15));
                e.gc.setBackground(((Control)e.widget).getDisplay().getSystemColor(26));
                e.gc.fillRoundRectangle(reg.getBounds().x, reg.getBounds().y, reg.getBounds().width, reg.getBounds().height, 3, 3);
            }
        }
    }
}

