/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.launcher;

import com.indy.engine.core.module.classloader.DevModuleClassLoaderProvider;
import com.indy.engine.launcher.Messages;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;

public class Launcher {
    private static List<URL> getURL(File directory, boolean recursive, List<String> extensions) throws MalformedURLException, UnsupportedEncodingException {
        ArrayList<URL> list = new ArrayList<URL>();
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory() && recursive) {
                list.addAll(Launcher.getURL(file, recursive, extensions));
            } else {
                boolean b = false;
                for (String extension : extensions) {
                    if (!file.getName().endsWith(extension)) continue;
                    b = true;
                }
                if (b) {
                    list.add(file.toURI().toURL());
                }
            }
            ++n2;
        }
        return list;
    }

    public static void main(String[] args) throws MalformedURLException, ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, UnsupportedEncodingException, NoSuchFieldException {
        String classname = null;
        ArrayList<String> libDir = new ArrayList<String>();
        int j = -1;
        int i = 0;
        while (i < args.length) {
            if (args[i].toLowerCase().equals("-mainclassparameters")) {
                j = i + 1;
                break;
            }
            if (args[i].toLowerCase().equals("-mainclass")) {
                if (i == args.length - 1) {
                    System.err.println(Messages.getString("Launcher.0"));
                    System.exit(-1);
                }
                classname = args[++i];
            } else if (args[i].toLowerCase().equals("-stambiaclasspathv1")) {
                if (i == args.length - 1) {
                    System.err.println(Messages.getString("Launcher.1"));
                    System.exit(-1);
                }
                libDir.add(args[++i]);
            }
            ++i;
        }
        String[] _args = null;
        if (j > -1) {
            _args = new String[args.length - j];
            int i2 = j;
            while (i2 < args.length) {
                _args[i2 - j] = args[i2];
                ++i2;
            }
        } else {
            _args = new String[]{};
        }
        if (classname == null || classname.isEmpty()) {
            System.err.println(Messages.getString("Launcher.2"));
            System.exit(-1);
        }
        if (classname == null || classname.isEmpty()) {
            System.err.println(Messages.getString("Launcher.3"));
            System.exit(-1);
        }
        String[] mask = new String[libDir.size()];
        List list = DevModuleClassLoaderProvider.getURL(null, (String[])libDir.toArray(mask));
        URL[] urls = new URL[list.size()];
        urls = list.toArray(urls);
        ClassLoader scl = ClassLoader.getSystemClassLoader();
        URLClassLoader ucl = new URLClassLoader(urls, scl);
        Thread.currentThread().setContextClassLoader(ucl);
        Class<?> clazz = ucl.loadClass(classname);
        Method met = clazz.getMethod("main", String[].class);
        met.invoke(null, new Object[]{_args});
    }
}

