/*
 * Decompiled with CFR 0.152.
 */
package com.indy.cross;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CrossObjectType implements Enumerator
{
    MAPPING(0, "MAPPING", "MAPPING"),
    PROCESS(1, "PROCESS", "PROCESS"),
    METADATA(2, "METADATA", "METADATA"),
    METADATALINK(3, "METADATALINK", "METADATA_LINK");

    public static final int MAPPING_VALUE = 0;
    public static final int PROCESS_VALUE = 1;
    public static final int METADATA_VALUE = 2;
    public static final int METADATALINK_VALUE = 3;
    private static final CrossObjectType[] VALUES_ARRAY;
    public static final List<CrossObjectType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CrossObjectType[]{MAPPING, PROCESS, METADATA, METADATALINK};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CrossObjectType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CrossObjectType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CrossObjectType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CrossObjectType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CrossObjectType get(int value) {
        switch (value) {
            case 0: {
                return MAPPING;
            }
            case 1: {
                return PROCESS;
            }
            case 2: {
                return METADATA;
            }
            case 3: {
                return METADATALINK;
            }
        }
        return null;
    }

    private CrossObjectType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

