/*
 * Decompiled with CFR 0.152.
 */
package com.indy.model.navigation.ui.view;

import com.indy.emf.uri.navigator.duplicated.LevelMdIConResourceLabelProvider;
import com.indy.model.navigation.ui.view.FilteredDropDownControl;
import com.indy.model.navigation.ui.view.Messages;
import com.indy.model.navigation.ui.view.TechRegistry;
import com.indy.ui.custom.out.Activator;
import com.indy.ui.custom.out.IMetaDataModelProvider;
import com.indy.ui.custom.out.Util;
import com.indy.ui.custom.out.common.TextFilter;
import com.semarchy.xdi.designer.core.models.InternalResourceURIConverter;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IOverrideService;
import com.semarchy.xdi.designer.core.services.IRegistryService;
import com.semarchy.xdi.designer.core.services.registry.LevelCodeInfo;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class SearchModelUI {
    private ActiveEditorTracker editortarcker = new ActiveEditorTracker();
    private Layout layout = Layout.LIST;
    private IMetaDataModelProvider.Mode mode = IMetaDataModelProvider.Mode.MAPPING;
    private FilteredFileType filterType = FilteredFileType.NONE;
    private TabbedPropertySheetWidgetFactory widgetFactory = new TabbedPropertySheetWidgetFactory();
    private TreeViewer fileViewer;
    private TreePath[] modelViewerLastExtended = null;
    private ToolBar tb;
    private ToolBar typeBar;
    private ToolItem toolbarSearchItem;
    private FilteredDropDownControl productFilter;
    private ResourceSet rs = new ResourceSetImpl();
    private ProductInfo currentProduct;
    private List<ProductInfo> productsList = Collections.EMPTY_LIST;
    private Set<String> showedTechIds = new HashSet<String>();
    private Map<IFile, Collection<String>> requiredModels = new HashMap<IFile, Collection<String>>();
    private CachedFilter cachedModelFilter;
    private HashMap<String, Collection<ProductInfo>> productMap = new HashMap();
    UIJob refreshUIJob = new UIJob(Messages.SearchModelUI_5){

        public IStatus runInUIThread(IProgressMonitor monitor) {
            SearchModelUI.this.fileViewer.refresh(true);
            return Status.OK_STATUS;
        }
    };
    static Image linkIMG;
    static Image shellIcon;

    static {
        try {
            linkIMG = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/org.eclipse.ui.navigator/icons/full/elcl16/synced.png")).createImage();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            shellIcon = ImageDescriptor.createFromURL((URL)new URL("platform:plugin/com.indy.gmf.map.edit/icons/full/obj16x16/magnifier.png")).createImage();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SearchModelUI(IMetaDataModelProvider.Mode defaultMode) {
        this.rs = new ResourceSetImpl();
        this.refreshUIJob.setUser(true);
        this.rs.setURIConverter((URIConverter)new InternalResourceURIConverter());
        this.rs.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", true);
        this.mode = defaultMode;
    }

    public void createPartControl(Composite _parent, IMetaDataModelProvider.Mode defaultMode) {
        Composite parent = this.widgetFactory.createComposite(_parent);
        parent.setLayoutData((Object)new GridData(1808));
        parent.setLayout((org.eclipse.swt.widgets.Layout)new GridLayout());
        this.mode = defaultMode;
        Group contextGroup = this.widgetFactory.createGroup(parent, Messages.SearchModelUI_8);
        GridLayout gl = null;
        gl = new GridLayout(2, false);
        contextGroup.setLayout((org.eclipse.swt.widgets.Layout)gl);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        contextGroup.setLayoutData((Object)new GridData(4, 1, true, false));
        ((GridData)contextGroup.getLayoutData()).exclude = true;
        ToolBar _tb = new ToolBar((Composite)contextGroup, 0x800000);
        this.widgetFactory.adapt((Composite)_tb);
        _tb.setLayoutData((Object)new GridData(1, 1, false, false));
        ToolItem it = new ToolItem(_tb, 32);
        it.setImage(linkIMG);
        it.setToolTipText(Messages.SearchModelUI_9);
        it.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchModelUI.this.trackActiveEditor(((ToolItem)e.widget).getSelection());
            }
        });
        this.typeBar = new ToolBar((Composite)contextGroup, 0x800000);
        this.typeBar.setLayoutData((Object)new GridData(4, 1, true, false));
        this.widgetFactory.adapt((Composite)this.typeBar);
        IMetaDataModelProvider.Mode[] modeArray = IMetaDataModelProvider.Mode.values();
        int n = modeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMetaDataModelProvider.Mode m = modeArray[n2];
            it = new ToolItem(this.typeBar, 32);
            it.setText(m.name());
            it.setEnabled(this.mode != m);
            it.setSelection(this.mode == m);
            it.setToolTipText(Messages.SearchModelUI_10);
            class TypeBarListener
            extends SelectionAdapter {
                boolean selecting = false;

                TypeBarListener() {
                }

                public void widgetSelected(SelectionEvent e) {
                    if (this.selecting) {
                        return;
                    }
                    this.selecting = true;
                    ToolBar tb = ((ToolItem)e.widget).getParent();
                    int k = 0;
                    while (k < tb.getItemCount()) {
                        ToolItem i = tb.getItem(k);
                        if (i != e.widget) {
                            i.setSelection(false);
                            i.setEnabled(true);
                        } else {
                            i.setEnabled(false);
                            SearchModelUI.this.mode = IMetaDataModelProvider.Mode.values()[k];
                        }
                        ++k;
                    }
                    this.selecting = false;
                    SearchModelUI.this.updateMdToolbar();
                    SearchModelUI.this.refreshUIJob.schedule(100L);
                }
            }
            it.addSelectionListener((SelectionListener)new TypeBarListener());
            ++n2;
        }
        Group typeGroup = this.widgetFactory.createGroup(parent, Messages.SearchModelUI_11);
        typeGroup.setLayout((org.eclipse.swt.widgets.Layout)new FillLayout());
        typeGroup.setLayoutData((Object)new GridData(4, 1, true, false));
        this.tb = new ToolBar((Composite)typeGroup, 8388928);
        this.widgetFactory.adapt((Composite)this.tb);
        Composite leftPannel = this.widgetFactory.createComposite(parent, 0);
        gl = new GridLayout();
        leftPannel.setLayout((org.eclipse.swt.widgets.Layout)gl);
        leftPannel.setLayoutData((Object)new GridData(4, 4, true, true));
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        Composite c = this.createBottomPannelContent(leftPannel);
        c.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    protected void trackActiveEditor(boolean selection) {
        if (selection) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().addPartListener((IPartListener)this.editortarcker);
            IMetaDataModelProvider.Mode m = this.detectMode(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor());
            if (m != null) {
                int i = 0;
                while (i < this.typeBar.getItemCount()) {
                    if (m.ordinal() == i) {
                        Event ev = new Event();
                        ev.widget = this.typeBar.getItem(i);
                        this.typeBar.getItem(i).notifyListeners(13, ev);
                    }
                    ++i;
                }
            }
        } else {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().removePartListener((IPartListener)this.editortarcker);
        }
    }

    private Composite createBottomPannelContent(Composite main) {
        GridLayout gl = null;
        Group mdGroup = this.widgetFactory.createGroup(main, Messages.SearchModelUI_12);
        mdGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        gl = new GridLayout();
        mdGroup.setLayout((org.eclipse.swt.widgets.Layout)gl);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.verticalSpacing = 1;
        TextFilter mdFilterHelper = new TextFilter();
        Text mdFilterField = mdFilterHelper.create(this.widgetFactory, (Composite)mdGroup);
        mdFilterField.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fileViewer = new TreeViewer(this.widgetFactory.createTree((Composite)mdGroup, 68352));
        this.fileViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.fileViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                if (SearchModelUI.this.layout == Layout.LIST) {
                    return ((Collection)inputElement).toArray(new Object[((Collection)inputElement).size()]);
                }
                HashSet<IProject> r = new HashSet<IProject>();
                for (Object o : (Collection)inputElement) {
                    r.add(((IResource)o).getProject());
                }
                return r.toArray(new Object[r.size()]);
            }

            public Object[] getChildren(Object parentElement) {
                if (SearchModelUI.this.layout == Layout.LIST) {
                    return null;
                }
                try {
                    ArrayList<IResource> l = new ArrayList<IResource>(Arrays.asList(((IContainer)parentElement).members()));
                    Iterator it = l.iterator();
                    while (it.hasNext()) {
                        IResource r = (IResource)it.next();
                        boolean contained = false;
                        for (Object o : (Collection)SearchModelUI.this.fileViewer.getInput()) {
                            if (!r.getFullPath().isPrefixOf(((IResource)o).getFullPath())) continue;
                            contained = true;
                            break;
                        }
                        if (contained) continue;
                        it.remove();
                    }
                    return l.toArray(new Object[l.size()]);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return null;
                }
            }

            public Object getParent(Object element) {
                if (SearchModelUI.this.layout == Layout.LIST) {
                    return null;
                }
                return ((IResource)element).getParent();
            }

            public boolean hasChildren(Object element) {
                if (SearchModelUI.this.layout == Layout.LIST) {
                    return element instanceof Collection;
                }
                return element instanceof IContainer;
            }
        });
        this.fileViewer.setSorter(new ViewerSorter());
        this.fileViewer.setLabelProvider((IBaseLabelProvider)new LevelMdIConResourceLabelProvider());
        this.cachedModelFilter = new CachedFilter();
        this.fileViewer.addFilter((ViewerFilter)this.cachedModelFilter);
        ToolBar modelLayoutTb = new ToolBar((Composite)mdGroup, 0);
        modelLayoutTb.setLayoutData((Object)new GridData(4, 3, true, false));
        this.widgetFactory.adapt((Composite)modelLayoutTb);
        ToolItem it = new ToolItem(modelLayoutTb, 32);
        it.setText(Messages.SearchModelUI_13);
        it.setSelection(true);
        it.setEnabled(false);
        class LayoutListener
        extends SelectionAdapter {
            boolean selecting = false;
            private final /* synthetic */ TextFilter val$mdFilterHelper;

            LayoutListener(TextFilter textFilter) {
                this.val$mdFilterHelper = textFilter;
            }

            public void widgetSelected(SelectionEvent e) {
                if (this.selecting) {
                    return;
                }
                this.selecting = true;
                ToolBar tb = ((ToolItem)e.widget).getParent();
                int k = 0;
                ToolItem[] toolItemArray = tb.getItems();
                int n = toolItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ToolItem i = toolItemArray[n2];
                    if (i != e.widget) {
                        i.setSelection(false);
                        i.setEnabled(true);
                    } else {
                        i.setEnabled(false);
                        if (k == 0) {
                            SearchModelUI.this.modelViewerLastExtended = SearchModelUI.this.fileViewer.getExpandedTreePaths();
                            SearchModelUI.this.layout = Layout.LIST;
                        } else {
                            SearchModelUI.this.layout = Layout.TREE;
                        }
                    }
                    ++k;
                    ++n2;
                }
                this.selecting = false;
                SearchModelUI.this.fileViewer.refresh(true);
                if (SearchModelUI.this.layout == Layout.TREE && SearchModelUI.this.modelViewerLastExtended != null) {
                    SearchModelUI.this.fileViewer.setExpandedTreePaths(SearchModelUI.this.modelViewerLastExtended);
                }
                if (SearchModelUI.this.layout == Layout.TREE && this.val$mdFilterHelper.isFiltering()) {
                    SearchModelUI.this.fileViewer.expandAll();
                }
            }
        }
        it.addSelectionListener((SelectionListener)new LayoutListener(mdFilterHelper));
        it = new ToolItem(modelLayoutTb, 32);
        it.setText(Messages.SearchModelUI_14);
        it.addSelectionListener((SelectionListener)new LayoutListener(mdFilterHelper));
        mdFilterHelper.registerFilter((StructuredViewer)this.fileViewer, new TextFilter.Filter(mdFilterHelper){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (this.filterText == null) {
                    return true;
                }
                if (SearchModelUI.this.layout == Layout.LIST || element instanceof IFile) {
                    String path = ((IFile)element).getName().toString().toLowerCase();
                    return path.matches(this.filterText.toLowerCase());
                }
                for (Object o : (Collection)viewer.getInput()) {
                    String path;
                    boolean m;
                    if (!((IResource)element).getFullPath().isPrefixOf(((IResource)o).getFullPath()) || !(m = (path = ((IFile)o).getFullPath().toString()).matches(this.filterText.toLowerCase()))) continue;
                    return true;
                }
                return false;
            }
        });
        this.fileViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IResource r = (IResource)((IStructuredSelection)event.getSelection()).getFirstElement();
                if (r.getType() == 1) {
                    SearchModelUI.this.openModel((IFile)r);
                }
            }
        });
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        this.fileViewer.addDragSupport(dndOperations, transfers, new DragSourceListener(){
            ISelection selection;

            public void dragStart(DragSourceEvent event) {
                this.selection = SearchModelUI.this.fileViewer.getSelection();
                LocalSelectionTransfer.getTransfer().setSelection(this.selection);
                event.data = this.selection;
                event.doit = true;
            }

            public void dragSetData(DragSourceEvent event) {
                Object sel;
                event.data = TextTransfer.getInstance().isSupportedType(event.dataType) ? ((IStructuredSelection)SearchModelUI.this.fileViewer.getSelection()).getFirstElement().toString() : (sel = ((IStructuredSelection)SearchModelUI.this.fileViewer.getSelection()).getFirstElement());
            }

            public void dragFinished(DragSourceEvent event) {
                this.selection = null;
                LocalSelectionTransfer.getTransfer().setSelection(null);
            }
        });
        final Hyperlink mdModelPath = this.widgetFactory.createHyperlink((Composite)mdGroup, "", 64);
        mdModelPath.setLayoutData((Object)new GridData(4, 3, true, false));
        mdModelPath.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (!SearchModelUI.this.fileViewer.getSelection().isEmpty()) {
                    IResource r = (IResource)((IStructuredSelection)SearchModelUI.this.fileViewer.getSelection()).getFirstElement();
                    try {
                        IViewPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.navigator.ProjectExplorer");
                        part.getViewSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object)r));
                    }
                    catch (PartInitException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        this.fileViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    mdModelPath.setText("");
                } else {
                    IResource r = (IResource)((IStructuredSelection)event.getSelection()).getFirstElement();
                    mdModelPath.setText(r.getFullPath().toString());
                }
                mdModelPath.getParent().layout(true);
            }
        });
        return mdGroup;
    }

    private void openModel(IFile f) {
        try {
            String editorId = null;
            if (f.getFileExtension().equals("md")) {
                editorId = "com.stambia.md.presentation.MdEditorID";
            } else if (f.getFileExtension().equals("proc")) {
                editorId = "com.indy.gmf.proc.diagram.non_rcp.part.ProcDiagramEditorID";
            } else if (f.getFileExtension().equals(Messages.SearchModelUI_19)) {
                editorId = "com.indy.map.diagram.part.MapDiagramEditorID";
            }
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new URIEditorInput(Util.convertIFileToEMFURI((IFile)f)), editorId);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private void initializeContent() {
        if (this.cachedModelFilter != null) {
            this.cachedModelFilter.flush();
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        class Visitor
        implements IResourceVisitor {
            List<IFile> md = new ArrayList<IFile>();
            List<IFile> allFiles = new ArrayList<IFile>();

            Visitor() {
            }

            public boolean visit(IResource resource) throws CoreException {
                if (resource.getType() == 8) {
                    return true;
                }
                if (resource.getType() == 4) {
                    return resource.getProject().exists() && resource.getProject().isOpen();
                }
                if (resource.getType() == 2) {
                    if (resource.getParent() instanceof IProject) {
                        return !resource.getName().equals("indy.build") && !resource.getName().equals("indy.diagram");
                    }
                    return !resource.getName().equals("indy.diagram");
                }
                IMarker[] m = resource.findMarkers("com.stambia.resource.marker.duplicate", true, 0);
                if (m == null || m.length == 0) {
                    if ("md".equals(resource.getFileExtension()) || "map".equals(resource.getFileExtension()) || "proc".equals(resource.getFileExtension())) {
                        this.allFiles.add((IFile)resource);
                    }
                    if ("md".equals(resource.getFileExtension())) {
                        IOverrideService service = (IOverrideService)PlatformUI.getWorkbench().getService(IOverrideService.class);
                        if (!service.isOverrider(Util.convertIFileToEMFURI((IFile)((IFile)resource)))) {
                            this.md.add((IFile)resource);
                        }
                        return true;
                    }
                }
                return false;
            }
        }
        Visitor v = new Visitor();
        try {
            root.accept((IResourceVisitor)v);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.requiredModels.clear();
        Iterator<IFile> it = v.md.iterator();
        while (it.hasNext()) {
            IFile f = it.next();
            String id = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).getSourceId(Util.convertIFileToEMFURI((IFile)f));
            if (id == null || id.startsWith("UUID_")) {
                it.remove();
                continue;
            }
            Collection c = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).getDependencyHelper().getMandatoryMainRequiredSourcesId(id);
            this.requiredModels.put(f, c);
        }
        this.fileViewer.setInput(v.allFiles);
        this.productMap.clear();
        this.productMap = this.gatherProductsInfo();
        this.updateMdToolbar();
        for (Resource r : this.rs.getResources()) {
            r.unload();
        }
        this.rs.getResources().clear();
    }

    public HashMap<String, Collection<ProductInfo>> gatherProductsInfo() {
        TechRegistry rreg = new TechRegistry();
        HashMap<String, Collection<ProductInfo>> result = new HashMap<String, Collection<ProductInfo>>();
        for (TechRegistry.TechDescriptor td : rreg.getDescriptors()) {
            Collection<ProductInfo> c = result.get(td.getCategorie());
            if (c == null) {
                c = new HashSet<ProductInfo>();
                result.put(td.getCategorie(), c);
            }
            if (td.isAdvanced) continue;
            c.add(new ProductInfo(td));
        }
        return result;
    }

    private void fillCategoriesToolbar(ToolBar tb, final Viewer v) {
        ToolItem it;
        IRegistryService.IRegistry lvlRegistry = ((IRegistryService)E4InjectorHelper.getService(IRegistryService.class)).getRegistry(LevelCodeInfo.class);
        block0: for (String categorie : this.productMap.keySet()) {
            boolean skip;
            final Collection<ProductInfo> products = this.productMap.get(categorie);
            HashSet<String> productsIds = new HashSet<String>();
            ProductInfo baseInfos = null;
            for (ProductInfo i : products) {
                productsIds.add(i.ID);
                if (baseInfos != null || i.hidden) continue;
                baseInfos = i;
            }
            boolean bl = skip = baseInfos == null;
            if (!skip) {
                skip = true;
                for (Collection<String> rr : this.requiredModels.values()) {
                    if (Collections.disjoint(productsIds, rr)) continue;
                    skip = false;
                    break;
                }
            }
            if (skip) continue;
            List infos = lvlRegistry.find((IRegistryService.IRegistryMatcher)new LevelCodeInfo.LevelCodeMatcher(baseInfos.lvlCode));
            ToolItem it2 = new ToolItem(tb, 32);
            if (infos == null || infos.isEmpty()) {
                it2.setImage(ExtendedImageRegistry.getInstance().getImage((Object)baseInfos.lvlIconURL));
            } else {
                boolean iconFound = false;
                for (LevelCodeInfo i : infos) {
                    if (!productsIds.contains(i.getRegistrationKey().getProviderFileID())) continue;
                    iconFound = true;
                    it2.setImage(ExtendedImageRegistry.getInstance().getImage((Object)i.getImageURI()));
                    break;
                }
                if (!iconFound) {
                    it2.setImage(ExtendedImageRegistry.getInstance().getImage((Object)((LevelCodeInfo)infos.get(0)).getImageURI()));
                }
            }
            it2.setToolTipText(categorie);
            it2.addSelectionListener((SelectionListener)new SelectionAdapter(){
                boolean selecting = false;

                public void widgetSelected(SelectionEvent e) {
                    if (this.selecting) {
                        return;
                    }
                    this.selecting = true;
                    SearchModelUI.this.filterType = FilteredFileType.NONE;
                    SearchModelUI.this.showedTechIds.clear();
                    ToolItem[] toolItemArray = SearchModelUI.this.tb.getItems();
                    int n = toolItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object i = toolItemArray[n2];
                        if (i != e.widget) {
                            i.setSelection(false);
                        }
                        ++n2;
                    }
                    if (((ToolItem)e.widget).getSelection()) {
                        for (Object i : products) {
                            SearchModelUI.this.showedTechIds.add(i.ID);
                        }
                        SearchModelUI.this.productsList = products == null ? Collections.EMPTY_LIST : new ArrayList<ProductInfo>(products);
                    } else {
                        for (Object i : products) {
                            SearchModelUI.this.showedTechIds.remove(i.ID);
                        }
                        SearchModelUI.this.productsList = Collections.EMPTY_LIST;
                    }
                    SearchModelUI.this.currentProduct = null;
                    SearchModelUI.this.productFilter.clear();
                    v.refresh();
                    if (SearchModelUI.this.layout == Layout.TREE) {
                        SearchModelUI.this.fileViewer.expandAll();
                    }
                    this.selecting = false;
                    SearchModelUI.this.toolbarSearchItem.getControl().setVisible(SearchModelUI.this.productsList.size() > 1);
                }
            });
            for (ProductInfo p : products) {
                if (!this.showedTechIds.contains(p.ID)) continue;
                it2.setSelection(true);
                continue block0;
            }
        }
        if (this.mode == IMetaDataModelProvider.Mode.PROCESS) {
            it = new ToolItem(tb, 32);
            it.setToolTipText(Messages.SearchModelUI_28);
            it.setImage(ExtendedImageRegistry.getInstance().getImage((Object)URI.createURI((String)"platform:/plugin/com.indy.gmf.map.diagram/icons/obj16/map.png")));
            it.addSelectionListener((SelectionListener)new SelectionAdapter(){
                boolean selecting = false;

                public void widgetSelected(SelectionEvent e) {
                    if (this.selecting) {
                        return;
                    }
                    this.selecting = true;
                    SearchModelUI.this.showedTechIds.clear();
                    ToolItem[] toolItemArray = SearchModelUI.this.tb.getItems();
                    int n = toolItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ToolItem i = toolItemArray[n2];
                        if (i != e.widget) {
                            i.setSelection(false);
                        }
                        ++n2;
                    }
                    SearchModelUI.this.filterType = ((ToolItem)e.widget).getSelection() ? FilteredFileType.MAPPING : FilteredFileType.NONE;
                    SearchModelUI.this.productsList = Collections.EMPTY_LIST;
                    SearchModelUI.this.currentProduct = null;
                    SearchModelUI.this.productFilter.clear();
                    v.refresh();
                    if (SearchModelUI.this.layout == Layout.TREE) {
                        SearchModelUI.this.fileViewer.expandAll();
                    }
                    this.selecting = false;
                    SearchModelUI.this.toolbarSearchItem.getControl().setVisible(!SearchModelUI.this.productsList.isEmpty());
                }
            });
        }
        if (this.mode == IMetaDataModelProvider.Mode.PROCESS) {
            it = new ToolItem(tb, 32);
            it.setToolTipText(Messages.SearchModelUI_30);
            it.setImage(ExtendedImageRegistry.getInstance().getImage((Object)URI.createURI((String)"platform:/plugin/com.indy.gmf.process.diagram.non_rcp/icons/obj16/ProcDiagramFile.png")));
            it.addSelectionListener((SelectionListener)new SelectionAdapter(){
                boolean selecting = false;

                public void widgetSelected(SelectionEvent e) {
                    if (this.selecting) {
                        return;
                    }
                    this.selecting = true;
                    SearchModelUI.this.showedTechIds.clear();
                    ToolItem[] toolItemArray = SearchModelUI.this.tb.getItems();
                    int n = toolItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ToolItem i = toolItemArray[n2];
                        if (i != e.widget) {
                            i.setSelection(false);
                        }
                        ++n2;
                    }
                    SearchModelUI.this.filterType = ((ToolItem)e.widget).getSelection() ? FilteredFileType.PROCESS : FilteredFileType.NONE;
                    SearchModelUI.this.productsList = Collections.EMPTY_LIST;
                    SearchModelUI.this.currentProduct = null;
                    SearchModelUI.this.productFilter.clear();
                    v.refresh();
                    if (SearchModelUI.this.layout == Layout.TREE) {
                        SearchModelUI.this.fileViewer.expandAll();
                    }
                    this.selecting = false;
                    SearchModelUI.this.toolbarSearchItem.getControl().setVisible(!SearchModelUI.this.productsList.isEmpty());
                }
            });
        }
        this.toolbarSearchItem = new ToolItem(tb, 2);
        this.createProductViewer(this.toolbarSearchItem);
        this.toolbarSearchItem.getControl().setVisible(!this.productsList.isEmpty());
    }

    private void createProductViewer(ToolItem sep) {
        this.productFilter = new FilteredDropDownControl();
        Composite c = this.productFilter.createContent((Composite)this.tb, new FilteredDropDownControl.ContentProvider(){

            @Override
            public Object getContent() {
                return SearchModelUI.this.productsList;
            }

            @Override
            public void selectProduct(ProductInfo i) {
                SearchModelUI.this.currentProduct = i;
                SearchModelUI.this.fileViewer.refresh();
                if (SearchModelUI.this.layout == Layout.TREE) {
                    SearchModelUI.this.fileViewer.expandAll();
                }
            }
        });
        sep.setWidth(100);
        sep.setControl((Control)c);
    }

    private void updateMdToolbar() {
        ToolItem[] toolItemArray = this.tb.getItems();
        int n = toolItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem k = toolItemArray[n2];
            if (k.getControl() != null) {
                k.getControl().dispose();
            }
            k.dispose();
            ++n2;
        }
        this.fillCategoriesToolbar(this.tb, (Viewer)this.fileViewer);
        this.tb.layout(true, true);
        this.tb.getParent().layout(true, true);
        this.tb.getParent().getParent().layout(true, true);
    }

    private IMetaDataModelProvider.Mode detectMode(IEditorPart p) {
        return IMetaDataModelProvider.Mode.MAPPING;
    }

    public void openPopup() {
        Shell sh = new Shell(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 112);
        sh.setText(Messages.SearchModelUI_35);
        sh.setImage(shellIcon);
        sh.setLayout((org.eclipse.swt.widgets.Layout)new GridLayout());
        sh.addShellListener(new ShellListener(){

            public void shellIconified(ShellEvent e) {
            }

            public void shellDeiconified(ShellEvent e) {
            }

            public void shellDeactivated(ShellEvent e) {
            }

            public void shellClosed(ShellEvent e) {
                Point pt = ((Shell)e.widget).getLocation();
                Point sz = ((Shell)e.widget).getSize();
                IDialogSettings set = Activator.getDefault().getDialogSettings().getSection("com.indy.model.navigation.ui");
                if (set == null) {
                    set = Activator.getDefault().getDialogSettings().addNewSection("com.indy.model.navigation.ui");
                }
                set.put("SearchModelUI.popup.x", pt.x);
                set.put("SearchModelUI.popup.y", pt.y);
                set.put("SearchModelUI.popup.width", sz.x);
                set.put("SearchModelUI.popup.height", sz.y);
                SearchModelUI.this.trackActiveEditor(false);
            }

            public void shellActivated(ShellEvent e) {
            }
        });
        this.widgetFactory.adapt((Composite)sh);
        this.createPartControl((Composite)sh, this.detectMode(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()));
        IDialogSettings set = Activator.getDefault().getDialogSettings().getSection("com.indy.model.navigation.ui");
        Point sz = new Point(300, 300);
        if (set != null) {
            Point pt = null;
            try {
                pt = new Point(set.getInt("SearchModelUI.popup.x"), set.getInt("SearchModelUI.popup.y"));
                sz = new Point(set.getInt("SearchModelUI.popup.width"), set.getInt("SearchModelUI.popup.height"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (pt != null) {
                sh.setLocation(pt);
            }
        }
        sh.setSize(sz);
        this.fileViewer.getControl().forceFocus();
        sh.open();
        this.initializeContent();
    }

    class ActiveEditorTracker
    implements IPartListener {
        ActiveEditorTracker() {
        }

        public void partActivated(IWorkbenchPart part) {
            if (part instanceof IEditorPart) {
                IMetaDataModelProvider.Mode m = SearchModelUI.this.detectMode((IEditorPart)part);
                int i = 0;
                while (i < SearchModelUI.this.typeBar.getItemCount()) {
                    if (m.ordinal() == i) {
                        SearchModelUI.this.typeBar.getItem(i).setSelection(true);
                        SearchModelUI.this.typeBar.getItem(i).setEnabled(false);
                        Event ev = new Event();
                        ev.widget = SearchModelUI.this.typeBar.getItem(i);
                        SearchModelUI.this.typeBar.getItem(i).notifyListeners(13, ev);
                    }
                    ++i;
                }
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }

    class CachedFilter
    extends ViewerFilter {
        WeakHashMap<IFile, HashMap<String, Boolean>> filterValuesMode = new WeakHashMap();

        CachedFilter() {
        }

        boolean checkExtension(IFile file) {
            String extension = file.getFileExtension();
            switch (SearchModelUI.this.mode) {
                case MAPPING: {
                    return "md".equals(extension);
                }
                case MD: {
                    switch (SearchModelUI.this.filterType) {
                        case NONE: {
                            return "md".equals(extension);
                        }
                        case MAPPING: {
                            return false;
                        }
                        case PROCESS: {
                            return "proc".equals(extension);
                        }
                    }
                }
                case PROCESS: {
                    switch (SearchModelUI.this.filterType) {
                        case NONE: {
                            return true;
                        }
                        case MAPPING: {
                            return "map".equals(extension);
                        }
                        case PROCESS: {
                            return "proc".equals(extension);
                        }
                    }
                }
            }
            return false;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (SearchModelUI.this.layout == Layout.LIST) {
                boolean res = this.checkExtension((IFile)element);
                if (!res) {
                    return false;
                }
                if (!SearchModelUI.this.showedTechIds.isEmpty()) {
                    Collection<String> c = SearchModelUI.this.requiredModels.get(element);
                    boolean bl = res = c != null && !Collections.disjoint(c, SearchModelUI.this.showedTechIds);
                }
                if (!res) {
                    return false;
                }
                if (SearchModelUI.this.currentProduct != null) {
                    List l = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).getDependencyHelper().getUsage(SearchModelUI.this.currentProduct.uri);
                    URI modelURI = Util.convertIFileToEMFURI((IFile)((IFile)element));
                    res = l.contains(modelURI);
                }
                return res;
            }
            for (Object o : (Collection)viewer.getInput()) {
                if (!((IResource)element).getFullPath().isPrefixOf(((IResource)o).getFullPath())) continue;
                boolean res = false;
                res = this.checkExtension((IFile)o);
                if (!SearchModelUI.this.showedTechIds.isEmpty()) {
                    Collection<String> c = SearchModelUI.this.requiredModels.get(o);
                    boolean bl = res = c != null && !Collections.disjoint(c, SearchModelUI.this.showedTechIds);
                }
                if (res && SearchModelUI.this.currentProduct != null) {
                    URI modelURI = Util.convertIFileToEMFURI((IFile)((IFile)o));
                    List l = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).getDependencyHelper().getUsage(SearchModelUI.this.currentProduct.uri);
                    res = l.contains(modelURI);
                }
                if (!res) continue;
                return true;
            }
            return false;
        }

        public void flush() {
            this.filterValuesMode.clear();
        }
    }

    static enum FilteredFileType {
        NONE,
        MAPPING,
        PROCESS;

    }

    static enum Layout {
        LIST,
        TREE;

    }

    static class ProductInfo {
        public String ID;
        public String label;
        public URI uri;
        public String lvlCode;
        public URL lvlIconURL;
        public boolean hidden;
        public boolean visible4Mapping;

        ProductInfo(TechRegistry.TechDescriptor td) {
            this.ID = td.UUID;
            this.label = td.label;
            this.lvlCode = td.levelCode;
            this.lvlIconURL = td.iconURL;
            this.hidden = td.isAdvanced;
            this.uri = td.modelURI;
            this.visible4Mapping = td.isMapping;
        }
    }
}

