/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.help.internal.demo;

import com.indy.ui.help.IHelpEntries;
import com.indy.ui.help.internal.demo.Messages;
import com.indy.ui.help.internal.demo.NavigatorContentProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public class NavigatorActionProvider
extends CommonActionProvider {
    private OpenHelpAction openHelpAction;
    private boolean myContribute;

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        if (aSite.getViewSite() instanceof ICommonViewerWorkbenchSite) {
            this.myContribute = true;
            this.makeActions((ICommonViewerWorkbenchSite)aSite.getViewSite());
        } else {
            this.myContribute = false;
        }
    }

    private void makeActions(ICommonViewerWorkbenchSite viewerSite) {
        this.openHelpAction = new OpenHelpAction(viewerSite);
    }

    public void fillActionBars(IActionBars actionBars) {
        if (!this.myContribute) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        this.openHelpAction.selectionChanged(selection);
        if (this.openHelpAction.isEnabled()) {
            actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openHelpAction);
        }
    }

    public void fillContextMenu(IMenuManager menu) {
    }

    private class OpenHelpAction
    extends Action {
        private String sampleHref;

        public OpenHelpAction(ICommonViewerWorkbenchSite viewerSite) {
            super(Messages.NavigatorActionProvider_0);
        }

        public final void selectionChanged(IStructuredSelection selection) {
            Object selectedElement;
            this.sampleHref = null;
            if (selection.size() == 1 && (selectedElement = selection.getFirstElement()) instanceof NavigatorContentProvider.SampleDocumentationTopic) {
                this.sampleHref = ((NavigatorContentProvider.SampleDocumentationTopic)selectedElement).getHref();
            }
            this.setEnabled(this.sampleHref != null);
        }

        public void run() {
            PlatformUI.getWorkbench().getHelpSystem().displayHelp(IHelpEntries.sampleDoc(this.sampleHref));
        }
    }
}

