/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum JoinType implements Enumerator
{
    INNER_JOIN(0, "InnerJoin", "Inner_Join"),
    LEFT_JOIN(1, "LeftJoin", "Left_Join"),
    RIGHT_JOIN(2, "RightJoin", "Right_Join"),
    CROSS_JOIN(3, "CrossJoin", "Cross_Join"),
    FULL_JOIN(4, "FullJoin", "Full_Join");

    public static final int INNER_JOIN_VALUE = 0;
    public static final int LEFT_JOIN_VALUE = 1;
    public static final int RIGHT_JOIN_VALUE = 2;
    public static final int CROSS_JOIN_VALUE = 3;
    public static final int FULL_JOIN_VALUE = 4;
    private static final JoinType[] VALUES_ARRAY;
    public static final List<JoinType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new JoinType[]{INNER_JOIN, LEFT_JOIN, RIGHT_JOIN, CROSS_JOIN, FULL_JOIN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static JoinType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            JoinType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static JoinType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            JoinType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static JoinType get(int value) {
        switch (value) {
            case 0: {
                return INNER_JOIN;
            }
            case 1: {
                return LEFT_JOIN;
            }
            case 2: {
                return RIGHT_JOIN;
            }
            case 3: {
                return CROSS_JOIN;
            }
            case 4: {
                return FULL_JOIN;
            }
        }
        return null;
    }

    private JoinType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

