/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum OperatorType implements Enumerator
{
    EXISTS(0, "EXISTS", "EXISTS"),
    NOTEXISTS(1, "NOTEXISTS", "NOT_EXISTS");

    public static final int EXISTS_VALUE = 0;
    public static final int NOTEXISTS_VALUE = 1;
    private static final OperatorType[] VALUES_ARRAY;
    public static final List<OperatorType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new OperatorType[]{EXISTS, NOTEXISTS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static OperatorType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OperatorType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OperatorType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OperatorType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OperatorType get(int value) {
        switch (value) {
            case 0: {
                return EXISTS;
            }
            case 1: {
                return NOTEXISTS;
            }
        }
        return null;
    }

    private OperatorType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

