/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.api.internal;

import com.indy.map.api.internal.CachedMetaDataInformationsProvider;
import com.indy.map.api.internal.MdInfoExtractor;
import com.semarchy.xdi.designer.core.models.IMetaDataInformationsProviderFactory;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={IMetaDataInformationsProviderFactory.class})
public class MetaDataInformationsProviderFactoryImpl
implements IMetaDataInformationsProviderFactory {
    private ICacheService.IDependenciesGraphAnalyzer dependenciesAnalyzer;
    private HashSet<String> loadedMdIds = new HashSet();
    private HashMap<String, Properties> loadedMap = new HashMap();
    private Properties props = new Properties();

    public IMetaDataInformationsProviderFactory.Clearable createMetaDataInformationsProvider(ResourceSet rs) {
        return new CachedMetaDataInformationsProvider(rs, this);
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, unbind="unbind")
    public void bind(ICacheService.IDependenciesGraphAnalyzer graphAnalyzer) {
        this.dependenciesAnalyzer = graphAnalyzer;
    }

    @Reference(policy=ReferencePolicy.STATIC, unbind="-")
    public void bindEnv(EnvironmentInfo info) {
        Bundle bundle;
        IPath path;
        File wkspLocation;
        String s = info.getProperty("osgi.clean");
        if (s != null && Boolean.valueOf(s).booleanValue() && (wkspLocation = new File((path = Platform.getStateLocation((Bundle)(bundle = Platform.getBundle((String)"com.indy.gmf.map")))).toFile(), "mdEvalBackup")).exists()) {
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (Stream<Path> stream = Files.walk(wkspLocation.toPath(), new FileVisitOption[0]);){
                    stream.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void unbind(ICacheService.IDependenciesGraphAnalyzer graphAnalyzer) {
        this.cleanupInvalidatedFiles();
        this.dependenciesAnalyzer = null;
    }

    @Deactivate
    public void deactivate() {
        this.cleanupInvalidatedFiles();
    }

    private void cleanupInvalidatedFiles() {
        if (this.dependenciesAnalyzer == null) {
            return;
        }
        for (String s : this.dependenciesAnalyzer.getInvalidatedModelsId()) {
            Bundle bundle;
            IPath path;
            File wkspLocation;
            File file;
            if (this.loadedMdIds.remove(s)) {
                this.props.keySet().removeAll(this.loadedMap.remove(s).keySet());
            }
            if (!(file = new File(wkspLocation = new File((path = Platform.getStateLocation((Bundle)(bundle = Platform.getBundle((String)"com.indy.gmf.map")))).toFile(), "mdEvalBackup"), s)).exists()) continue;
            file.delete();
        }
    }

    public synchronized String readProperty(ResourceSet resourceSet, String key, String mdFileId) {
        if (mdFileId == null || mdFileId.isEmpty()) {
            return null;
        }
        this.cleanupInvalidatedFiles();
        if (this.loadedMdIds.add(mdFileId)) {
            this.dependenciesAnalyzer.monitorModelsDependancies(Collections.singletonList(mdFileId));
            Bundle bundle = Platform.getBundle((String)"com.indy.gmf.map");
            IPath path = Platform.getStateLocation((Bundle)bundle);
            File wkspLocation = new File(path.toFile(), "mdEvalBackup");
            wkspLocation.mkdirs();
            File file = new File(wkspLocation, mdFileId);
            if (file.exists()) {
                try {
                    Properties prop = new Properties();
                    try (InputStream is = null;){
                        is = new BufferedInputStream(new FileInputStream(file));
                        prop.load(is);
                        this.loadedMap.put(mdFileId, prop);
                        this.props.putAll((Map<?, ?>)prop);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else {
                MdInfoExtractor extractor = new MdInfoExtractor();
                URI uri = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).findResourceURIByFileId(mdFileId);
                if (uri != null) {
                    try {
                        Properties prop = extractor.extractMdInformation(resourceSet.getResource(uri, true));
                        this.loadedMap.put(mdFileId, prop);
                        this.props.putAll((Map<?, ?>)prop);
                        try (OutputStream out = null;){
                            out = new BufferedOutputStream(new FileOutputStream(file));
                            prop.store(out, null);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else {
                    return null;
                }
            }
        }
        String v = this.props.getProperty(key);
        return v;
    }

    public synchronized void clear() {
        this.loadedMdIds.clear();
        this.props.clear();
        this.loadedMap.clear();
    }
}

