/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.compute.graph;

import com.indy.map.Map;
import com.indy.map.compute.graph.Graph;
import com.indy.map.compute.graph.builder.DataSetFilterGraphBuilder;
import com.indy.map.compute.graph.builder.DataSetGraphBuilder;
import com.indy.map.compute.graph.builder.DataSetJoinGraphBuilder;
import com.indy.map.compute.graph.builder.DataSetOperatorGraphBuilder;
import com.indy.map.compute.graph.builder.FlowGraphBuilder;
import com.indy.map.compute.graph.builder.MappingGraphBuilder;
import com.indy.map.compute.graph.builder.ResourceDependanciesGraphBuilder;
import java.util.Collection;

public class GraphBuilderFactory {
    public static GraphBuilderFactory INSTANCE = new GraphBuilderFactory();
    private DataSetGraphBuilder dataSetGraphBuilder = new DataSetGraphBuilder();
    private DataSetJoinGraphBuilder joinGraphBuilder = new DataSetJoinGraphBuilder();
    private MappingGraphBuilder targetSetJoinGraphBuilder = new MappingGraphBuilder();
    private ResourceDependanciesGraphBuilder resourceDepBuilder = new ResourceDependanciesGraphBuilder();
    private DataSetFilterGraphBuilder dataSetFilterGraphBuilder = new DataSetFilterGraphBuilder();
    private DataSetOperatorGraphBuilder dataSetOperatorGraphBuilder = new DataSetOperatorGraphBuilder();

    private GraphBuilderFactory() {
    }

    public Graph getGraphBuilder(GraphType type, Object modelObject) {
        switch (type) {
            case DATASET: {
                if (modelObject instanceof Map) {
                    return this.dataSetGraphBuilder.buildGraph(modelObject);
                }
            }
            case DATASET_FILTER: {
                if (modelObject instanceof Map) {
                    return this.dataSetFilterGraphBuilder.buildGraph(modelObject);
                }
            }
            case DATASET_OPERATOR: {
                if (modelObject instanceof Map) {
                    return this.dataSetOperatorGraphBuilder.buildGraph(modelObject);
                }
            }
            case DATASET_JOIN: {
                if (modelObject instanceof Map) {
                    return this.joinGraphBuilder.buildGraph(modelObject);
                }
            }
            case TARGETSET_JOIN: {
                if (modelObject instanceof Map) {
                    return this.targetSetJoinGraphBuilder.buildGraph(modelObject);
                }
            }
            case RESOURCE_DEPENDENCY: {
                if (modelObject instanceof Collection) {
                    return this.resourceDepBuilder.buildGraph(modelObject);
                }
            }
            case BIDI: {
                return new FlowGraphBuilder.BidiGraph();
            }
        }
        return null;
    }

    public static enum GraphType {
        DATASET,
        DATASET_FILTER,
        DATASET_OPERATOR,
        DATASET_JOIN,
        TARGETSET_JOIN,
        RESOURCE_DEPENDENCY,
        BIDI;

    }
}

