/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.compute.graph.builder;

import com.indy.map.DataSet;
import com.indy.map.Expression;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.Map;
import com.indy.map.SetDescriptor;
import com.indy.map.compute.graph.Edge;
import com.indy.map.compute.graph.Graph;
import com.indy.map.compute.graph.IGraphBuilder;
import com.indy.map.compute.graph.Vertice;
import com.indy.map.messages.Messages;
import com.indy.map.ref.RContainer;
import com.indy.map.ref.RMap;
import com.indy.map.ref.RSourceItem;
import com.indy.map.ref.RTargetSet;
import com.indy.map.util.InheritanceHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class FlowGraphBuilder
implements IGraphBuilder {
    private static final FlowGraphBuilder INSTANCE = new FlowGraphBuilder();

    private FlowGraphBuilder() {
    }

    @Override
    public Graph buildGraph(Object modelObject) {
        Vertice parVert;
        Map map = (Map)modelObject;
        BidiGraph graph = new BidiGraph();
        for (DataSet ds : map.getDataSet()) {
            parVert = graph.createVertice(ds);
            for (DataSet c : ds.getChild()) {
                Vertice childVert = graph.getVertice(c);
                if (childVert == null) {
                    childVert = graph.createVertice(c);
                }
                graph.createEdge(parVert, childVert);
            }
        }
        for (RTargetSet ts : ((RMap)map.getMapReference()).getTargetSetRef()) {
            parVert = graph.createVertice(new TargetSet(ts));
            for (RContainer r : ts.getContainer()) {
                for (DataSet ds : FlowGraphBuilder.exteractDataSetInputs((IContainer)r.getDataModel())) {
                    Vertice v = graph.getVertice(ds);
                    graph.createEdge(v, parVert);
                }
            }
        }
        return graph;
    }

    private static List<DataSet> exteractDataSetInputs(IContainer container) {
        ArrayList<DataSet> l = new ArrayList<DataSet>();
        for (ILogicalField f : container.getLogicalField()) {
            for (Expression ex : f.getExpression()) {
                for (RSourceItem srcIt : container.getAPI().getSourceItems(ex)) {
                    IContainer srcContainer;
                    if (!(srcIt.getDataModel() instanceof ILogicalField) || (srcContainer = (IContainer)srcIt.getDataModel().eContainer()) == null || l.contains(srcContainer.getDataset())) continue;
                    l.add(srcContainer.getDataset());
                }
            }
        }
        HashSet<DataSet> s = new HashSet<DataSet>();
        for (DataSet ds : l) {
            s.addAll(InheritanceHelper.getDataSetHierarchy(ds));
            s.addAll(ds.getFilteringOperatorRequirement());
        }
        s.addAll(l);
        l.clear();
        l.addAll(s);
        return l;
    }

    private static List<DataSet> exteractDataSetInputs(SetDescriptor descriptor) {
        ArrayList<DataSet> l = new ArrayList<DataSet>();
        for (ILogicalField f : ((IContainer)descriptor.eContainer()).getLogicalField()) {
            for (Expression ex : f.getExpression()) {
                if (ex.getSetDescriptorRef() != descriptor) continue;
                for (RSourceItem srcIt : descriptor.getAPI().getSourceItems(ex)) {
                    IContainer srcContainer;
                    if (!(srcIt.getDataModel() instanceof ILogicalField) || (srcContainer = (IContainer)srcIt.getDataModel().eContainer()) == null || l.contains(srcContainer.getDataset())) continue;
                    l.add(srcContainer.getDataset());
                }
            }
        }
        HashSet<DataSet> s = new HashSet<DataSet>();
        for (DataSet ds : l) {
            s.addAll(InheritanceHelper.getDataSetHierarchy(ds));
            s.addAll(ds.getFilteringOperatorRequirement());
        }
        s.addAll(l);
        l.clear();
        l.addAll(s);
        return l;
    }

    public static GraphNavigator createGraphNavigator(Map mapModel) {
        BidiGraph graph = (BidiGraph)INSTANCE.buildGraph(mapModel);
        return new Navigator(graph);
    }

    public static class BidiGraph
    extends Graph {
        private HashMap<Vertice, Object> invertMap = new HashMap();

        @Override
        public Vertice createVertice(Object modelObject) {
            Vertice v = super.createVertice(modelObject);
            if (this.invertMap.get(v) == null) {
                this.invertMap.put(v, modelObject);
            }
            return v;
        }

        @Override
        public void registerModel4Vertice(Object modelObject, Vertice v) {
            super.registerModel4Vertice(modelObject, v);
            if (this.invertMap.get(v) == null) {
                this.invertMap.put(v, modelObject);
            }
        }

        public Object getModelObject(Vertice vertice) {
            return this.invertMap.get(vertice);
        }

        public List<Edge> getEdgeWithEnd(Vertice v) {
            ArrayList<Edge> l = new ArrayList<Edge>();
            for (Edge e : this.getEdges()) {
                if (e.getEnd() != v) continue;
                l.add(e);
            }
            return l;
        }

        public List<Edge> getEdgesWithStart(Vertice v) {
            ArrayList<Edge> l = new ArrayList<Edge>();
            for (Edge e : this.getEdges()) {
                if (e.getStart() != v) continue;
                l.add(e);
            }
            return l;
        }

        @Override
        public void dump(Vertice v) {
            Object o = this.getModelObject(v);
            if (o instanceof DataSet) {
                System.out.println(Messages.FlowGraphBuilder_3 + String.valueOf(o) + ")");
            } else if (o instanceof TargetSet) {
                System.out.println("\tTS (" + String.valueOf(o) + ")");
            }
        }
    }

    public static interface GraphNavigator {
        public List<DataSet> getDataSetNodes();

        public List<TargetSet> getTargetSetNodes();

        public List getAllNodes();

        public List<IContainer> getTargetContainers();

        public List<DataSet> getDataSetParent(DataSet var1);

        public List<DataSet> getDataSetChildren(DataSet var1);

        public List<TargetSet> getTargetSet(DataSet var1);

        public List<DataSet> getDataSetInputs(IContainer var1);

        public List<DataSet> getDataSetInputs(SetDescriptor var1);

        public List<DataSet> getDataSetInputs(TargetSet var1);

        public List<DataSet> getRootNodes();

        public List getChildrenNodes(Object var1);

        public void dump();
    }

    private static class Navigator
    implements GraphNavigator {
        private BidiGraph graph;

        public Navigator(BidiGraph graph) {
            this.graph = graph;
        }

        @Override
        public List<DataSet> getDataSetNodes() {
            ArrayList<DataSet> l = new ArrayList<DataSet>();
            for (Vertice v : this.graph.getVertex()) {
                Object o = this.graph.getModelObject(v);
                if (!(o instanceof DataSet) || l.contains(o)) continue;
                l.add((DataSet)o);
            }
            return l;
        }

        @Override
        public List<TargetSet> getTargetSetNodes() {
            ArrayList<TargetSet> l = new ArrayList<TargetSet>();
            for (Vertice v : this.graph.getVertex()) {
                Object o = this.graph.getModelObject(v);
                if (!(o instanceof TargetSet) || l.contains(o)) continue;
                l.add((TargetSet)o);
            }
            return l;
        }

        @Override
        public List getAllNodes() {
            ArrayList<TargetSet> l = new ArrayList<TargetSet>();
            for (Vertice v : this.graph.getVertex()) {
                Object o = this.graph.getModelObject(v);
                l.add((TargetSet)o);
            }
            return l;
        }

        @Override
        public List<IContainer> getTargetContainers() {
            ArrayList<IContainer> l = new ArrayList<IContainer>();
            for (TargetSet c : this.getTargetSetNodes()) {
                l.addAll(c.getContainers());
            }
            return l;
        }

        @Override
        public List<DataSet> getDataSetParent(DataSet dataSet) {
            return new ArrayList<DataSet>((Collection<DataSet>)dataSet.getParent());
        }

        @Override
        public List<DataSet> getDataSetChildren(DataSet dataSet) {
            return new ArrayList<DataSet>((Collection<DataSet>)dataSet.getChild());
        }

        @Override
        public List<TargetSet> getTargetSet(DataSet dataSet) {
            ArrayList<TargetSet> res = new ArrayList<TargetSet>();
            for (Edge e : this.graph.getEdgesWithStart(this.graph.getVertice(dataSet))) {
                Object o = this.graph.getModelObject(e.getEnd());
                if (!(o instanceof TargetSet)) continue;
                if (res != null && res != o) {
                    throw new RuntimeException(Messages.FlowGraphBuilder_7);
                }
                if (res.contains(o)) continue;
                res.add((TargetSet)o);
            }
            return res;
        }

        @Override
        public List<DataSet> getDataSetInputs(IContainer container) {
            return FlowGraphBuilder.exteractDataSetInputs(container);
        }

        @Override
        public List<DataSet> getDataSetInputs(SetDescriptor setDescriptor) {
            return FlowGraphBuilder.exteractDataSetInputs(setDescriptor);
        }

        @Override
        public List<DataSet> getDataSetInputs(TargetSet targetSet) {
            ArrayList<DataSet> l = new ArrayList<DataSet>();
            for (IContainer c : targetSet.getContainers()) {
                for (DataSet ds : this.getDataSetInputs(c)) {
                    if (l.contains(ds)) continue;
                    l.add(ds);
                }
            }
            return l;
        }

        @Override
        public List<DataSet> getRootNodes() {
            ArrayList<DataSet> l = new ArrayList<DataSet>();
            for (Vertice v : this.graph.getVertex()) {
                Object obj;
                if (!this.graph.getEdgeWithEnd(v).isEmpty() || !((obj = this.graph.getModelObject(v)) instanceof DataSet)) continue;
                boolean noInput = true;
                for (IContainer c : ((DataSet)obj).getContainer()) {
                    if (this.getDataSetInputs(c).isEmpty()) continue;
                    noInput = false;
                    break;
                }
                if (!noInput) continue;
                l.add((DataSet)obj);
            }
            return l;
        }

        @Override
        public List getChildrenNodes(Object node) {
            ArrayList<Object> l = new ArrayList<Object>();
            Vertice v = this.graph.getVertice(node);
            for (Edge e : this.graph.getEdgesWithStart(v)) {
                l.add(this.graph.getModelObject(e.getEnd()));
            }
            return l;
        }

        @Override
        public void dump() {
            this.graph.dump();
        }
    }

    public class TargetSet {
        private List<IContainer> l = new ArrayList<IContainer>();
        private RTargetSet refModel;

        private TargetSet(RTargetSet ref) {
            this.refModel = ref;
            for (RContainer r : ref.getContainer()) {
                this.l.add((IContainer)r.getDataModel());
            }
        }

        public RTargetSet getRefModel() {
            return this.refModel;
        }

        public List<IContainer> getContainers() {
            return this.l;
        }

        public String toString() {
            StringBuffer b = new StringBuffer();
            b.append("{");
            for (IContainer c : this.getContainers()) {
                if (b.length() != 0) {
                    b.append(",");
                }
                b.append(c.getAlias());
            }
            b.append("}");
            return b.toString();
        }
    }
}

