/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.compute.graph.tools;

import com.indy.map.compute.graph.Edge;
import com.indy.map.compute.graph.Graph;
import com.indy.map.compute.graph.Vertice;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class LoopDetector {
    private Graph graph;
    private int index;

    public LoopDetector(Graph graph) {
        this.graph = graph;
    }

    public boolean hasLoop_undirected(Vertice start, Vertice end) {
        try {
            this.visitVertice(start);
            return start.getState() == Vertice.State.VISITED && end.getState() == Vertice.State.VISITED;
        }
        catch (Exception ex) {
            return true;
        }
    }

    private void visitVertice(Vertice v) throws Exception {
        if (v.getState() == Vertice.State.VISITING) {
            throw new Exception("loop");
        }
        v.setState(Vertice.State.VISITING);
        for (Vertice c : this.getChildren(v)) {
            if (c.getState() != Vertice.State.INITED) continue;
            this.visitVertice(c);
        }
        v.setState(Vertice.State.VISITED);
    }

    public List<Vertice> getChildren(Vertice v) {
        ArrayList<Vertice> l = new ArrayList<Vertice>();
        for (Edge e : this.graph.getEdges()) {
            if (e.getStart() == v && !l.contains(e.getEnd())) {
                l.add(e.getEnd());
            }
            if (e.getEnd() != v || l.contains(e.getStart())) continue;
            l.add(e.getStart());
        }
        return l;
    }

    public boolean hasLoop_Tarjan() {
        ArrayList<List<Vertice>> strongConnected = new ArrayList<List<Vertice>>();
        this.index = 0;
        Stack<Vertice> stack = new Stack<Vertice>();
        for (Vertice vertice : this.graph.getVertex()) {
            if (vertice.getIndex() != -1) continue;
            this.strongConnect(strongConnected, vertice, this.graph, stack);
        }
        for (List list : strongConnected) {
            if (list.size() <= 1) continue;
            return true;
        }
        return false;
    }

    private void strongConnect(List<List<Vertice>> strongConnected, Vertice v, Graph graph, Stack<Vertice> stack) {
        v.setIndex(this.index);
        v.setLowlink(this.index);
        ++this.index;
        stack.push(v);
        for (Edge e : graph.getEdges()) {
            if (e.getStart() != v) continue;
            if (e.getEnd().getIndex() == -1) {
                this.strongConnect(strongConnected, e.getEnd(), graph, stack);
                v.setLowlink(Math.min(v.getLowlink(), e.getEnd().getLowlink()));
                continue;
            }
            if (!stack.contains(e.getEnd())) continue;
            v.setLowlink(Math.min(v.getLowlink(), e.getEnd().getIndex()));
        }
        if (v.getLowlink() == v.getIndex() && v.getIndex() != -1) {
            ArrayList<Vertice> l = new ArrayList<Vertice>();
            Vertice w = null;
            do {
                if ((w = stack.pop()) == null) continue;
                l.add(w);
            } while (w != v);
            strongConnected.add(l);
        }
    }
}

