/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.custom.commands;

import com.indy.map.Constraint;
import com.indy.map.Datastore;
import com.indy.map.Expression;
import com.indy.map.Field;
import com.indy.map.Map;
import com.indy.map.MapFactory;
import com.indy.map.MapPackage;
import com.indy.map.SetDescriptor;
import com.indy.map.custom.commands.FieldUpdaterUtils;
import com.indy.map.custom.commands.MdNodeSynchronizer;
import com.indy.map.helpers.ExtraStaticFieldSorter;
import com.indy.map.impl.DatastoreImpl;
import com.indy.map.ref.RDatastore;
import com.indy.map.ref.RField;
import com.indy.map.util.IMapResource;
import com.indy.map.util.synchro.impl.listeners.DataSetUpdater;
import com.stambia.md.Configuration;
import com.stambia.md.MdNode;
import com.stambia.md.MdPackage;
import com.stambia.tech.Level;
import com.stambia.tech.MappingType;
import com.stambia.tech.XpathExpression;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

public class UpdateDatastoreCommand
extends RecordingCommand {
    private Datastore datastore;
    private boolean semanticModelUpdated = false;
    private boolean isDirty = false;
    public static String XPATH_GET_CONNECTION_REF = "ancestor-or-self::*[@tech:connection='true'][1]";
    public static String XPATH_GET_CONNECTION_ID = XPATH_GET_CONNECTION_REF + "/@id";

    public UpdateDatastoreCommand(TransactionalEditingDomain domain, Datastore datastore) {
        super(domain);
        this.datastore = datastore;
    }

    protected void doExecute() {
        MdNodeSynchronizer sync = new MdNodeSynchronizer(this.datastore);
        boolean synchronizeFields = this.datastore.isSynchronized();
        IMapResource resource = (IMapResource)this.datastore.eResource();
        boolean isSynchronizing = resource.getReferenceSynchronizer().isIniting();
        if (this.datastore.getRef() != null && this.datastore.getRef().eIsProxy()) {
            return;
        }
        MdNode mdNodeRef = (MdNode)this.datastore.getRef();
        if (mdNodeRef.getLevel() == null) {
            return;
        }
        boolean isUkDefined = false;
        ArrayList<Constraint> oldConstraint = new ArrayList<Constraint>();
        oldConstraint.addAll((Collection<Constraint>)this.datastore.getConstraint());
        this.datastore.getMapReference();
        HashMap<String, Field> unMappedOrInexistantField = new HashMap<String, Field>();
        if (synchronizeFields) {
            for (Field field : this.datastore.getField()) {
                if (!FieldUpdaterUtils.isMapped(field) && !this.isUsed(field)) {
                    unMappedOrInexistantField.put(((RField)field.getMapReference()).getFullName(), field);
                } else if (!EcoreUtil.isAncestor((EObject)mdNodeRef, (EObject)field.getRef())) {
                    unMappedOrInexistantField.put(((RField)field.getMapReference()).getFullName(), field);
                }
                if (!field.isUpdateKey()) continue;
                isUkDefined = true;
            }
        }
        ArrayList<MdNode> nodes = new ArrayList<MdNode>();
        if (FieldUpdaterUtils.addAsChildren(mdNodeRef)) {
            nodes.add(mdNodeRef);
        } else {
            HashSet<MdNode> constraints = new HashSet<MdNode>();
            UpdateDatastoreCommand.getMappingChildrenAndConstraints(synchronizeFields, mdNodeRef, nodes, constraints);
            nodes.addAll(constraints);
        }
        FieldUpdaterUtils.Position position = new FieldUpdaterUtils.Position();
        HashMap<EObject, Field> fields = new HashMap<EObject, Field>(this.datastore.getField().size());
        ArrayList<Field> noRefFields = new ArrayList<Field>();
        if (synchronizeFields) {
            for (Field f : this.datastore.getField()) {
                if (f.getRef() != null) {
                    fields.put(f.getRef(), f);
                    continue;
                }
                noRefFields.add(f);
            }
        }
        HashMap<Field, BigInteger> fieldPositions = new HashMap();
        for (Object tmp : nodes) {
            MdNode c = (MdNode)tmp;
            Level l = c.getLevel();
            if (synchronizeFields && FieldUpdaterUtils.addAsChildren(c)) {
                position.increment();
                ((RDatastore)this.datastore.getMapReference()).setHierarchical(false);
                this.addField(fieldPositions, this.datastore, c, null, position, fields, noRefFields, unMappedOrInexistantField, isUkDefined, true, nodes.size() == 1);
                continue;
            }
            if (l == null || !c.getMappingType().contains(MappingType.CONSTRAINT)) continue;
            Constraint constraint = null;
            for (Constraint _constraint : this.datastore.getConstraint()) {
                if (_constraint.getRef() != c) continue;
                constraint = _constraint;
                break;
            }
            if (constraint == null) {
                for (Constraint _constraint : this.datastore.getConstraint()) {
                    if (c.getName() == null || _constraint.getName() == null || !c.getName().equals(_constraint.getName())) continue;
                    constraint = _constraint;
                    constraint.setRef((EObject)c);
                    break;
                }
            }
            if (constraint == null) {
                constraint = MapFactory.eINSTANCE.createConstraint();
                this.datastore.getConstraint().add((Object)constraint);
                constraint.setName(c.getName());
                constraint.setReject(true);
                constraint.setRef((EObject)c);
                continue;
            }
            oldConstraint.remove(constraint);
            if (!(c.getName() != null && constraint.getName() != null && !c.getName().equals(constraint.getName()) || c.getName() == null && constraint.getName() != null) && (constraint.getName() != null || c.getName() == null)) continue;
            constraint.setName(c.getName());
        }
        if (!synchronizeFields) {
            sync.synchronize();
        }
        List<EObject> toRemove = null;
        Collection<Field> _fields = null;
        if (synchronizeFields) {
            toRemove = this.handleDeletionAndProxies(unMappedOrInexistantField.values());
            _fields = fields.values();
        } else {
            toRemove = this.handleDeletionAndProxies(sync.getFieldToDelete());
            fieldPositions = sync.getFieldPositions();
            _fields = sync.getAllDatastoreFields();
        }
        for (Constraint constraint : oldConstraint) {
            toRemove.add(constraint);
        }
        ((RDatastore)this.datastore.getMapReference()).setHierarchical(this.datastore.isHierarchical());
        if (((RDatastore)this.datastore.getMapReference()).isHierarchical()) {
            for (Field f : this.datastore.getField()) {
                if (f.getDepth() >= 1 || f.isExpand()) continue;
                f.setExpand(true);
            }
        }
        this.handleSynchronization(isSynchronizing, _fields, toRemove, fieldPositions);
        if (this.isDirty) {
            ((IMapResource)this.datastore.eResource()).setDirtyOnLoad();
        }
    }

    private static boolean addAsConstraint(MdNode mdNode2) {
        Level level = mdNode2.getLevel();
        if (level == null) {
            return false;
        }
        return level != null && mdNode2.getMappingType().contains(MappingType.CONSTRAINT);
    }

    private void addField(HashMap<Field, BigInteger> newFieldPositions, Datastore datastore, MdNode mdNode2, Field parentField, FieldUpdaterUtils.Position position, HashMap<EObject, Field> fields, List<Field> noRefFields, java.util.Map<String, Field> unMappedOrInexistantField, boolean isUkDefined, boolean isRoot, boolean isUnique) {
        try {
            if (position == null) {
                position = new FieldUpdaterUtils.Position();
            } else {
                position.increment();
            }
            ArrayList<Field> allFields = new ArrayList<Field>(fields.values());
            allFields.addAll(noRefFields);
            if (FieldUpdaterUtils.addAsChildren(mdNode2)) {
                Field _Field;
                Field field = fields.get(mdNode2);
                if (field == null) {
                    for (Field field2 : noRefFields) {
                        _Field = field2;
                        if (_Field.getRef() != mdNode2) continue;
                        field = _Field;
                        break;
                    }
                }
                if (field == null) {
                    for (Field field3 : allFields) {
                        _Field = field3;
                        if (_Field.getParent() != parentField && !FieldUpdaterUtils.compareName(_Field.getParent(), parentField) || (mdNode2.getName() == null || _Field.getName() == null || !mdNode2.getName().toUpperCase().equals(_Field.getName().toUpperCase()) && (!isRoot || !isUnique || _Field.getChildren().isEmpty() || _Field.getParent() != null)) && (mdNode2.getName() != null || mdNode2.getLevel() == null || mdNode2.getLevel().getDisplayName() == null || _Field.getName() == null || !mdNode2.getLevel().getDisplayName().toUpperCase().equals(_Field.getName().toUpperCase()))) continue;
                        if (mdNode2.getLevel() != null && _Field.getRef() instanceof MdNode) {
                            String defType = mdNode2.getLevel().getCode();
                            Level l = ((MdNode)_Field.getRef()).getLevel();
                            if (l != null && !l.getCode().equals(defType)) continue;
                        }
                        field = _Field;
                        field.setRef((EObject)mdNode2);
                        this.semanticModelUpdated = true;
                        this.detectIsDirty(field);
                        break;
                    }
                }
                if (field != null) {
                    position.increment();
                    newFieldPositions.put(field, BigInteger.valueOf(position.value));
                    RField rField = (RField)field.getMapReference();
                    if (rField != null) {
                        unMappedOrInexistantField.remove(rField.getFullName());
                    }
                    this.updateField(true, datastore, field, mdNode2, parentField, isUkDefined);
                } else {
                    position.increment();
                    field = this.updateField(true, datastore, field, mdNode2, parentField, isUkDefined);
                    if (field.getRef() != null) {
                        fields.put(field.getRef(), field);
                    } else {
                        noRefFields.add(field);
                    }
                    newFieldPositions.put(field, BigInteger.valueOf(position.value));
                }
                if (field.getParent() != null && field.eContainer() != null && !((DatastoreImpl)field.eContainer()).isHierarchical()) {
                    this.semanticModelUpdated = true;
                    ((DatastoreImpl)field.eContainer()).setHierarchical(true);
                }
                parentField = field;
            }
            ArrayList<MdNode> nodes = new ArrayList<MdNode>();
            UpdateDatastoreCommand.getMappingChildrenAndConstraints(datastore.isSynchronized(), mdNode2, nodes, null);
            for (Field field : nodes) {
                position.increment();
                this.addField(newFieldPositions, datastore, (MdNode)field, parentField, position, fields, noRefFields, unMappedOrInexistantField, isUkDefined, false, false);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }

    private void detectIsDirty(Field field) {
        if (!this.isDirty && field.eResource() != null) {
            boolean isDirty = false;
            Map mapModel = (Map)field.eContainer().eContainer();
            if (mapModel.getHint() != null && mapModel.getHint().getUsedField().contains((Object)field)) {
                isDirty = true;
            } else {
                for (Expression e : field.getExpression()) {
                    if (e.getExpression() == null || e.getExpression().isEmpty()) continue;
                    isDirty = true;
                    break;
                }
            }
            if (isDirty) {
                this.isDirty = true;
            }
        }
    }

    static void getMappingChildrenAndConstraints(boolean synchronizeFields, MdNode parent, Collection<MdNode> list, Collection<MdNode> constraints) {
        ArrayList<Object> nodes = new ArrayList<Object>();
        XpathExpression xPath = parent.getXPathExpression("INTERNAL_MAPPING_FIELDS_REF");
        if (xPath != null) {
            try {
                Object object = parent.evaluateMdSet(xPath.getExpression());
                if (object instanceof MdNode) {
                    nodes.add(object);
                } else if (object instanceof Collection) {
                    for (Object i : (Collection)object) {
                        if (!(i instanceof MdNode)) continue;
                        nodes.add(i);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (constraints != null) {
                for (MdNode mdNode : parent.getNode()) {
                    if (!UpdateDatastoreCommand.addAsConstraint(mdNode)) continue;
                    constraints.add(mdNode);
                }
            }
        } else {
            nodes.addAll((Collection<Object>)parent.getNode());
        }
        Collections.sort(nodes, Configuration.comparator);
        for (MdNode mdNode : nodes) {
            if (synchronizeFields && FieldUpdaterUtils.addAsChildren(mdNode)) {
                list.add(mdNode);
                continue;
            }
            if (constraints != null && UpdateDatastoreCommand.addAsConstraint(mdNode)) {
                constraints.add(mdNode);
                continue;
            }
            UpdateDatastoreCommand.getMappingChildrenAndConstraints(synchronizeFields, mdNode, list, constraints);
        }
    }

    private Field updateField(boolean synchronize, Datastore datastore, Field field, MdNode mdNode2, Field parentField, boolean isUkDefined) {
        boolean isNewField = false;
        if (synchronize && field == null) {
            field = MapFactory.eINSTANCE.createField();
            isNewField = true;
            String newName = null;
            try {
                newName = mdNode2.evaluateXpathExpressionCached("INTERNAL_MAPPING_OBJECT_NAME", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (newName == null && (newName = mdNode2.getName()) == null) {
                newName = mdNode2.getLevel().getDisplayName();
            }
            field.setName(newName);
            field.setRef((EObject)mdNode2);
            for (SetDescriptor s : datastore.getSetDescriptor()) {
                Expression exp = MapFactory.eINSTANCE.createExpression();
                exp.setSetDescriptorRef(s);
                field.getExpression().add((Object)exp);
            }
        } else if (field.getRef() != mdNode2) {
            field.setRef((EObject)mdNode2);
            this.semanticModelUpdated = true;
            this.detectIsDirty(field);
        }
        if (field != null && field.getParent() != parentField) {
            field.setParent(parentField);
            this.semanticModelUpdated = true;
            this.detectIsDirty(field);
        }
        if (isNewField || !isUkDefined && !field.eIsSet((EStructuralFeature)MapPackage.eINSTANCE.getField_UpdateKey())) {
            boolean isUpdateKey = false;
            try {
                String str = mdNode2.evaluateXpathExpressionCached("INTERNAL_USE_AS_KEY", null);
                isUpdateKey = str != null && str.equals("true");
            }
            catch (XPathExpressionException xPathExpressionException) {
                // empty catch block
            }
            if (isUpdateKey != field.isUpdateKey()) {
                field.setUpdateKey(isUpdateKey);
                this.semanticModelUpdated = true;
                this.detectIsDirty(field);
            }
        }
        return field;
    }

    private List<EObject> handleDeletionAndProxies(Collection<Field> fields) {
        ArrayList<EObject> toRemove = new ArrayList<EObject>();
        MdNode targetRef = (MdNode)this.datastore.getRef();
        for (Field field : fields) {
            boolean shouldResetProxy;
            if (field.isExtraStatic()) continue;
            if (!FieldUpdaterUtils.isMapped(field) && !this.isUsed(field)) {
                if (!FieldUpdaterUtils.mappedDescendant(field)) {
                    toRemove.add(field);
                    continue;
                }
                if (field.isExpand()) continue;
                field.setExpand(true);
                continue;
            }
            MdNode cur = field.getRef() == null || field.getRef().eIsProxy() ? null : (MdNode)field.getRef();
            while (cur != null && cur.eContainer() instanceof MdNode) {
                if (cur.getId().equals(targetRef.getId())) break;
                cur = (MdNode)cur.eContainer();
            }
            boolean bl = shouldResetProxy = field.getRef() != null && (cur == null || cur.eIsProxy() || !cur.getId().equals(targetRef.getId()));
            if (!shouldResetProxy || field.getRef().eIsProxy()) continue;
            URI uri = EcoreUtil.getURI((EObject)field.getRef());
            String fragment = uri.fragment();
            URI newURI = uri.trimFragment().appendFragment(((MdNode)field.getRef().eContainer()).getId() + "_MISS?" + fragment.substring(fragment.indexOf("?") + 1));
            EClass ec = MdPackage.eINSTANCE.getMdNode();
            InternalEObject proxy = (InternalEObject)ec.getEPackage().getEFactoryInstance().create(ec);
            proxy.eSetProxyURI(newURI);
            field.setRef((EObject)proxy);
        }
        return toRemove;
    }

    private void handleSynchronization(boolean isSynchronizing, Collection<Field> fields, Collection<EObject> toRemove, HashMap<Field, BigInteger> fieldPositions) {
        if (isSynchronizing) {
            IMapResource resource = (IMapResource)this.datastore.eResource();
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this.datastore);
            RDatastore ref = (RDatastore)this.datastore.getMapReference();
            ref.setCountShownFields(fields.size());
            for (Field f : fields) {
                if (!f.isInView()) {
                    ref.setCountShownFields(ref.getCountShownFields() - 1);
                }
                if (f.getParent() != null && !((DatastoreImpl)this.datastore).isHierarchical()) {
                    ((DatastoreImpl)this.datastore).setHierarchical(true);
                    this.semanticModelUpdated = true;
                }
                if (f.eContainer() == null) {
                    this.semanticModelUpdated = true;
                    resource.getReferenceSynchronizer().appendPostponedCommand((Command)new AddCommand((EditingDomain)domain, (EObject)this.datastore, (EStructuralFeature)MapPackage.eINSTANCE.getDatastore_Field(), (Object)f));
                    resource.getReferenceSynchronizer().appendPostponedCommand((Command)new FieldUpdaterUtils.SetFieldPositionCommand(f, fieldPositions.get(f)));
                    continue;
                }
                ((RField)f.getMapReference()).setPosition(fieldPositions.get(f));
            }
            for (EObject o : toRemove) {
                if (o instanceof Constraint) {
                    this.semanticModelUpdated = true;
                    resource.getReferenceSynchronizer().appendPostponedCommand((Command)new DataSetUpdater.SecureRemoveCommand(domain, this.datastore, (EStructuralFeature)MapPackage.eINSTANCE.getDatastore_Constraint(), o));
                    continue;
                }
                if (!(o instanceof Field)) continue;
                if (((Field)o).getParent() != null) {
                    resource.getReferenceSynchronizer().appendPostponedCommand((Command)new SetCommand((EditingDomain)domain, o, (EStructuralFeature)MapPackage.eINSTANCE.getField_Parent(), null));
                }
                resource.getReferenceSynchronizer().appendPostponedCommand((Command)new DataSetUpdater.SecureRemoveCommand(domain, this.datastore, (EStructuralFeature)MapPackage.eINSTANCE.getDatastore_Field(), o));
                this.semanticModelUpdated = true;
            }
            if (this.semanticModelUpdated) {
                resource.getReferenceSynchronizer().appendPostponedCommand((Command)new IdentityCommand());
            }
        } else {
            int countShownFields = 0;
            ArrayList<Field> addedFields = new ArrayList<Field>();
            for (Field f : fields) {
                BigInteger pos;
                countShownFields = f.isInView() ? ++countShownFields : --countShownFields;
                if (f.getParent() != null) {
                    ((DatastoreImpl)this.datastore).setHierarchical(true);
                }
                if (f.eContainer() == null) {
                    this.datastore.getField().add((Object)f);
                    addedFields.add(f);
                }
                if ((pos = fieldPositions.get(f)) == null) continue;
                ((RField)f.getMapReference()).setPosition(pos);
            }
            if (((Map)this.datastore.eContainer()).hasRefMapUpdated()) {
                for (EObject o : toRemove) {
                    if (o instanceof Constraint) {
                        this.datastore.getConstraint().remove((Object)o);
                    }
                    if (!(o instanceof Field)) continue;
                    if (((Field)o).getParent() != null) {
                        ((Field)o).getParent().getChildren().remove(o);
                        ((Field)o).setParent(null);
                    }
                    this.datastore.getField().remove((Object)o);
                    --countShownFields;
                }
            }
            ((RDatastore)this.datastore.getMapReference()).setCountShownFields(countShownFields);
            ExtraStaticFieldSorter sorter = new ExtraStaticFieldSorter(this.datastore);
            sorter.doSort();
        }
    }

    public boolean isUsed(Field srcField) {
        return FieldUpdaterUtils.isUsed(srcField);
    }
}

