/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.ensemblist.lexer;

import com.indy.map.IContainer;
import com.indy.map.SetDescriptor;
import com.indy.map.ensemblist.lexer.Token;
import com.indy.map.messages.Messages;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ContainerLexer {
    private WeakReference<IContainer> container;
    HashMap<String, Token> dictionaryTokens = new HashMap();

    public ContainerLexer(IContainer container) {
        this.container = new WeakReference<IContainer>(container);
        this.dictionaryTokens.put(Token.OPEN_PARENTHESIS.getValue(), Token.OPEN_PARENTHESIS);
        this.dictionaryTokens.put(Token.CLOSE_PARENTHESIS.getValue(), Token.CLOSE_PARENTHESIS);
        this.dictionaryTokens.put(Token.MINUS.getValue().toUpperCase(), Token.MINUS);
        this.dictionaryTokens.put(Token.UNION.getValue().toUpperCase(), Token.UNION);
        this.dictionaryTokens.put(Token.ALL.getValue().toUpperCase(), Token.ALL);
        this.dictionaryTokens.put(Token.INTERSECTION.getValue().toUpperCase(), Token.INTERSECTION);
        for (SetDescriptor c : container.getSetDescriptor()) {
            this.dictionaryTokens.put("[" + c.getLabel().toString().toUpperCase() + "]", new Token.Set(c));
        }
    }

    public List<Token> readToken() throws UnknownTokenException {
        IContainer container = (IContainer)this.container.get();
        if (container == null) {
            throw new RuntimeException(Messages.ContainerLexer_4);
        }
        String s = container.getSubExpression();
        ArrayList<Token> tokens = new ArrayList<Token>();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) {
                if (buf.length() > 0) {
                    word = buf.toString();
                    token = this.dictionaryTokens.get(word);
                    if (token == null && (token = this.dictionaryTokens.get(word.toUpperCase())) == null) {
                        throw new UnknownTokenException(word);
                    }
                    tokens.add(token);
                    buf = new StringBuffer();
                }
            } else {
                word = new String(new char[]{c});
                token = this.dictionaryTokens.get(word);
                if (token == Token.CLOSE_PARENTHESIS || token == Token.OPEN_PARENTHESIS) {
                    if (buf != null && buf.length() != 0) {
                        String prevWord = buf.toString();
                        Token prevToken = this.dictionaryTokens.get(prevWord);
                        if (prevToken == null) {
                            throw new UnknownTokenException(prevWord);
                        }
                        tokens.add(prevToken);
                    }
                    tokens.add(token);
                    buf = new StringBuffer();
                } else {
                    buf.append(c);
                }
            }
            ++i;
        }
        if (buf.length() > 0) {
            String word = buf.toString();
            Token token = this.dictionaryTokens.get(word.toUpperCase());
            if (token == null) {
                throw new UnknownTokenException(word);
            }
            tokens.add(token);
        }
        return tokens;
    }

    public static class UnknownTokenException
    extends Exception {
        public UnknownTokenException(String word) {
            super(Messages.bind((String)Messages.ContainerLexer_0, (Object)word));
        }
    }
}

