/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.ensemblist.lexer;

import com.indy.map.IContainer;
import com.indy.map.SetDescriptor;
import com.indy.map.ensemblist.lexer.ContainerLexer;
import com.indy.map.ensemblist.lexer.Token;
import com.indy.map.messages.Messages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;

public class SubExpressionParser {
    public SubExpression parse(IContainer container) throws Exception {
        ContainerLexer lexer = new ContainerLexer(container);
        Stack<SubExpression> stack = new Stack<SubExpression>();
        Stack<Token> operators = new Stack<Token>();
        List<Token> tokens = lexer.readToken();
        for (Token t : tokens) {
            if (t instanceof Token.Set) {
                stack.add(new SubExpression(t));
                continue;
            }
            if (t.isOperator()) {
                if (!operators.isEmpty() && ((Token)operators.peek()).isOperator()) {
                    SubExpression current = new SubExpression((Token)operators.pop());
                    current.addChildren((SubExpression)stack.pop());
                    current.addChildren((SubExpression)stack.pop());
                    stack.push(current);
                }
                operators.push(t);
                continue;
            }
            if (t == Token.OPEN_PARENTHESIS) {
                operators.push(t);
                continue;
            }
            if (t == Token.CLOSE_PARENTHESIS) {
                Token cur = null;
                while (!operators.isEmpty() && (cur = (Token)operators.pop()) != Token.OPEN_PARENTHESIS) {
                    SubExpression n = new SubExpression(cur);
                    n.addChildren((SubExpression)stack.pop());
                    n.addChildren((SubExpression)stack.pop());
                    stack.push(n);
                }
                if (cur == Token.OPEN_PARENTHESIS) continue;
                throw new Exception(Messages.SubExpressionParser_12);
            }
            if (t != Token.ALL || operators.peek() != Token.UNION) continue;
            ((SubExpression)stack.peek()).replaceToken(Token.UNION_ALL);
        }
        while (!operators.isEmpty()) {
            Token t;
            t = (Token)operators.pop();
            if (t != Token.CLOSE_PARENTHESIS && t != Token.OPEN_PARENTHESIS) {
                SubExpression n = new SubExpression(t);
                n.addChildren((SubExpression)stack.pop());
                n.addChildren((SubExpression)stack.pop());
                stack.push(n);
                continue;
            }
            throw new Exception(Messages.SubExpressionParser_13);
        }
        if (stack.isEmpty()) {
            return null;
        }
        if (stack.size() > 1) {
            throw new Exception(Messages.SubExpressionParser_14);
        }
        return (SubExpression)stack.pop();
    }

    public class SubExpression {
        private SubExpression parent;
        private List<SubExpression> children = new ArrayList<SubExpression>();
        private Token token;

        public SubExpression(Token token) {
            this.token = token;
        }

        public Token getToken() {
            return this.token;
        }

        public void addChildren(SubExpression n) {
            n.parent = this;
            this.children.add(n);
        }

        public List<SubExpression> getChildren() {
            return new ArrayList<SubExpression>(this.children);
        }

        private List<SubExpression> findAllSet() {
            if (this.token instanceof Token.Set) {
                return Collections.singletonList(this);
            }
            ArrayList<SubExpression> l = new ArrayList<SubExpression>();
            for (SubExpression n : this.getChildren()) {
                l.addAll(n.findAllSet());
            }
            return l;
        }

        private List<SubExpression> findNodes(SetDescriptor sd) {
            ArrayList<SubExpression> l = new ArrayList<SubExpression>();
            if (this.token instanceof Token.Set && ((Token.Set)this.token).getSetDescriptor() == sd) {
                return Collections.singletonList(this);
            }
            for (SubExpression n : this.getChildren()) {
                l.addAll(n.findNodes(sd));
            }
            return l;
        }

        public void removeSetDescripor(SetDescriptor sd) {
            for (SubExpression n : this.findNodes(sd)) {
                if (n.parent == null) {
                    throw new NullPointerException();
                }
                if (n.parent.parent != null) {
                    n.parent.children.remove(n);
                    n.parent.parent.children.remove(n.parent);
                    for (SubExpression c : n.parent.children) {
                        n.parent.parent.addChildren(c);
                    }
                    continue;
                }
                List<SubExpression> oldChildren = n.parent.getChildren();
                for (SubExpression c : oldChildren) {
                    for (SubExpression f : c.getChildren()) {
                        this.addChildren(f);
                    }
                }
                if (this.children.size() == oldChildren.size()) {
                    this.children.removeAll(oldChildren);
                    for (SubExpression c : oldChildren) {
                        if (!(c.getToken() instanceof Token.Set) || ((Token.Set)c.getToken()).getSetDescriptor() == sd) continue;
                        this.token = c.getToken();
                    }
                    continue;
                }
                this.children.removeAll(oldChildren);
            }
        }

        public String generateInfixExpression() {
            if (this.getChildren().isEmpty()) {
                return this.getToken().getValue();
            }
            StringBuffer buf = new StringBuffer();
            buf.append("(");
            buf.append(this.getChildren().get(0).generateInfixExpression());
            buf.append(" ");
            buf.append(this.getToken().getValue());
            buf.append(" ");
            buf.append(this.getChildren().get(1).generateInfixExpression());
            buf.append(" ");
            buf.append(")");
            return buf.toString();
        }

        public boolean missSetDescriptor(IContainer container) {
            for (SetDescriptor d : container.getSetDescriptor()) {
                if (!this.findNodes(d).isEmpty()) continue;
                return true;
            }
            return false;
        }

        public void synchronizeSetDescriptor(IContainer dataModel) throws NullPointerException {
            for (SubExpression e : this.findAllSet()) {
                SetDescriptor d = ((Token.Set)e.getToken()).getSetDescriptor();
                if (d != null && dataModel.getSetDescriptor().contains((Object)d)) continue;
                this.removeSetDescripor(d);
            }
        }

        public String generateInfixExpression4Ref() {
            if (this.getChildren().isEmpty()) {
                if (this.getToken() instanceof Token.Set) {
                    return "[" + this.getToken().getValue() + "]";
                }
                return this.getToken().getValue();
            }
            StringBuffer buf = new StringBuffer();
            buf.append("(");
            buf.append(this.getChildren().get(0).generateInfixExpression4Ref());
            buf.append(" ");
            buf.append(this.getToken().getValue());
            buf.append(" ");
            buf.append(this.getChildren().get(1).generateInfixExpression4Ref());
            buf.append(" ");
            buf.append(")");
            return buf.toString();
        }

        public void replaceToken(Token newToken) {
            if (this.token == Token.UNION && newToken == Token.UNION_ALL) {
                this.token = newToken;
            }
        }
    }
}

