/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.helpers.command.builder;

import com.indy.map.DataSet;
import com.indy.map.IContainer;
import com.indy.map.Join;
import com.indy.map.compute.graph.Graph;
import com.indy.map.compute.graph.Vertice;
import com.indy.map.helpers.command.builder.CommandFlipInheritancy;
import com.indy.map.helpers.command.builder.CommandMergeInheritedDataSet;
import com.indy.map.helpers.command.builder.CommandRemoveContainerFromDataSet;
import com.semarchy.xdi.designer.core.collections.BidiMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

public enum ConditionalJoinCommandBuilder {
    INSTANCE;


    private List<IContainer> computeDisjonctions(Graph g, Vertice startPoint, BidiMap<Vertice, IContainer> verticeMap) {
        ArrayDeque<Vertice> stack = new ArrayDeque<Vertice>();
        stack.push(startPoint);
        while (!stack.isEmpty()) {
            Vertice v = (Vertice)stack.pop();
            if (v.getState() == Vertice.State.VISITED) continue;
            v.setState(Vertice.State.VISITED);
            g.getAdjacentEdges(v).stream().map(e -> e.getEnd() == v ? e.getStart() : e.getEnd()).forEach(stack::push);
        }
        ArrayList<IContainer> reached = new ArrayList<IContainer>();
        ArrayList<IContainer> nonVisited = new ArrayList<IContainer>();
        for (Vertice v : g.getVertex()) {
            if (v.getState() == Vertice.State.VISITED) {
                reached.add((IContainer)verticeMap.getTo((Object)v));
                continue;
            }
            nonVisited.add((IContainer)verticeMap.getTo((Object)v));
        }
        if (nonVisited.isEmpty()) {
            return Collections.emptyList();
        }
        reached.remove(verticeMap.getTo((Object)startPoint));
        return reached;
    }

    private void createEdge(Graph g, Vertice b, Vertice e) {
        if (b != null && e != null) {
            g.createEdge(b, e);
        }
    }

    public Command makeInheritanceJoinCommand(Join join, boolean leftToRight) {
        IContainer container = leftToRight ? join.getLeft() : join.getRight();
        ArrayList<IContainer> toRemove = new ArrayList<IContainer>();
        DataSet formerDataset = container.getDataset();
        toRemove.add(container);
        Graph g = new Graph();
        BidiMap vertexMap = new BidiMap();
        vertexMap.put((Object)g.createVertice(toRemove.get(0)), toRemove.get(0));
        for (Join j : formerDataset.getJoin()) {
            j.getInvolvedContainers().stream().filter(c -> c.getDataset() == formerDataset).forEach(c -> {
                Object object = vertexMap.put((Object)g.createVertice(c), c);
            });
            if (j == join) continue;
            List l = j.getInvolvedContainers();
            for (IContainer c3 : l) {
                l.stream().filter(c2 -> !(c3 == c2 || c3 == j.getLeft() && c2 == j.getRight() || c2 == j.getLeft() && c3 == j.getRight())).forEach(c2 -> this.createEdge(g, (Vertice)vertexMap.getFrom((Object)c3), (Vertice)vertexMap.getFrom(c2)));
            }
            this.createEdge(g, (Vertice)vertexMap.getFrom((Object)j.getLeft()), (Vertice)vertexMap.getFrom((Object)j.getRight()));
        }
        toRemove.addAll(this.computeDisjonctions(g, (Vertice)vertexMap.getFrom(toRemove.get(0)), (BidiMap<Vertice, IContainer>)vertexMap));
        if (toRemove.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        TransactionalEditingDomain editDomain = TransactionUtil.getEditingDomain((EObject)formerDataset);
        if (editDomain != null) {
            return new CommandRemoveContainerFromDataSet(formerDataset, toRemove);
        }
        return UnexecutableCommand.INSTANCE;
    }

    public Command makeMergeJoinDatasetCommand(Join join) {
        DataSet toDestroy = null;
        DataSet toUpdate = null;
        if (join.getRight().getDataset() == join.getLeft().getDataset()) {
            return UnexecutableCommand.INSTANCE;
        }
        if (join.getRight().getDataset().getParent().contains((Object)join.getLeft().getDataset())) {
            toDestroy = join.getLeft().getDataset();
            toUpdate = join.getRight().getDataset();
        } else if (join.getLeft().getDataset().getParent().contains((Object)join.getRight().getDataset())) {
            toDestroy = join.getRight().getDataset();
            toUpdate = join.getLeft().getDataset();
        } else {
            return UnexecutableCommand.INSTANCE;
        }
        TransactionalEditingDomain editDomain = TransactionUtil.getEditingDomain((EObject)join);
        if (editDomain != null) {
            return new CommandMergeInheritedDataSet(toDestroy, toUpdate);
        }
        return UnexecutableCommand.INSTANCE;
    }

    public Command makeFlipInheritancy(Join join) {
        DataSet right;
        DataSet left = join.getLeft().getDataset();
        if (left == (right = join.getRight().getDataset())) {
            return UnexecutableCommand.INSTANCE;
        }
        DataSet parent = null;
        DataSet child = null;
        if (left.getParent().contains((Object)right)) {
            parent = right;
            child = left;
        } else if (right.getParent().contains((Object)left)) {
            parent = left;
            child = right;
        } else {
            return UnexecutableCommand.INSTANCE;
        }
        return new CommandFlipInheritancy(parent, child);
    }
}

