/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.util;

import com.indy.map.DataSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class InheritanceHelper {
    public static boolean haveSharedAncestor(DataSet ds1, DataSet ds2) {
        List<DataSet> l2;
        if (ds1 == ds2) {
            return false;
        }
        List<DataSet> l1 = InheritanceHelper.getDataSetHierarchy(ds1);
        return !Collections.disjoint(l1, l2 = InheritanceHelper.getDataSetHierarchy(ds2));
    }

    public static List<DataSet> getDataSetHierarchy(DataSet ds) {
        if (ds == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<DataSet> l = new ArrayList<DataSet>();
        l.add(ds);
        for (DataSet p : ds.getParent()) {
            if (p.getContainer().isEmpty()) continue;
            for (DataSet d : InheritanceHelper.getDataSetHierarchy(p)) {
                if (l.contains(d)) continue;
                l.add(d);
            }
        }
        return l;
    }

    public static List<DataSet> getDataSetLegacy(DataSet ds) {
        if (ds == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<DataSet> l = new ArrayList<DataSet>();
        l.add(ds);
        for (DataSet p : ds.getChild()) {
            for (DataSet d : InheritanceHelper.getDataSetLegacy(p)) {
                if (l.contains(d)) continue;
                l.add(d);
            }
        }
        return l;
    }
}

