/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.util.synchro.updaters.impl;

import com.indy.map.Datastore;
import com.indy.map.Field;
import com.indy.map.ISerde;
import com.indy.map.MapPackage;
import com.indy.map.ref.RDatastore;
import com.indy.map.ref.RField;
import com.indy.map.util.synchro.IRefItemUpdater;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class FieldUpdater
implements IRefItemUpdater<RField> {
    private static final String DEFAULT_MASK = "[OBJECT]";

    @Override
    public void updateAll(RField refItem) {
        this.update(refItem, (EStructuralFeature)MapPackage.eINSTANCE.getField_Ref());
        this.update(refItem, (EStructuralFeature)MapPackage.eINSTANCE.getField_Name());
    }

    @Override
    public void update(RField refItem, EStructuralFeature feature) {
        if (MapPackage.eINSTANCE.getField_Ref().equals(feature)) {
            EObject o = ((Field)refItem.getDataModel()).basicGetRef();
            if (o != null) {
                this.updateMandatory(refItem);
                this.updateType(refItem);
                this.updatePrecision(refItem);
                this.updateSize(refItem);
            }
        } else if (MapPackage.eINSTANCE.getField_InView().equals(feature)) {
            this.updateFieldInView(refItem);
        }
    }

    private void updateFieldInView(RField refItem) {
        RDatastore ref;
        Field field = (Field)refItem.getDataModel();
        EObject c = field.eContainer();
        if (c instanceof Datastore && (ref = (RDatastore)((Datastore)c).getMapReference()) != null) {
            int count = ref.getCountShownFields();
            count = field.isInView() ? ++count : --count;
            ref.setCountShownFields(count);
        }
    }

    public static String getFullAlias(Field field, boolean applyDelimiterRule) {
        String objectMask = null;
        EObject o = field.basicGetRef();
        if (o == null) {
            return null;
        }
        objectMask = field.getAPI().getMdEvaluator().evaluateObjectMask(field);
        if (objectMask == null) {
            objectMask = DEFAULT_MASK;
        }
        String name = field.getName();
        StringBuilder buf = new StringBuilder(objectMask.replace(DEFAULT_MASK, name));
        String delimterMask = null;
        String delimiterRule = null;
        if (field.eContainer() instanceof Datastore) {
            delimterMask = ((Datastore)field.eContainer()).getDelimiterMask();
            delimiterRule = ((Datastore)field.eContainer()).getDelimiterRule();
        } else if (field.eContainer() instanceof ISerde) {
            delimterMask = ((ISerde)field.eContainer()).getFieldDelimiterMask();
            delimiterRule = ((ISerde)field.eContainer()).getFieldDelimiterRule();
        }
        Field parent = field.getParent();
        while (parent != null) {
            if (parent.getParent() == null && parent.basicGetRef() != null && !parent.getAPI().getMdEvaluator().supportSourceMapping(parent)) break;
            objectMask = parent.getAPI().getMdEvaluator().evaluateObjectMask(parent);
            if (objectMask == null) {
                objectMask = DEFAULT_MASK;
            }
            buf.insert(0, objectMask.replace(DEFAULT_MASK, parent.getName()) + "/");
            parent = parent.getParent();
        }
        Object fullAlias = buf.toString();
        if (delimiterRule != null && delimterMask != null && applyDelimiterRule) {
            Pattern pattern = Pattern.compile(delimiterRule);
            Matcher matcher = pattern.matcher((CharSequence)fullAlias);
            if (delimterMask != null && matcher.find()) {
                fullAlias = "\"" + (String)fullAlias + "\"";
            }
        }
        return fullAlias;
    }

    public static String getFullAlias(Field field) {
        return FieldUpdater.getFullAlias(field, true);
    }

    private void updateType(RField refItem) {
        String val;
        String newValue = val = refItem.getDataModel().getAPI().getMdEvaluator().evaluateDataType((Field)refItem.getDataModel());
        String oldValue = refItem.getType();
        if (newValue != null && oldValue != null) {
            if (!newValue.equals(oldValue)) {
                refItem.setType(newValue);
            }
        } else if (oldValue != null) {
            refItem.setType(null);
        } else if (newValue != null) {
            refItem.setType(newValue);
        }
    }

    private void updatePrecision(RField refItem) {
        String val;
        String newValue = val = refItem.getDataModel().getAPI().getMdEvaluator().evaluatePrecision((Field)refItem.getDataModel());
        String oldValue = refItem.getPrecision();
        if (newValue != null && oldValue != null) {
            if (!newValue.equals(oldValue)) {
                refItem.setPrecision(newValue);
            }
        } else if (oldValue != null) {
            refItem.setPrecision(null);
        } else if (newValue != null) {
            refItem.setPrecision(newValue);
        }
    }

    private void updateSize(RField refItem) {
        String val;
        String newValue = val = refItem.getDataModel().getAPI().getMdEvaluator().evaluateSize((Field)refItem.getDataModel());
        String oldValue = refItem.getSize();
        if (newValue != null && oldValue != null) {
            if (!newValue.equals(oldValue)) {
                refItem.setSize(newValue);
            }
        } else if (oldValue != null) {
            refItem.setSize(null);
        } else if (newValue != null) {
            refItem.setSize(newValue);
        }
    }

    private void updateMandatory(RField refItem) {
        boolean isMandatory;
        String val = refItem.getDataModel().getAPI().getMdEvaluator().evaluateMandatory((Field)refItem.getDataModel());
        boolean bl = isMandatory = val == null || val.equals("0") || val.equals("false");
        if (isMandatory != refItem.isMandatory()) {
            refItem.setMandatory(isMandatory);
        }
    }

    @Override
    public Command updateAndDomainCommand(RField refItem, EStructuralFeature feature) {
        return null;
    }
}

