/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.util.synchro.updaters.impl;

import com.indy.gmf.proc.ActionProcess;
import com.indy.map.AdditionalProperty;
import com.indy.map.Clause;
import com.indy.map.Datastore;
import com.indy.map.Field;
import com.indy.map.IContainer;
import com.indy.map.ISerde;
import com.indy.map.ItemProperty;
import com.indy.map.Map;
import com.indy.map.MapFactory;
import com.indy.map.MapModelItem;
import com.indy.map.MapPackage;
import com.indy.map.Parameter;
import com.indy.map.Template;
import com.indy.map.compute.Computer;
import com.indy.map.custom.commands.UpdateDatastoreCommand;
import com.indy.map.custom.commands.UpdateSerdeFieldsCommand;
import com.indy.map.extension.ModelExtensionHelper;
import com.indy.map.ref.RMap;
import com.indy.map.ref.RTemplate;
import com.indy.map.ref.RUDFRef;
import com.indy.map.util.IMapResource;
import com.indy.map.util.synchro.IRefItemUpdater;
import com.indy.map.util.synchro.IRefUpdaterProvider;
import com.indy.map.util.synchro.impl.MapReferencesSynchronizerImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

public class MapUpdater
implements IRefItemUpdater<RMap> {
    @Override
    public void updateAll(RMap refItem) throws Exception {
        Map map = (Map)refItem.getDataModel();
        map.setRefMapUpdated(false);
        IMapResource resource = (IMapResource)map.eResource();
        if (resource == null || !resource.isLoaded() || resource.isLoading() || resource.getReferenceSynchronizer().isIniting()) {
            return;
        }
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)map);
        CompoundCommand cc = new CompoundCommand();
        for (Datastore d2 : map.getDatastore()) {
            cc.append((Command)new UpdateDatastoreCommand(editingDomain, d2){

                @Override
                public boolean isUsed(Field srcField) {
                    return true;
                }
            });
        }
        Stream<ISerde> allSerde = Stream.concat(map.getOutliner().stream(), map.getInliner().stream());
        allSerde.forEach(d -> cc.append((Command)new UpdateSerdeFieldsCommand(editingDomain, (ISerde)d){

            @Override
            protected boolean isUsed(Field field) {
                return true;
            }
        }));
        for (Template t : map.getTemplate()) {
            ArrayList toCreate = new ArrayList();
            if (t.getProcess() instanceof ActionProcess && !t.getProcess().eIsProxy()) {
                for (com.indy.gmf.proc.Parameter p : ((ActionProcess)t.getProcess()).getParameter()) {
                    Parameter mapP;
                    if (!p.isDefaultValueForced() || (mapP = t.getParameter(p.getName())) != null) continue;
                    mapP = MapFactory.eINSTANCE.createParameter();
                    mapP.setName(p.getName());
                    mapP.setValue(p.getValue());
                    toCreate.add(mapP);
                }
            }
            if (toCreate.isEmpty()) continue;
            cc.append((Command)new AddCommand((EditingDomain)TransactionUtil.getEditingDomain((EObject)map), (EObject)t, (EStructuralFeature)MapPackage.eINSTANCE.getTemplate_Parameter(), (Collection)toCreate));
        }
        Stream<Clause> clauseStream = Stream.concat(map.getJoin().stream(), map.getFilter().stream());
        clauseStream.forEach(c -> {
            Object object = c.getMapReference();
        });
        if (resource.autoUpgradeModel() && !cc.isEmpty()) {
            ((MapReferencesSynchronizerImpl)resource.getReferenceSynchronizer()).disableListeners(editingDomain);
            editingDomain.getCommandStack().execute((Command)cc);
            ((MapReferencesSynchronizerImpl)resource.getReferenceSynchronizer()).enableListeners(editingDomain);
        }
        Computer.INSTANCE.compute(map);
        for (Template t : new ArrayList<Template>((Collection<Template>)map.getTemplate())) {
            RTemplate ref = (RTemplate)t.getMapReference();
            IRefItemUpdater<RTemplate> updater = IRefUpdaterProvider.INSTANCE.getUpdater(ref);
            if (updater == null) continue;
            updater.updateAll(ref);
        }
        map.setRefMapUpdated(true);
        if (resource.autoUpgradeModel()) {
            CompoundCommand localCc = new CompoundCommand();
            for (IContainer d3 : map.getDatastore()) {
                localCc.append((Command)new UpdateDatastoreCommand(editingDomain, (Datastore)d3));
            }
            for (IContainer d3 : map.getOutliner()) {
                localCc.append((Command)new UpdateSerdeFieldsCommand(editingDomain, (ISerde)d3));
            }
            ((MapReferencesSynchronizerImpl)resource.getReferenceSynchronizer()).disableListeners(editingDomain);
            editingDomain.getCommandStack().execute((Command)localCc);
            ((MapReferencesSynchronizerImpl)resource.getReferenceSynchronizer()).enableListeners(editingDomain);
        }
        this.deleteUselessUDFRef(map, (EditingDomain)editingDomain);
    }

    private void deleteUselessUDFRef(Map map, EditingDomain editingDomain) {
        List toRemove;
        CompoundCommand cc = new CompoundCommand();
        for (IContainer c : map.getContainer()) {
            c.getProperty().stream().map(p -> this.checkCreatedProperty(editingDomain, (ItemProperty)p)).filter(Objects::nonNull).forEach(arg_0 -> ((CompoundCommand)cc).append(arg_0));
            c.getAllLogicalField().stream().flatMap(f -> ((MapModelItem)((Object)f)).getProperty().stream()).map(p -> this.checkCreatedProperty(editingDomain, (ItemProperty)p)).filter(Objects::nonNull).forEach(arg_0 -> ((CompoundCommand)cc).append(arg_0));
        }
        Command cmd = ModelExtensionHelper.INSTANCE.createRebuildItemPropertiesFromTemplateProcessCommand(map);
        if (cmd != null) {
            cc.append(cmd);
        }
        if (!(toRemove = map.getUdfRef().stream().filter(r -> ((RUDFRef)r.getMapReference()).getUsage().isEmpty()).collect(Collectors.toList())).isEmpty()) {
            cc.append((Command)new RemoveCommand(editingDomain, (EObject)map, (EStructuralFeature)MapPackage.eINSTANCE.getMap_UdfRef(), toRemove));
        }
        editingDomain.getCommandStack().execute((Command)cc);
    }

    private Command checkCreatedProperty(EditingDomain domain, ItemProperty p) {
        if (p.getDescriptor() == null) {
            for (AdditionalProperty ap : p.getAdditionalProperty("template-mapping-extension")) {
                if (!ap.getName().equals("createProperty")) continue;
                return new RemoveCommand(domain, p.eContainer(), (EStructuralFeature)MapPackage.eINSTANCE.getMapModelItem_Property(), (Object)p);
            }
        }
        return null;
    }

    @Override
    public void update(RMap refItem, EStructuralFeature feature) throws Exception {
    }

    @Override
    public Command updateAndDomainCommand(RMap refItem, EStructuralFeature feature) {
        return null;
    }
}

