/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.util.synchro.updaters.impl;

import com.indy.map.ISerde;
import com.indy.map.MapModelItem;
import com.indy.map.custom.commands.UpdateSerdeFieldsCommand;
import com.indy.map.ref.RContainer;
import com.indy.map.util.IMapResource;
import com.indy.map.util.synchro.updaters.impl.ContainerUpdater;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

public class SerdeUpdater
extends ContainerUpdater {
    private Logger logger = LogManager.getLogger(SerdeUpdater.class);

    @Override
    public void updateAll(RContainer refItem) throws Exception {
        super.updateAll(refItem);
        MapModelItem mapModelItem = refItem.getDataModel();
        if (mapModelItem instanceof ISerde) {
            ISerde serde = (ISerde)mapModelItem;
            this.updateRef(serde);
        }
    }

    private void updateRef(ISerde dataModel) {
        if (!((IMapResource)dataModel.eResource()).autoUpgradeModel()) {
            return;
        }
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)dataModel);
        if (domain != null && ((IMapResource)dataModel.eResource()).autoUpgradeModel()) {
            UpdateSerdeFieldsCommand cmd = new UpdateSerdeFieldsCommand(domain, dataModel);
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("unprotected", Boolean.TRUE);
            options.put("no_triggers", Boolean.TRUE);
            options.put("no_undo", Boolean.TRUE);
            try {
                ((TransactionalCommandStack)domain.getCommandStack()).execute((Command)cmd, options);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.logger.error("unexpected", (Throwable)e);
            }
            catch (RollbackException e) {
                this.logger.error("unexpected", (Throwable)e);
            }
        }
    }
}

