/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.util.upgrade;

import com.semarchy.xdi.designer.core.models.EMFResourceOptions;
import com.semarchy.xdi.designer.core.models.InternalResourceURIConverter;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IModelUpgrader;
import com.semarchy.xdi.designer.core.services.XDIModelURIResolver;
import com.semarchy.xdi.designer.core.utils.URIUtils;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.DrawerStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={IModelUpgrader.class}, property={"type=map"})
public class MappingUpgrader
implements IModelUpgrader {
    private static final List<String> HIDDEN_DIAGRAM_VIEW = Collections.unmodifiableList(Arrays.asList("7002", "5008", "7007", "7004", "5009"));
    private static final HashMap<String, Object> saveOptions = new HashMap();
    private ICacheService cacheService;
    private Logger logger = LogManager.getLogger(MappingUpgrader.class);
    @Reference
    private XDIModelURIResolver uriResolver;

    static {
        saveOptions.put("ENCODING", "UTF-8");
        saveOptions.put("SAVE_ONLY_IF_CHANGED", null);
    }

    public void upgradeModels(Collection<URI> mappingModels, Map<Object, Object> upgradeInformations, PrintWriter out, boolean trace) throws Exception {
        TransactionalEditingDomain editingDomain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain();
        ResourceSet rs = editingDomain.getResourceSet();
        rs.setURIConverter((URIConverter)new InternalResourceURIConverter());
        rs.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        rs.getLoadOptions().put(EMFResourceOptions.LOAD_OPTION_NO_BATCH_VALIDATION, Boolean.TRUE);
        rs.getLoadOptions().put("com.indy.gmf.map.LOAD_OPTION_FAIL_ON_CURRENT_INTERNAL_VERSION", Boolean.TRUE);
        StringBuilder b = new StringBuilder();
        for (URI r : mappingModels) {
            try {
                this.forceSave(r, editingDomain, out, trace);
            }
            catch (Exception ex) {
                b.append("Failed to upgrade " + String.valueOf(r.trimSegments(1)) + "because of : " + ex.getMessage() + "\n");
            }
        }
        if (b.length() > 0) {
            throw new Exception("Some mapping could not be upgraded:\n" + b.toString());
        }
    }

    @Reference(policy=ReferencePolicy.DYNAMIC)
    public void bind(ICacheService s) {
        this.cacheService = s;
    }

    public void unbind(ICacheService s) {
        this.cacheService = null;
    }

    private void upgradeDiagram(URI mappingURI, TransactionalEditingDomain editingDomain) {
        URI diagramURI = null;
        try {
            diagramURI = URIUtils.getDiagramURI((URI)mappingURI);
            if (!this.uriResolver.exists(diagramURI)) {
                return;
            }
            Resource diagram = editingDomain.getResourceSet().getResource(diagramURI, true);
            TreeIterator it = diagram.getAllContents();
            Set collapsed = StreamSupport.stream(((Iterable)() -> it).spliterator(), false).filter(o -> o instanceof DrawerStyle && ((DrawerStyle)o).isCollapsed()).map(EObject::eContainer).collect(Collectors.toSet());
            CompoundCommand cc = new CompoundCommand();
            for (EObject o2 : collapsed) {
                o2.eContents().forEach(v -> {
                    View view;
                    DrawerStyle ds;
                    if (v instanceof DrawerStyle && (ds = (DrawerStyle)v).isCollapsed()) {
                        cc.append((Command)new SetCommand((EditingDomain)editingDomain, (EObject)ds, (EStructuralFeature)NotationPackage.eINSTANCE.getDrawerStyle_Collapsed(), (Object)false));
                    }
                    if (v instanceof View && HIDDEN_DIAGRAM_VIEW.contains((view = (View)v).getType())) {
                        cc.append((Command)new SetCommand((EditingDomain)editingDomain, v, (EStructuralFeature)NotationPackage.eINSTANCE.getView_Visible(), (Object)false));
                    }
                });
            }
            editingDomain.getCommandStack().execute((Command)cc);
        }
        catch (Exception ex) {
            this.logger.error("Failed to upgrade MappingDiagram {}", (Object)(diagramURI == null ? mappingURI.toPlatformString(true) : diagramURI.toPlatformString(true)), (Object)ex);
        }
    }

    /*
     * Exception decompiling
     */
    private void forceSave(URI uri, TransactionalEditingDomain editingDomain, PrintWriter out, boolean trace) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[DOLOOP]], but top level block is 11[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void trace(boolean trace, PrintWriter out, String string) {
        if (trace && out != null) {
            out.println(string);
        }
    }
}

