/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.validation;

import com.indy.map.Clause;
import com.indy.map.DataSet;
import com.indy.map.Datastore;
import com.indy.map.Field;
import com.indy.map.Filter;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.Join;
import com.indy.map.JoinLocation;
import com.indy.map.Map;
import com.indy.map.MapModelItem;
import com.indy.map.QueryField;
import com.indy.map.TargetFilter;
import com.indy.map.Template;
import com.indy.map.Variable;
import com.indy.map.api.IMetaDataInformationsProvider;
import com.indy.map.ref.RClause;
import com.indy.map.ref.RLoadSet;
import com.indy.map.ref.RMap;
import com.indy.map.ref.RProblem;
import com.indy.map.ref.RSourceItem;
import com.indy.map.ref.RSourceSet;
import com.indy.map.ref.RTemplate;
import com.indy.map.ref.RVariable;
import com.indy.map.ref.RefFactory;
import com.indy.map.util.ClauseHelper;
import com.indy.map.validation.ProblemValidationStatus;
import com.indy.map.validation.UsageConstraint;
import com.indy.map.validation.parsers.ExpressionParserHelper;
import com.semarchy.xdi.designer.core.IExpressionParser;
import com.stambia.md.MdNode;
import com.stambia.tech.Level;
import com.stambia.tech.MappingType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.validation.IValidationContext;

public class ClauseConstraint
extends UsageConstraint {
    protected Collection<ProblemValidationStatus.ProblemEntry> checkLocationErrors(Clause clause) {
        ArrayList<ProblemValidationStatus.ProblemEntry> l = new ArrayList<ProblemValidationStatus.ProblemEntry>();
        for (QName errCode : this.getLocationErrorCodes(clause)) {
            l.add(new ProblemValidationStatus.ProblemEntry(errCode, null));
        }
        return l;
    }

    @Override
    public IStatus validate(IValidationContext ctx) {
        try {
            EObject eObj = ctx.getTarget();
            IStatus s = super.validate(ctx);
            if (eObj instanceof Clause || eObj instanceof RClause) {
                String parserURL;
                EObject connection;
                Clause clause = eObj instanceof RClause ? (Clause)((RClause)eObj).getDataModel() : (Clause)eObj;
                HashSet<ProblemValidationStatus.ProblemEntry> l = new HashSet<ProblemValidationStatus.ProblemEntry>();
                l.addAll(this.checkLocationErrors(clause));
                if (clause instanceof Filter) {
                    DataSet ds = null;
                    if (clause.getInvolvedContainers().size() > 1) {
                        for (IContainer c : clause.getInvolvedContainers()) {
                            if (ds == null) {
                                ds = c.getDataset();
                                continue;
                            }
                            if (ds == c.getDataset()) continue;
                            l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_FILTER_MULTIPLE_DATASET, null));
                            break;
                        }
                    } else if (!clause.getInvolvedContainers().isEmpty()) {
                        ds = ((IContainer)clause.getInvolvedContainers().get(0)).getDataset();
                    }
                    if (ds != null && !ds.getFiltering().isEmpty()) {
                        l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_FILTER_USED_BY_OPERATOR, null));
                    }
                }
                HashSet<String> srcRefFullPaths = new HashSet<String>();
                HashSet<String> ambiguousExpressions = new HashSet<String>();
                for (RSourceItem it : ((RClause)clause.getMapReference()).getSourceRef()) {
                    Object refSrc;
                    if (it.getDataModel() instanceof QueryField && !((ILogicalField)((Object)it.getDataModel())).isEnable()) {
                        l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_USING_DISABLED_FIELD, ((ILogicalField)((Object)it.getDataModel())).getFullPath()));
                    }
                    if (!((refSrc = it.getDataModel()) instanceof ILogicalField)) continue;
                    String fullPath = ((ILogicalField)refSrc).getFullPath();
                    if (!srcRefFullPaths.add(fullPath.toLowerCase()) && fullPath != null && ambiguousExpressions.add(fullPath.toLowerCase())) {
                        l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_AMBIGOUS_SRC_REF_FULL_PATH, fullPath));
                    }
                    if (clause.getLocation() == JoinLocation.SRC || !(refSrc instanceof Field) || !((Field)refSrc).isExtraStatic()) continue;
                    boolean supportExtraStaticOnWrk = false;
                    try {
                        supportExtraStaticOnWrk = ((Map)refSrc.eContainer().eContainer()).getAPI().getMdEvaluator().supportExtraStaticFieldUsageOnWrk((Datastore)refSrc.eContainer());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    if (supportExtraStaticOnWrk) continue;
                    l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_USING_EXTRA_FIELD, ((Field)refSrc).getFullPath()));
                }
                if (!(clause instanceof TargetFilter) && clause.getLocation() == JoinLocation.WRK) {
                    RMap refMap = (RMap)((Map)clause.eContainer()).getMapReference();
                    for (RSourceItem it : ((RClause)clause.getMapReference()).getSourceRef()) {
                        EObject cx;
                        MapModelItem obj = it.getDataModel();
                        if (!(obj instanceof ILogicalField)) continue;
                        EObject eObject = cx = obj.eContainer() == null ? null : ((IContainer)obj.eContainer()).getAPI().getMdEvaluator().evaluateConnection((IContainer)obj.eContainer(), IMetaDataInformationsProvider.EvaluationLocation.ON_STAGING);
                        if (((ILogicalField)((Object)obj)).isStageable()) continue;
                        block9: for (RSourceSet rs : refMap.getSourceSetRef(((IContainer)obj.eContainer()).getDataset())) {
                            IContainer targetSetContainer = rs.getTargetSet().getContainerModel().get(0);
                            EObject trgCx = targetSetContainer.getAPI().getMdEvaluator().evaluateConnection(targetSetContainer, IMetaDataInformationsProvider.EvaluationLocation.ON_STAGING);
                            for (Template t : ((Map)clause.eContainer()).getTemplate()) {
                                RLoadSet load;
                                if (!((RTemplate)t.getMapReference()).getTargetRef().contains((Object)rs.getTargetSet().getContainerModel().get(0)) || (load = ((RTemplate)t.getMapReference()).getLoad()) == null || Collections.disjoint(load.getContainer(), clause.getInvolvedContainers()) || ClauseConstraint.connectionsEquals(cx, trgCx)) continue;
                                l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_CLAUSE_NON_STAGEABLE_FIELD, ((ILogicalField)((Object)obj)).getFullPath()));
                                continue block9;
                            }
                        }
                    }
                }
                if (clause.getExpression() != null && !clause.getExpression().trim().isEmpty() && (connection = ExpressionParserHelper.getContextConnection(clause)) instanceof MdNode && (parserURL = ((MdNode)connection).evaluateXpathExpressionCached("INTERNAL_EXPRESSION_PARSER", null)) != null) {
                    try {
                        String parseError;
                        IExpressionParser parser = ExpressionParserHelper.createParser(parserURL);
                        if (parser != null && (parseError = parser.parse(clause.getExpression(), ExpressionParserHelper.getClauseOptions())) != null) {
                            l.add(new ProblemValidationStatus.ProblemEntry(RProblem.WARNING_SQL_PARSER_FAILURE, parseError));
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                for (RSourceItem sc : ((RClause)clause.getMapReference()).getSourceRef()) {
                    Level lvl;
                    EObject r;
                    MapModelItem it = sc.getDataModel();
                    if (!(it instanceof Field) || !((r = ((Field)it).basicGetRef()) instanceof MdNode) || (lvl = ((MdNode)r).getLevel()) == null || ((MdNode)r).getMappingType().contains(MappingType.SOURCE_MAPPING) || ((MdNode)r).getMappingType().contains(MappingType.MAPPING)) continue;
                    RProblem pb = RefFactory.eINSTANCE.createRProblem();
                    pb.setCode(RProblem.ERROR_CLAUSE_TECH_NO_SOURCE);
                    l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_CLAUSE_TECH_NO_SOURCE, ((Field)it).getFullPath()));
                }
                if (s instanceof ProblemValidationStatus) {
                    ((ProblemValidationStatus)s).getResultLocus().addAll(l);
                    return s;
                }
                return new ProblemValidationStatus((EObject)clause.getMapReference(), null, l);
            }
            return s;
        }
        catch (Throwable t) {
            return new Status(4, "com.indy.gmf.map", "ClauseConstraint Validation failed ", t);
        }
    }

    public static boolean connectionsEquals(EObject cx1, EObject cx2) {
        if (cx1 == cx2) {
            return true;
        }
        if (cx1 == null) {
            return false;
        }
        if (cx2 == null) {
            return false;
        }
        String fragment1 = null;
        fragment1 = cx1.eIsProxy() ? ((InternalEObject)cx1).eProxyURI().fragment() : EcoreUtil.getURI((EObject)cx1).fragment();
        String fragment2 = null;
        fragment2 = cx2.eIsProxy() ? ((InternalEObject)cx2).eProxyURI().fragment() : EcoreUtil.getURI((EObject)cx2).fragment();
        if (fragment1 == null || fragment2 == null) {
            return false;
        }
        return fragment1.equals(fragment2);
    }

    protected List<QName> getLocationErrorCodes(Clause clause) {
        ArrayList<QName> res = new ArrayList<QName>();
        int delete = 0;
        int error2 = 4;
        int error5 = 32;
        int error7 = 256;
        int warning7 = 512;
        if (clause.getLocation() == JoinLocation.SRC) {
            if (!ClauseHelper.hasRefOnSameConnection(clause)) {
                res.add(RProblem.ERROR_SOURCE_LOCATION);
                delete |= error2;
            } else if (clause.getMapReference() != null && ((RClause)clause.getMapReference()).getSourceRef().size() > 0) {
                if (!(((RSourceItem)((RClause)clause.getMapReference()).getSourceRef().get(0)).getDataModel() instanceof Variable)) {
                    for (RSourceItem itSrcRef : ((RClause)clause.getMapReference()).getSourceRef()) {
                        MapModelItem o;
                        if (itSrcRef instanceof RVariable || !((o = itSrcRef.getDataModel()).eContainer() instanceof IContainer)) continue;
                        IContainer container = (IContainer)o.eContainer();
                        if (clause instanceof Filter && !container.getAPI().getMdEvaluator().hasFilterOrWorkspaceCapability(container, IMetaDataInformationsProvider.EvaluationLocation.ON_REF) || clause instanceof Join && !container.getAPI().getMdEvaluator().hasJoinOrWorkspaceCapability(container, IMetaDataInformationsProvider.EvaluationLocation.ON_REF)) {
                            res.add(clause instanceof Filter ? RProblem.ERROR_NO_FILTER_CAPABILITY_GUI : RProblem.ERROR_NO_JOIN_CAPABILITY_GUI);
                            delete |= error5;
                            continue;
                        }
                        if (!(clause instanceof Filter) || !container.getAPI().getMdEvaluator().hasWarningOnFilter(container, IMetaDataInformationsProvider.EvaluationLocation.ON_REF) || (delete & warning7) != 0) continue;
                        res.add(RProblem.WARNING_TRANSFORM_CAPABILITIES);
                        delete |= warning7;
                    }
                }
            } else if (clause.getExpression() != null && !clause.getExpression().isEmpty()) {
                res.add(RProblem.WARNING_SOURCE_LOCATION);
                delete |= error7;
            }
        } else if (!(clause instanceof TargetFilter) && clause.getLocation() == JoinLocation.WRK) {
            Map map = null;
            EObject o = clause.eContainer();
            while (map == null && o != null) {
                if (o instanceof Map) {
                    map = (Map)o;
                }
                o = o.eContainer();
            }
            HashSet<RSourceSet> sourceSets = new HashSet<RSourceSet>();
            HashSet<DataSet> involvedDataSets = new HashSet<DataSet>();
            for (IContainer c : clause.getInvolvedContainers()) {
                involvedDataSets.add(c.getDataset());
            }
            for (RSourceSet ss : ((RMap)map.getMapReference()).getSourceSetRef()) {
                if (!ss.getDataSet().containsAll(involvedDataSets)) continue;
                sourceSets.add(ss);
            }
            boolean multipleTargetTechs = false;
            block4: for (RSourceSet ss : sourceSets) {
                String productCode = null;
                for (IContainer target : ss.getTargetSet().getContainerModel()) {
                    if (!multipleTargetTechs) {
                        String _productCode = clause.getAPI().getMdEvaluator().evaluateTechCode(target, IMetaDataInformationsProvider.EvaluationLocation.ON_STAGING);
                        if (productCode == null) {
                            productCode = _productCode;
                        } else if (!productCode.equals(_productCode)) {
                            multipleTargetTechs = true;
                        }
                    }
                    if (clause instanceof Filter && !target.getAPI().getMdEvaluator().hasFilterOrWorkspaceCapability(target, IMetaDataInformationsProvider.EvaluationLocation.ON_STAGING) || !target.getAPI().getMdEvaluator().hasJoinOrWorkspaceCapability(target, IMetaDataInformationsProvider.EvaluationLocation.ON_STAGING)) {
                        res.add(clause instanceof Filter ? RProblem.ERROR_NO_FILTER_CAPABILITY_GUI : RProblem.ERROR_NO_JOIN_CAPABILITY_GUI);
                        continue block4;
                    }
                    if (!(clause instanceof Filter) || !target.getAPI().getMdEvaluator().hasWarningOnFilter(target, IMetaDataInformationsProvider.EvaluationLocation.ON_STAGING)) continue;
                    res.add(RProblem.WARNING_TRANSFORM_CAPABILITIES);
                }
            }
            if (multipleTargetTechs) {
                res.add(RProblem.ERROR_MULTIPLE_TARGET_TECH);
            }
        }
        return res;
    }
}

