/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.validation;

import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.Join;
import com.indy.map.JoinLocation;
import com.indy.map.Map;
import com.indy.map.Template;
import com.indy.map.compute.validator.ILinkValidator;
import com.indy.map.compute.validator.JoinValidator;
import com.indy.map.messages.Messages;
import com.indy.map.ref.RClause;
import com.indy.map.ref.RMap;
import com.indy.map.ref.RProblem;
import com.indy.map.ref.RSourceItem;
import com.indy.map.ref.RSourceSet;
import com.indy.map.ref.RTargetSet;
import com.indy.map.ref.RTemplate;
import com.indy.map.validation.ClauseConstraint;
import com.indy.map.validation.ProblemValidationStatus;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;
import org.osgi.service.log.LogService;

public class JoinConstraint
extends ClauseConstraint {
    @Override
    public IStatus validate(IValidationContext ctx) {
        try {
            EObject eObj = ctx.getTarget();
            IStatus s = super.validate(ctx);
            if (eObj instanceof Join || eObj instanceof RClause && ((RClause)eObj).getDataModel() instanceof Join) {
                Join join = eObj instanceof Join ? (Join)eObj : (Join)((RClause)eObj).getDataModel();
                HashSet<ProblemValidationStatus.ProblemEntry> l = new HashSet<ProblemValidationStatus.ProblemEntry>();
                if (join.isInheritance()) {
                    if (join.getLeft().getDataset().getParent().contains((Object)join.getRight().getDataset())) {
                        if (!join.getLeft().getDataset().getFiltering().isEmpty()) {
                            l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_JOIN_USED_BY_OPERATOR, null));
                        }
                    } else if (join.getRight().getDataset().getParent().contains((Object)join.getLeft().getDataset()) && !join.getRight().getDataset().getFiltering().isEmpty()) {
                        l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_JOIN_USED_BY_OPERATOR, null));
                    }
                } else if (join.getLeft() != null) {
                    if (!join.getLeft().getDataset().getFiltering().isEmpty()) {
                        l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_JOIN_USED_BY_OPERATOR, null));
                    }
                } else if (join.getRight() != null && !join.getRight().getDataset().getFiltering().isEmpty()) {
                    l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_JOIN_USED_BY_OPERATOR, null));
                }
                List involved = join.getInvolvedContainers();
                Map mapModel = (Map)join.eContainer();
                RMap refMap = null;
                boolean isError = false;
                if (mapModel != null && (refMap = (RMap)mapModel.getMapReference()) != null) {
                    for (IContainer c : involved) {
                        if (((RMap)((Map)c.eContainer()).getMapReference()).getSourceSetRef(c.getDataset()).isEmpty()) continue;
                        isError = true;
                        break;
                    }
                }
                HashSet<EObject> referencedContainers = new HashSet<EObject>();
                for (RSourceItem it : ((RClause)join.getMapReference()).getSourceRef()) {
                    if (!(it.getDataModel() instanceof ILogicalField)) continue;
                    referencedContainers.add(it.getDataModel().eContainer());
                }
                if (join.getLeft() == null) {
                    if (isError) {
                        l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_LEFT_CONTAINER_NOT_DEFINED, null));
                    } else {
                        l.add(new ProblemValidationStatus.ProblemEntry(RProblem.WARNING_LEFT_CONTAINER_NOT_DEFINED, null));
                    }
                } else if (!referencedContainers.contains(join.getLeft())) {
                    l.add(new ProblemValidationStatus.ProblemEntry(RProblem.WARNING_LEFT_SOURCE_NOT_USED, null));
                }
                if (join.getRight() == null) {
                    if (isError) {
                        l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_RIGHT_CONTAINER_NOT_DEFINED, null));
                    } else {
                        l.add(new ProblemValidationStatus.ProblemEntry(RProblem.WARNING_RIGHT_CONTAINER_NOT_DEFINED, null));
                    }
                } else if (!referencedContainers.contains(join.getRight())) {
                    l.add(new ProblemValidationStatus.ProblemEntry(RProblem.WARNING_RIGHT_SOURCE_NOT_USED, null));
                }
                if (join.getLeft() != null && join.getRight() != null) {
                    boolean done = false;
                    block6: for (IContainer c : join.getInvolvedContainers()) {
                        if (done) break;
                        for (IContainer _c : join.getInvolvedContainers()) {
                            ILinkValidator.ValidationStatus st;
                            if (c == _c || c.getDataset() == null || _c.getDataset() == null || !(st = JoinValidator.INSTANCE.canCreateLink(c, _c)).isError()) continue;
                            l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_JOIN_MAPPING, st.getMessage()));
                            done = true;
                            continue block6;
                        }
                    }
                }
                if (refMap != null && join.getLocation() != JoinLocation.SRC) {
                    try {
                        ArrayList<RSourceSet> list = new ArrayList<RSourceSet>((Collection<RSourceSet>)refMap.getSourceSetRef());
                        for (RSourceSet ss : list) {
                            boolean needsJoin = false;
                            if (!needsJoin && join.getLeft() != null && ss.contains(join.getLeft()) && join.getRight() != null && ss.contains(join.getRight())) {
                                needsJoin = true;
                            }
                            if (!needsJoin) {
                                boolean b = true;
                                for (IContainer c : join.getInvolvedContainers()) {
                                    if (ss.contains(c)) continue;
                                    b = false;
                                    break;
                                }
                                if (b) {
                                    needsJoin = true;
                                }
                            }
                            RTargetSet ts = ss.getTargetSet();
                            if (!needsJoin || ts == null) continue;
                            ArrayList<Template> lt = new ArrayList<Template>((Collection<Template>)mapModel.getTemplate());
                            for (Template t : lt) {
                                RTemplate.Type type;
                                RTemplate refTemplate = (RTemplate)t.getMapReference();
                                if (refTemplate == null || Collections.disjoint(refTemplate.getTargetRef(), ts.getContainerModel()) || !(type = refTemplate.getTemplateType()).isIntegration() || refTemplate.hasLoad()) continue;
                                l.add(new ProblemValidationStatus.ProblemEntry(RProblem.ERROR_JOIN_TEMPLATE_NO_LOAD, refTemplate.getDescription()));
                            }
                        }
                    }
                    catch (Throwable e) {
                        ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger("com.indy.map").error(Messages.JoinConstraint_1, (Object)e);
                    }
                }
                if (s instanceof ProblemValidationStatus) {
                    ((ProblemValidationStatus)s).getResultLocus().addAll(l);
                    return s;
                }
                return new ProblemValidationStatus((EObject)join.getMapReference(), null, l);
            }
            return s;
        }
        catch (Throwable t) {
            return new Status(4, "com.indy.gmf.map", ((Object)((Object)this)).getClass().getName() + " Validation failed ", t);
        }
    }
}

