/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.engine.api;

import com.indy.ui.custom.out.tools.FigureColoringHelper;
import com.indy.ui.engine.Activator;
import com.indy.ui.engine.Messages;
import org.eclipse.gmf.runtime.diagram.ui.figures.DiagramColorConstants;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public enum ActionStatus {
    ACTION_NEVER_EXECUTED(0, "ACTION_NEVER_EXECUTED", Messages.ActionStatus_1, FigureColoringHelper.getActionColorStatePrepared(), Activator.getImage("icons/Wait16x16.png")),
    ACTION_EXECUTED(1, "EXECUTED", Messages.ActionStatus_4, FigureColoringHelper.getActionColorStateExecuted(), Activator.getImage("icons/OK1_16x16.png")),
    ACTION_RUNNING(2, "RUNNING", Messages.ActionStatus_7, FigureColoringHelper.getActionColorStateRunning(), Activator.getImage("icons/Running16x16.png")),
    ACTION_KILLED(-2, "KILLED", Messages.ActionStatus_10, FigureColoringHelper.getActionColorStateKilled(), Activator.getImage("icons/Killed16x16.png")),
    ACTION_WITH_ERRORS(-1, "WITH_ERRORS", Messages.ActionStatus_13, FigureColoringHelper.getActionColorStateWithErrors(), Activator.getImage("icons/Error_16x16.png")),
    ACTION_WITH_TOLERATED_ERRORS(-1001, "WITH_TOLERATED_ERRORS", Messages.ActionStatus_16, FigureColoringHelper.getActionColorStateWithToleratedErrors(), Activator.getImage("icons/Warning_16x16.png")),
    ACTION_TO_RESTART(7, "TO_RESTART", Messages.ActionStatus_19, FigureColoringHelper.getActionColorStateRestart(), null),
    ACTION_ENDING_RUN(3, "ENDING_RUN", Messages.ActionStatus_21, FigureColoringHelper.getActionColorStateEnding(), null),
    ACTION_PAUSED(6, "PAUSED", Messages.ActionStatus_23, FigureColoringHelper.getActionColorStatePaused(), null),
    ACTION_PREPARING(9, "PREPARING", Messages.ActionStatus_25, DiagramColorConstants.cyan, null),
    ACTION_BINDED_AND_RUNNING(4, "BINDED_AND_RUNNING", Messages.ActionStatus_27, FigureColoringHelper.getActionColorStateBindedAndRunning(), null),
    ACTION_NOT_GENERATED(-1000, "NOT_GENERATED", Messages.ActionStatus_29, FigureColoringHelper.getColorAction(), null);

    private final int id;
    private final String name;
    private final String message;
    private final Color color;
    private final Image image;

    public Image getImage() {
        return this.image;
    }

    private ActionStatus(int id, String name, String message, Color color, Image image) {
        this.color = color;
        this.id = id;
        this.message = message;
        this.name = name;
        this.image = image;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getMessage() {
        return this.message;
    }

    public Color getColor() {
        return this.color;
    }

    public static ActionStatus getActionStatusById(int id, boolean toleratedError) {
        switch (id) {
            case 1: {
                return ACTION_EXECUTED;
            }
            case 2: {
                return ACTION_RUNNING;
            }
            case 0: {
                return ACTION_NEVER_EXECUTED;
            }
            case -2: {
                return ACTION_KILLED;
            }
            case -3: {
                return ACTION_KILLED;
            }
            case -1: {
                if (toleratedError) {
                    return ACTION_WITH_TOLERATED_ERRORS;
                }
                return ACTION_WITH_ERRORS;
            }
            case 7: {
                return ACTION_TO_RESTART;
            }
            case 3: {
                return ACTION_ENDING_RUN;
            }
            case 6: {
                return ACTION_PAUSED;
            }
            case 9: {
                return ACTION_PREPARING;
            }
            case 4: {
                return ACTION_BINDED_AND_RUNNING;
            }
            case -1000: {
                return ACTION_NOT_GENERATED;
            }
        }
        return null;
    }
}

