/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.engine.preference;

import com.indy.ui.custom.out.common.properties.AbstractUnboundedControl;
import com.indy.ui.custom.out.services.IStatisticsProvider;
import com.indy.ui.engine.Activator;
import com.indy.ui.engine.Messages;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class StatisticsPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private String CHECK;
    private String UNCHECK;
    private List<ModelItem> content;
    private TableViewer viewer;

    public StatisticsPreferencePage() {
        this.setPreferenceStore(com.indy.ui.custom.out.Activator.getDefault().getPreferenceStore());
        this.setDescription(Messages.MonitorPreferencePage_0);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        try {
            this.UNCHECK = new String(new byte[]{-30, -104, -112}, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        try {
            this.CHECK = new String(new byte[]{-30, -104, -111}, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.doComputeContent(false);
    }

    private void doComputeContent(boolean restoreDefault) {
        IStatisticsProvider statProvider = (IStatisticsProvider)E4InjectorHelper.getService(IStatisticsProvider.class);
        HashMap items = new HashMap();
        statProvider.getStatistics().forEach(d -> {
            ModelItem modelItem = items.put(d.getCode(), new ModelItem((IStatisticsProvider.StatisticDefinition)d, restoreDefault));
        });
        if (!restoreDefault) {
            String user = this.getPreferenceStore().getString("monitorUserStat");
            if (user != null && !user.isEmpty()) {
                Arrays.stream(user.split(",")).map(s -> s.trim()).forEach(s -> items.put(s, new ModelItem((String)s, false, true)));
            }
            String sums = this.getPreferenceStore().getString("monitorSumStat");
            Arrays.stream(sums.split(",")).map(s -> s.trim()).forEach(s -> {
                ModelItem it = (ModelItem)items.get(s);
                it.enabled = true;
            });
        }
        this.content = new ArrayList(items.values());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.viewer.getInput() == null) {
            this.viewer.setInput(this.content);
        }
    }

    protected void createFieldEditors() {
        this.addField((FieldEditor)new BooleanFieldEditor("monitorStat", Messages.MonitorPreferencePage_1, this.getFieldEditorParent()));
    }

    protected Control createContents(Composite parent) {
        Composite main = (Composite)super.createContents(parent);
        ToolBar tb = new ToolBar(main, 256);
        tb.setLayoutData((Object)new GridData());
        ToolItem add = new ToolItem(tb, 8);
        add.setToolTipText(Messages.StatisticsPreferencePage_tooltip_add);
        add.setImage(AbstractUnboundedControl.addIcon);
        final ToolItem del = new ToolItem(tb, 8);
        del.setToolTipText(Messages.StatisticsPreferencePage_tooltip_remove);
        del.setImage(AbstractUnboundedControl.delIcon);
        del.setEnabled(false);
        final TableViewer v = new TableViewer(main, 68352);
        v.setContentProvider((IContentProvider)new ArrayContentProvider());
        v.getControl().setLayoutData((Object)new GridData(4, 4, false, true));
        v.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String s1 = ((ModelItem)e1).name;
                String s2 = ((ModelItem)e2).name;
                return super.compare(viewer, (Object)s1, (Object)s2);
            }
        });
        v.getTable().setHeaderVisible(true);
        v.getTable().setLinesVisible(true);
        TableViewerColumn col = new TableViewerColumn(v, 16384);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ModelItem)element).name;
            }

            public Color getForeground(Object element) {
                if (!((ModelItem)element).user) {
                    return JFaceResources.getColorRegistry().get("QUALIFIER_COLOR");
                }
                return super.getForeground(element);
            }
        });
        col.getColumn().setText(Messages.StatisticsPreferencePage_stat_column_name);
        col.setEditingSupport(new EditingSupport((ColumnViewer)v){
            TextCellEditor editor;
            {
                super($anonymous0);
                this.editor = null;
            }

            private void createCellEditor() {
                this.editor = new TextCellEditor((Composite)v.getTable());
                this.editor.setValidator(value -> {
                    String s = (String)value;
                    if (s.trim().isEmpty()) {
                        return Messages.StatisticsPreferencePage_stat_column_name_no_value;
                    }
                    char[] cArray = s.toCharArray();
                    int n = cArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        char c = cArray[n2];
                        if (!Character.isJavaIdentifierPart(c)) {
                            return Messages.StatisticsPreferencePage_stat_column_name_invalid_value;
                        }
                        ++n2;
                    }
                    return null;
                });
            }

            protected CellEditor getCellEditor(Object element) {
                if (this.editor == null) {
                    this.createCellEditor();
                }
                return this.editor;
            }

            protected boolean canEdit(Object element) {
                return ((ModelItem)element).user;
            }

            protected Object getValue(Object element) {
                return ((ModelItem)element).name;
            }

            protected void setValue(Object element, Object value) {
                ((ModelItem)element).name = (String)value;
                this.getViewer().update(element, null);
            }
        });
        col = new TableViewerColumn(v, 0x1000000);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (((ModelItem)element).enabled) {
                    return StatisticsPreferencePage.this.CHECK;
                }
                return StatisticsPreferencePage.this.UNCHECK;
            }
        });
        col.getColumn().setText(Messages.StatisticsPreferencePage_stat_column_enabled);
        col.getColumn().setWidth(100);
        TableLayout l = new TableLayout(true);
        v.getTable().setLayout((Layout)l);
        l.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
        l.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
        v.getTable().addListener(3, event -> this.tableMouseDown(event, v));
        v.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getStructuredSelection().isEmpty()) {
                    del.setEnabled(false);
                } else {
                    del.setEnabled(((ModelItem)event.getStructuredSelection().getFirstElement()).user);
                }
            }
        });
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelItem it = new ModelItem(Messages.StatisticsPreferencePage_new_statistic_default_name, true, true);
                StatisticsPreferencePage.this.content.add(it);
                StatisticsPreferencePage.this.viewer.refresh();
                StatisticsPreferencePage.this.viewer.setSelection((ISelection)new StructuredSelection((Object)it), true);
            }
        });
        del.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object o = StatisticsPreferencePage.this.viewer.getStructuredSelection().getFirstElement();
                StatisticsPreferencePage.this.content.remove(o);
                StatisticsPreferencePage.this.viewer.refresh();
            }
        });
        this.viewer = v;
        return main;
    }

    private void tableMouseDown(Event event, TableViewer viewer) {
        Table table = viewer.getTable();
        Point pt = new Point(event.x, event.y);
        int lineWidth = table.getLinesVisible() ? table.getGridLineWidth() : 0;
        TableItem item = table.getItem(pt);
        if ((table.getStyle() & 0x10000) != 0) {
            if (item == null) {
                return;
            }
        } else {
            int start = item != null ? table.indexOf(item) : table.getTopIndex();
            int end = table.getItemCount();
            Rectangle clientRect = table.getClientArea();
            int i = start;
            while (i < end) {
                TableItem nextItem = table.getItem(i);
                Rectangle rect = nextItem.getBounds(0);
                if (pt.y >= rect.y && pt.y < rect.y + rect.height + lineWidth) {
                    item = nextItem;
                    break;
                }
                if (rect.y > clientRect.y + clientRect.height) {
                    return;
                }
                ++i;
            }
            if (item == null) {
                return;
            }
        }
        TableColumn newColumn = null;
        Rectangle rect = item.getBounds(1);
        rect.width += lineWidth;
        rect.height += lineWidth;
        if (rect.contains(pt)) {
            newColumn = table.getColumn(1);
        }
        if (newColumn != null) {
            ModelItem it = (ModelItem)item.getData();
            it.enabled = !it.enabled;
            viewer.refresh((Object)it, true);
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        this.doComputeContent(true);
        this.viewer.setInput(this.content);
    }

    protected void performApply() {
        super.performApply();
        this.writeStatisticsPreferences();
    }

    private void writeStatisticsPreferences() {
        StringBuffer sumStats = new StringBuffer();
        StringBuffer userStats = new StringBuffer();
        this.content.forEach(i -> {
            if (i.enabled) {
                if (sumStats.length() > 0) {
                    sumStats.append(",");
                }
                sumStats.append(i.name);
            }
            if (i.user) {
                if (userStats.length() > 0) {
                    userStats.append(",");
                }
                userStats.append(i.name);
            }
        });
        this.getPreferenceStore().setValue("monitorSumStat", sumStats.toString());
        if (userStats.length() > 0) {
            this.getPreferenceStore().setValue("monitorUserStat", userStats.toString());
        } else {
            this.getPreferenceStore().setToDefault("monitorUserStat");
        }
    }

    public boolean performOk() {
        this.writeStatisticsPreferences();
        return super.performOk();
    }

    class ModelItem {
        String name;
        boolean enabled;
        boolean user;

        public ModelItem(IStatisticsProvider.StatisticDefinition def, boolean enabled) {
            this.name = def.getCode();
            this.enabled = enabled;
            this.user = false;
        }

        public ModelItem(String name, boolean enabled, boolean isUserDefined) {
            this.name = name;
            this.enabled = enabled;
            this.user = isUserDefined;
        }
    }
}

