/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.engine.session;

import com.indy.engine.core.common.objects2.IIdDataExchange;
import com.indy.engine.core.common.objects2.ISessionDataExchange;
import com.indy.engine.core.common.objects2.SessionDataExchange;
import com.indy.ui.custom.out.EngineVariable;
import com.indy.ui.engine.Activator;
import com.indy.ui.engine.ClientVariable;
import com.indy.ui.engine.EngineGlobal;
import com.indy.ui.engine.Messages;
import com.indy.ui.engine.api.v1_0.LocalGLobalVar;
import com.indy.ui.engine.session.ISessionListViewer;
import com.indy.ui.engine.session.SessionList;
import com.indy.ui.engine.session.SessionToProcessNavigatorHelper;
import com.indy.ui.engine.session.SessionTree;
import com.indy.ui.engine.session.SessionsMonitorState;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;

public class SessionsOfEngine
extends Composite {
    private final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private SessionTree tblSession = null;
    private Button butPurgeAll;
    private Button butPurge;
    private ISessionListViewer sessionListListener = null;

    public SessionsOfEngine(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout gridLayout = new GridLayout(1, false);
        this.setLayout((Layout)gridLayout);
        Composite cp = new Composite((Composite)this, 0);
        cp.setLayoutData((Object)new GridData(4, 1, true, false));
        cp.setLayout((Layout)new GridLayout(7, false));
        this.createNameFilter(cp);
        this.createStatusFilter(cp);
        this.createNbSessionFilter(cp);
        this.createMySession(cp);
        this.createCurrentEngine(cp);
        this.createTable();
    }

    private void createNbSessionFilter(Composite cp) {
        Label lbSessions = new Label(cp, 0);
        lbSessions.setText(Messages.SessionsOfEngine_3);
        GridData gridData = new GridData();
        lbSessions.setLayoutData((Object)gridData);
        final Text numberOfSession = new Text(cp, 2048);
        numberOfSession.setText("" + SessionsMonitorState.getInstance().getNbSessions());
        numberOfSession.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                String string = e.text;
                char[] chars = new char[string.length()];
                string.getChars(0, chars.length, chars, 0);
                int i = 0;
                while (i < chars.length) {
                    if ('0' > chars[i] || chars[i] > '9') {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
            }
        });
        numberOfSession.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                String tmp = numberOfSession.getText();
                if (tmp == null || tmp.isEmpty()) {
                    SessionsOfEngine.this.setNbSession("0");
                } else {
                    SessionsOfEngine.this.setNbSession(tmp);
                }
            }
        });
        Point pt = numberOfSession.computeSize(-1, -1);
        gridData = new GridData();
        if (pt.x < 50) {
            gridData.minimumWidth = 50;
        }
        numberOfSession.setLayoutData((Object)gridData);
    }

    private void createMySession(Composite cp) {
        final Button b = new Button(cp, 32);
        b.setText(Messages.SessionsOfEngine_6);
        b.setSelection(SessionsMonitorState.getInstance().onlyLocal());
        GridData gridData = new GridData();
        b.setLayoutData((Object)gridData);
        b.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SessionsOfEngine.this.setMySessions(b.getSelection());
            }
        });
    }

    private void createCurrentEngine(Composite cp) {
        final Button b = new Button(cp, 32);
        b.setText(Messages.SessionsOfEngine_7);
        b.setSelection(SessionsMonitorState.getInstance().isCurrentRuntime());
        GridData gridData = new GridData();
        b.setLayoutData((Object)gridData);
        b.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SessionsOfEngine.this.setCurrentEngine(b.getSelection());
            }
        });
    }

    private void createNameFilter(Composite cp) {
        Label searchLabel = new Label(cp, 0);
        searchLabel.setText(Messages.SessionsOfEngine_8);
        new DecorationListener((Control)searchLabel);
        GridData gridData = new GridData();
        searchLabel.setLayoutData((Object)gridData);
        final Text searchText = new Text(cp, 2176);
        gridData = new GridData();
        searchText.setText(SessionsMonitorState.getInstance().getFilter());
        gridData.widthHint = 100;
        searchText.setLayoutData((Object)gridData);
        searchText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                String tmp = searchText.getText();
                SessionsOfEngine.this.setFilter(tmp);
            }
        });
    }

    private void createStatusFilter(Composite cp) {
        final ComboViewer cv = new ComboViewer(cp, 8);
        cv.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element.equals("ALL")) {
                    return super.getText(element);
                }
                return LocalGLobalVar.getStringEngineStatus(new Integer((String)element));
            }
        });
        final ArrayList<String> list = new ArrayList<String>();
        list.add("ALL");
        list.add(new Integer(2).toString());
        list.add(new Integer(1).toString());
        list.add(new Integer(-1).toString());
        list.add(new Integer(10).toString());
        list.add(new Integer(-2).toString());
        list.add(new Integer(6).toString());
        list.add(new Integer(-4).toString());
        cv.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                return list.toArray();
            }
        });
        cv.setInput((Object)"");
        GridData gridData = new GridData();
        cv.getCombo().setLayoutData((Object)gridData);
        cv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                int i = cv.getCombo().getSelectionIndex();
                String str = null;
                if (i > 0 && i < list.size()) {
                    str = (String)list.get(i);
                }
                SessionsOfEngine.this.setStatut(str);
            }
        });
        String tmp = Activator.getDefault().getPreferenceStore().getString("engineFilterStatus");
        this.setStatut(tmp);
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add(tmp == null ? "ALL" : tmp);
        cv.setSelection((ISelection)new StructuredSelection(list2));
    }

    private void setStatut(String statut) {
        ArrayList<Integer> status = null;
        if (statut != null && !statut.equals("ALL") && !statut.trim().equals("")) {
            status = new ArrayList<Integer>();
            status.add(new Integer(statut));
        }
        SessionsMonitorState.getInstance().setStatus(status);
    }

    private void setFilter(String tmp) {
        SessionsMonitorState.getInstance().setFilter(tmp);
    }

    private void setNbSession(String nbSession) {
        Integer nb = null;
        try {
            nb = Integer.valueOf(nbSession);
        }
        catch (Exception ex) {
            nb = -2;
        }
        SessionsMonitorState.getInstance().setNbSessions(nb);
    }

    private void setMySessions(boolean active) {
        SessionsMonitorState.getInstance().setSessionLocal(active);
    }

    private void setCurrentEngine(boolean active) {
        SessionsMonitorState.getInstance().setCurrentRuntime(active);
    }

    public void createPurgeAll(Composite cp) {
        Image imPurge = Activator.getImage("icons/Trash2_16x16.png");
        this.butPurge.setImage(imPurge);
        this.butPurgeAll = new Button(cp, 0);
        this.butPurgeAll.setText("all");
        this.butPurgeAll.setToolTipText(Messages.SessionsOfEngine_17);
        this.butPurgeAll.setImage(imPurge);
        this.butPurgeAll.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                int x = e.x;
                int y = e.y;
                int width = SessionsOfEngine.this.butPurgeAll.getBounds().width;
                int height = SessionsOfEngine.this.butPurgeAll.getBounds().height;
                if (x > 0 && x < width && y > 0 && y < height) {
                    try {
                        EngineGlobal.getEngine().purgeLogs(new Date());
                        EngineGlobal.getSessionList().removeAllSessions();
                    }
                    catch (Exception e1) {
                        SessionsOfEngine.this.logger.log(Level.WARNING, "An exception occured : ", e1);
                    }
                }
            }
        });
    }

    public void createPurge(Composite cp) {
        this.butPurge = new Button(cp, 0);
        this.butPurge.setText(Messages.SessionsOfEngine_4);
        this.butPurge.setToolTipText(Messages.SessionsOfEngine_19);
        Image imPurge = Activator.getImage("icons/Trash2_16x16.png");
        this.butPurge.setImage(imPurge);
        this.butPurge.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                int x = e.x;
                int y = e.y;
                int width = SessionsOfEngine.this.butPurgeAll.getBounds().width;
                int height = SessionsOfEngine.this.butPurgeAll.getBounds().height;
                if (x > 0 && x < width && y > 0 && y < height) {
                    final DateTime[] dateTime = new DateTime[2];
                    final Date[] date = new Date[1];
                    Dialog d = new Dialog(SessionsOfEngine.this.getShell()){

                        protected Control createDialogArea(Composite parent) {
                            Composite dialogArea = (Composite)super.createDialogArea(parent);
                            final Date dateValue = new Date();
                            date[0] = new Date();
                            dateTime[0] = new DateTime(dialogArea, 1024);
                            dateTime[0].addSelectionListener((SelectionListener)new SelectionAdapter(){

                                public void widgetSelected(SelectionEvent e) {
                                    dateValue.setYear(dateTime[0].getYear());
                                    dateValue.setMonth(dateTime[0].getMonth());
                                    dateValue.setDate(dateTime[0].getDay());
                                    date[0] = dateValue;
                                    super.widgetSelected(e);
                                }
                            });
                            dateTime[1] = new DateTime(dialogArea, 128);
                            dateTime[1].addSelectionListener((SelectionListener)new SelectionAdapter(){

                                public void widgetSelected(SelectionEvent e) {
                                    dateValue.setHours(dateTime[1].getHours());
                                    dateValue.setMinutes(dateTime[1].getMinutes());
                                    dateValue.setSeconds(dateTime[1].getSeconds());
                                    date[0] = dateValue;
                                    super.widgetSelected(e);
                                }
                            });
                            return dialogArea;
                        }
                    };
                    d.setBlockOnOpen(true);
                    d.open();
                    if (d.getReturnCode() == 0) {
                        try {
                            EngineGlobal.getEngine().purgeLogs(date[0]);
                            EngineGlobal.getSessionList().removeAllSessions();
                        }
                        catch (Exception e1) {
                            SessionsOfEngine.this.logger.log(Level.WARNING, "An exception occured : ", e1);
                        }
                    }
                }
            }
        });
    }

    public void createTable() {
        this.tblSession = new SessionTree(this, 68354){

            @Override
            SessionList getSessionList() {
                return EngineGlobal.getSessionList();
            }
        };
        this.sessionListListener = new ISessionListViewer(){

            @Override
            public void updateSessions(Object[] objects) {
            }

            @Override
            public void setSelection(ISessionDataExchange session) {
            }

            @Override
            public void removeSessions(Object[] sessions) {
            }

            @Override
            public void removeAllSessions() {
            }

            @Override
            public void refresh() {
            }

            @Override
            public void addSessions(Object[] sessions) {
                if (EngineGlobal.getStatus() != 1 || EngineVariable.INSTANCE.getSelectedRootProcess() == null || EngineVariable.INSTANCE.getSessionId() == null) {
                    return;
                }
                Object[] objectArray = sessions;
                int n = sessions.length;
                int n2 = 0;
                while (n2 < n) {
                    Object s = objectArray[n2];
                    if (((SessionDataExchange)s).getId().equals(EngineVariable.INSTANCE.getSessionId())) {
                        SessionsOfEngine.this.tblSession.getViewer().setSelection((ISelection)new StructuredSelection(s));
                        break;
                    }
                    ++n2;
                }
            }
        };
        this.tblSession.getSessionList().addChangeListener(this.sessionListListener);
        this.tblSession.getViewer().addDoubleClickListener(new IDoubleClickListener(){
            SessionToProcessNavigatorHelper helper = new SessionToProcessNavigatorHelper();

            public void doubleClick(DoubleClickEvent event) {
                SessionDataExchange sde = (SessionDataExchange)((IStructuredSelection)event.getSelection()).getFirstElement();
                SessionsOfEngine.this.tblSession.getViewer().setSelection((ISelection)new StructuredSelection((Object)sde));
                try {
                    Map<String, Map<String, Object>> tmGlobalVariables = EngineGlobal.getEngine().getLstRootSessionVariables(sde.getId());
                    String actionRootID = null;
                    String failureActionId = null;
                    if (tmGlobalVariables != null) {
                        ClientVariable var;
                        Map<String, Object> o = tmGlobalVariables.get("CORE_ROOT_ID");
                        if (o != null && (var = new ClientVariable(o)) != null) {
                            actionRootID = var.getValue();
                        }
                        if ((o = tmGlobalVariables.get("CORE_SESSION_FAILURE_CAUSE_ACTION_ID")) != null && (var = new ClientVariable(o)) != null) {
                            failureActionId = var.getValue();
                        }
                    }
                    if (failureActionId != null) {
                        try {
                            this.helper.openAction(sde.getId(), failureActionId);
                        }
                        catch (Exception ex) {
                            SessionsOfEngine.this.logger.log(Level.WARNING, "An exception occured : ", ex);
                        }
                    } else if (sde.getFailureCauseActionId() != null) {
                        try {
                            this.helper.openAction(sde.getId(), sde.getFailureCauseActionId());
                        }
                        catch (Exception ex) {
                            SessionsOfEngine.this.logger.log(Level.WARNING, "An exception occured : ", ex);
                        }
                    } else {
                        Map<String, IIdDataExchange> ide = EngineGlobal.getEngine().getActionAltId(sde.getId(), actionRootID);
                        if (ide != null) {
                            String sourceId = ide.get("compilation").getId();
                            System.out.println("SourceId: " + sourceId);
                            URI uri = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).findResourceURIByFileId(sourceId);
                            if (uri != null) {
                                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new URIEditorInput(uri), "com.indy.gmf.proc.diagram.non_rcp.part.ProcDiagramEditorID");
                            } else {
                                MessageDialog.openInformation((Shell)SessionsOfEngine.this.getShell(), (String)Messages.SessionsOfEngine_27, (String)Messages.bind((String)Messages.SessionsOfEngine_28, (Object)sourceId));
                            }
                        } else {
                            Activator.getDefault().getLog().log((IStatus)new Status(4, "com.indy.ui.engine", Messages.SessionsOfEngine_30 + sde.getId()));
                        }
                    }
                }
                catch (Exception ex) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "com.indy.ui.engine", Messages.SessionsOfEngine_31, (Throwable)ex));
                }
            }
        });
    }

    public void dispose() {
        this.tblSession.getSessionList().removeChangeListener(this.sessionListListener);
        super.dispose();
    }

    public TreeViewer getTableViewer() {
        return this.tblSession.getViewer();
    }

    private class DecorationListener
    implements PropertyChangeListener {
        private ControlDecoration decoration;

        public DecorationListener(Control control) {
            this.decoration = new ControlDecoration(control, 16384);
            this.decoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING").getImage());
            this.decoration.hide();
            this.decoration.setDescriptionText(Messages.SessionsOfEngine_0);
            control.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    DecorationListener.this.decoration.dispose();
                    DecorationListener.this.decoration = null;
                    SessionsMonitorState.getInstance().removeListener(DecorationListener.this);
                }
            });
            SessionsMonitorState.getInstance().addListener(this);
        }

        @Override
        public void propertyChange(final PropertyChangeEvent evt) {
            if ("session.refresh.frequency.unfit".equals(evt.getPropertyName())) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (DecorationListener.this.decoration != null) {
                            if (evt.getNewValue() == Boolean.TRUE) {
                                DecorationListener.this.decoration.show();
                            } else {
                                DecorationListener.this.decoration.hide();
                            }
                        }
                    }
                });
            }
        }
    }
}

