/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation;

import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IEnvironmentConfiguration;
import com.semarchy.xdi.designer.core.services.IEvaluationConfigurationService;
import com.semarchy.xdi.designer.core.services.IGenerationService;
import com.semarchy.xdi.designer.core.services.IRegistryService;
import com.semarchy.xdi.designer.core.services.registry.LevelCodeInfo;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.core.utils.RuntimeLocationHelper;
import com.semarchy.xdi.designer.core.utils.URIUtils;
import com.semarchy.xdi.designer.generation.AntProperties;
import com.semarchy.xdi.designer.generation.ExecutionInterrupter;
import com.semarchy.xdi.designer.generation.Messages;
import com.semarchy.xdi.designer.generation.WorkbenchInvocationInitializer;
import com.semarchy.xdi.designer.generation.cli.PathResolver;
import com.semarchy.xdi.designer.generation.xsl.CustomMessageEmitter;
import com.semarchy.xdi.designer.generation.xsl.global.Functions;
import com.semarchy.xdi.designer.generation.xsl.global.GraphUtil;
import com.semarchy.xdi.designer.generation.xsl.global.Variables;
import com.semarchy.xdi.designer.generation.xsl.global.WorkbenchInvocation;
import jakarta.inject.Inject;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.util.URI;

public class ExecuteAnt {
    private static final String BUILD_FILE = "build.ant";
    public static final String STEP_PROC_TO_DELIV = "delivery.procToDeliv";
    public static final String STEP_LITETRANSFO = "workspace.liteTransfo";
    private static final String STEP_XML_TO_MD = "workspace.xmlToMd";
    private static final String STEP_IMPORT_MD = "workspace.importMd";
    private static final String STEP_IMPORT_MAP = "workspace.importmap";
    private static final String STEP_IMPORT_PROCESS = "workspace.importProcess";
    public static final String STEP_PROC_TO_HTML = "documentation.procToHtml";
    public static final String STEP_CREATE_PACKAGE_WITH_DOC = "package.full.create.doc";
    public static final String STEP_CREATE_PACKAGE = "package.full.create";
    public static final String STEP_DELIV_TO_TEXT = "compare.delivery.to.text";
    Project project;
    File source;
    private URI sourceURI;
    private String inDir;
    private String absoulteUri;
    @Inject
    private IRegistryService registryService;
    @Inject
    private ICacheService cacheService;
    private URI modelURI;

    public ExecuteAnt(URI modelURI) throws Exception {
        E4InjectorHelper.inject((Object)this);
        if (modelURI != null) {
            this.modelURI = modelURI;
            PathResolver.WkspPathLocation location = PathResolver.resolveWorkspaceRelativePath(URIUtils.toPath((URI)modelURI).toString());
            File modelFile = location.getSourceFile();
            this.absoulteUri = modelFile.getParentFile().getAbsolutePath();
            this.inDir = location.getPath().append("..").toString();
            this.sourceURI = location.getURI();
        }
        this.initAnt();
        this.initEnv();
    }

    private String getInDir() {
        return this.inDir;
    }

    protected void initIconsPathIfRequired(String actionType) {
        if (!(actionType.equals(STEP_CREATE_PACKAGE) || actionType.equals("package.multiProc") || actionType.equals(STEP_CREATE_PACKAGE_WITH_DOC) || actionType.equals(STEP_PROC_TO_HTML))) {
            return;
        }
        HashMap<String, URI> iconsLvl = new HashMap<String, URI>();
        IRegistryService.IRegistry registry = this.registryService.getRegistry(LevelCodeInfo.class);
        for (LevelCodeInfo i : registry.getAll()) {
            if (i.getImageURI() == null) continue;
            URI cur = (URI)iconsLvl.get(i.getLevelCode());
            if (cur == null) {
                iconsLvl.put(i.getLevelCode(), i.getImageURI());
                continue;
            }
            if (!cur.toString().endsWith("icons/full/obj16/default_icon.gif") || i.getImageURI().toString().endsWith("icons/full/obj16/default_icon.gif")) continue;
            iconsLvl.put(i.getLevelCode(), i.getImageURI());
        }
        String icns = iconsLvl.entrySet().stream().map(e -> (String)e.getKey() + "=" + ((URI)e.getValue()).toString()).collect(Collectors.joining(";"));
        this.addProperty("levelIconsPerDefType", icns);
        this.project.setProperty(AntProperties.LEVEL_ICN_GENERATIO_PATH.getPropertyName(), this.project.getProperty("work2.dir"));
    }

    private void prepareAnt() {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        this.project.setCoreLoader(this.getClass().getClassLoader());
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            if (this.project.getTargets().size() == 0) {
                ProjectHelper.configureProject((Project)this.project, (File)new File(RuntimeLocationHelper.getRuntimeLocation(), BUILD_FILE));
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
    }

    private void initEnv() {
        System.setProperty("xpath.function.setStagingpoint.supported", Boolean.TRUE.toString());
        System.setProperty("xpath.build.engine.version", "1");
    }

    public void addProperty(String name, String value) {
        this.project.setProperty(name, value);
    }

    private void initAnt() {
        Variables.resetProperties();
        this.project = new Project();
        this.project.init();
        this.project.setBasedir(RuntimeLocationHelper.getRuntimeLocation().getAbsolutePath());
        this.addProperty(AntProperties.LEVEL_ICN_GENERATIO_PATH.getPropertyName(), "");
        this.addProperty(AntProperties.INPUT_FODLER.getPropertyName(), this.getInDir());
        this.addProperty(AntProperties.ECLIPSE_VARIABLE_PREFIX.getPropertyName(), "env");
        this.addProperty(AntProperties.PACKAGE_CREATE_MANIFEST.getPropertyName(), Boolean.TRUE.toString());
        this.addProperty(AntProperties.DELIVERY_INJECT_CHECKSUM.getPropertyName(), Boolean.TRUE.toString());
        IEclipsePreferences pref = InstanceScope.INSTANCE.getNode("com.indy.ui.build");
        this.addProperty(AntProperties.PACKAGE_INCLUDE_SOURCES.getPropertyName(), pref.get("package.generation.includeSources", Boolean.FALSE.toString()));
        if (this.sourceURI != null) {
            this.addProperty(AntProperties.INPUT_CACHE_URI.getPropertyName(), this.sourceURI.toString());
            String originalName = URI.decode((String)this.sourceURI.lastSegment());
            String inName = URI.decode((String)this.sourceURI.trimFileExtension().lastSegment());
            String baseName = inName.startsWith(".") ? inName.substring(1) : inName;
            this.addProperty(AntProperties.ABSOLUTE_FOLDER.getPropertyName(), this.getAbsoulteUri());
            this.addProperty(AntProperties.ORIGINAL_NAME.getPropertyName(), originalName);
            this.addProperty(AntProperties.BASE_NAME.getPropertyName(), baseName);
            this.addProperty(AntProperties.INPUT_NAME.getPropertyName(), inName);
            this.addProperty(AntProperties.DELIV_NAME.getPropertyName(), baseName + ".deliv");
        } else {
            this.addProperty(AntProperties.ABSOLUTE_FOLDER.getPropertyName(), this.getAbsoulteUri());
            this.addProperty(AntProperties.ORIGINAL_NAME.getPropertyName(), "");
            this.addProperty(AntProperties.BASE_NAME.getPropertyName(), "");
            this.addProperty(AntProperties.INPUT_NAME.getPropertyName(), "");
        }
        this.addProperty("conf", ((IEvaluationConfigurationService)E4InjectorHelper.getService(IEvaluationConfigurationService.class)).getCurrentConfigurationName());
        IEnvironmentConfiguration.EngineConfiguration engine = ((IEnvironmentConfiguration)E4InjectorHelper.getService(IEnvironmentConfiguration.class)).getEngineConfiguration();
        if (engine != null) {
            this.addProperty(AntProperties.RUNTIME_HOST.getPropertyName(), engine.getHost());
            this.addProperty(AntProperties.RUNTIME_PORT.getPropertyName(), engine.getPort());
            if (engine.getLogin() != null) {
                this.addProperty(AntProperties.RUNTIME_USER.getPropertyName(), engine.getLogin());
            }
            if (engine.getPassword() != null) {
                this.addProperty(AntProperties.RUNTIME_PASSWORD.getPropertyName(), engine.getPassword());
            }
        }
        this.addProperty(AntProperties.DEFAULT_SCRIPTING.getPropertyName(), pref.get("defaultScriptin", "rhino"));
        this.addProperty(AntProperties.ALLOWED_SCRIPTING_ERRORS.getPropertyName(), pref.get("scriptError", Boolean.FALSE.toString()));
        this.addProperty(AntProperties.ALLOWED_VARIABLES_ERRORS.getPropertyName(), pref.get("variableError", Boolean.FALSE.toString()));
    }

    private String getAbsoulteUri() {
        return this.absoulteUri;
    }

    public void attachListener4ProgressMonitor(IProgressMonitor monitor) {
        this.project.addBuildListener((BuildListener)new ExecutionInterrupter(monitor));
    }

    protected void initTmpFolder() {
        String tmpFolder = InstanceScope.INSTANCE.getNode("com.indy.ui.engine").get("com.indy.ui.engine.preference.generation.tmpFolder", null);
        if (tmpFolder != null && !tmpFolder.trim().isEmpty()) {
            this.project.setProperty("tmp.dir", tmpFolder.trim());
            File f = new File(tmpFolder.trim());
            f.mkdirs();
            this.project.log(Messages.ExecuteAnt_64 + String.valueOf(f));
            this.project.setProperty("work1.dir", tmpFolder.trim().replace("\\", "/") + "/wrk1");
            this.project.setProperty("work2.dir", tmpFolder.trim().replace("\\", "/") + "/wrk2");
        }
    }

    public IStatus run(String actionType, IGenerationService.EnvironmentInitializer initializer, IGenerationService.LoggingConfiguration loggingConfig) {
        HashMap<String, String> sourceIdToLocalFilerMap = new HashMap<String, String>();
        this.project.setProperty("ant.target.actionType", actionType);
        try {
            try {
                this.prepareAnt();
                initializer.initEnvironment();
                if (loggingConfig != null) {
                    CustomMessageEmitter.setGenerationMessageConsoleWriter(loggingConfig.createGenerationMessageWriter());
                    this.project.addBuildListener(this.createLogger(loggingConfig));
                } else {
                    CustomMessageEmitter.setGenerationMessageConsoleWriter(null);
                }
                this.project.fireBuildStarted();
                Functions.setMemoryCache(null);
                sourceIdToLocalFilerMap.putAll(this.cacheService.generateResourcePathPerId(true));
                Functions.setMemoryCache2(sourceIdToLocalFilerMap);
                Functions.setMemoryCache3(this.cacheService.generateResourcePathPerId(false));
                Functions.resetXpathPatternMapper();
                Functions.resetXpathExpressionCache();
                Functions.resetRefCache();
                GraphUtil.resetGraph();
                Functions.clear();
                this.project.setNewProperty("levelIconGenerationPath", "");
                this.initTmpFolder();
                initializer.getAntOptions().entrySet().stream().forEach(e -> this.setAntProjectProperty((String)e.getKey(), (String)e.getValue()));
                this.doRunAntTarget(actionType, sourceIdToLocalFilerMap);
                this.project.fireBuildFinished(null);
            }
            catch (BuildException e2) {
                MultiStatus ms = new MultiStatus(this.getClass(), 4, this.modelURI != null ? this.modelURI.toPlatformString(true) : "", null);
                if (e2.getCause() != null && e2.getCause().getCause() != null && e2.getCause().getCause().getCause() != null) {
                    ms.add((IStatus)new Status(4, this.getClass(), e2.getMessage(), e2.getCause().getCause().getCause()));
                } else {
                    ms.add((IStatus)new Status(4, this.getClass(), Messages.ExecuteAnt_104, e2.getCause()));
                }
                this.project.fireBuildFinished((Throwable)e2);
                MultiStatus multiStatus = ms;
                Functions.clear();
                return multiStatus;
            }
            catch (Exception e3) {
                String message = Messages.ExecuteAnt_107;
                this.project.fireBuildFinished((Throwable)e3);
                Status status = new Status(4, this.getClass(), (String)(this.modelURI != null ? this.modelURI.toPlatformString(true) : message), (Throwable)e3);
                Functions.clear();
                return status;
            }
        }
        finally {
            Functions.clear();
        }
        return Status.OK_STATUS;
    }

    private BuildListener createLogger(final IGenerationService.LoggingConfiguration loggingConfig) {
        DefaultLogger log = new DefaultLogger(){

            public void buildFinished(BuildEvent event) {
                if (event.getException() != null) {
                    this.handleExecutionError((Exception)event.getException(), this.getBuildFailedMessage());
                } else {
                    super.buildFinished(event);
                }
            }

            public void handleExecutionError(Exception ex, String failureMessage) {
                StringBuilder message = new StringBuilder();
                message.append(System.getProperty("line.separator"));
                message.append(failureMessage);
                message.append(System.getProperty("line.separator"));
                this.printMessage(message.toString(), this.err, 0);
                ex.printStackTrace(this.err);
                if (loggingConfig.getExceptionHandler() != null) {
                    loggingConfig.getExceptionHandler().accept(ex);
                }
            }
        };
        log.setErrorPrintStream(loggingConfig.getErrorPrintStream());
        log.setOutputPrintStream(loggingConfig.getOutputPrintStream());
        log.setMessageOutputLevel(loggingConfig.getLogLevel());
        return log;
    }

    private void doRunAntTarget(String actionType, Map<String, String> sourceIdToLocalFilerMap) {
        try {
            try {
                WorkbenchInvocation.INSTANCE = new WorkbenchInvocation();
                WorkbenchInvocationInitializer.addMethods(sourceIdToLocalFilerMap, this.registryService, this.cacheService);
                this.initIconsPathIfRequired(actionType);
                if (actionType.equals(STEP_LITETRANSFO) || actionType.equals(STEP_XML_TO_MD) || actionType.equals(STEP_IMPORT_MD) || actionType.equals(STEP_IMPORT_MAP) || actionType.equals(STEP_IMPORT_PROCESS)) {
                    Functions.setMemoryCache(this.cacheService.generateResourcePathPerId(true));
                }
                this.project.executeTarget(actionType);
            }
            catch (Exception e) {
                IGenerationService.GenerationExceptionHandler errorHandler = (IGenerationService.GenerationExceptionHandler)E4InjectorHelper.getService(IGenerationService.GenerationExceptionHandler.class);
                if (errorHandler != null) {
                    errorHandler.handleJobExecutionError(e);
                }
                throw e;
            }
        }
        finally {
            Functions.resetRefCache();
            Functions.resetXpathExpressionCache();
            Functions.setMemoryCache(null);
            Functions.setMemoryCache2(null);
            Functions.setMemoryCache3(null);
            Functions.resetXpathPatternMapper();
            Functions.resetMapLevel();
            Variables.resetAllMap();
        }
    }

    private void setAntProjectProperty(String key, String value) {
        if (value == null) {
            return;
        }
        if (this.project.getProperty(key) == null) {
            this.project.setNewProperty(key, value);
        } else {
            this.project.setProperty(key, value);
        }
    }

    public Map<String, Object> getProjectProperties() {
        return this.project.getProperties();
    }
}

