/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.cli;

import com.indy.shell.parser.CommandAnalyzer;
import com.indy.shell.parser.ShellCommand;
import com.indy.shell.parser.ShellCommandParameter;
import com.semarchy.xdi.designer.generation.ant.PackageManifest;
import com.semarchy.xdi.designer.generation.cli.PathResolver;
import com.semarchy.xdi.security.zip.ZipSecureFile;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.felix.shell.Command;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.osgi.service.component.annotations.Component;

@ShellCommand
@Component(property={"osgi.command.scope=stb", "osgi.command.function=extractPackageInfo"}, service={Command.class}, enabled=true)
public class PackageInfoShellCommand
implements Command {
    @ShellCommandParameter(commutator="extract")
    private String typeExtraction;
    @ShellCommandParameter(commutator="package")
    private String packageFilePath;
    @ShellCommandParameter(commutator="outputFile")
    private String reportFile;
    @ShellCommandParameter(commutator="append")
    private Boolean append;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$com$semarchy$xdi$designer$generation$cli$PackageInfoShellCommand$Type;

    private void doExecute(PrintWriter writer, OutputStream os, PrintStream err) throws Exception {
        IStatus res = this.perform(os, err);
        os.flush();
        if (res.isOK()) {
            if (this.reportFile != null) {
                writer.println("SUCCESS - Information generated in" + this.reportFile);
            } else {
                writer.println();
                writer.println("SUCCESS - " + res.getMessage());
            }
            writer.flush();
        } else {
            writer.println("ERROR - Checksum - " + res.getMessage());
            if (res.getException() != null) {
                res.getException().printStackTrace(err);
            }
        }
    }

    public void execute(String line, PrintStream out, PrintStream err) {
        block14: {
            this.typeExtraction = null;
            this.packageFilePath = null;
            this.reportFile = null;
            this.append = false;
            PrintWriter writer = new PrintWriter(out);
            try {
                this.parseLine(line.trim().substring(this.getName().length() + 1));
            }
            catch (Exception ex) {
                ex.printStackTrace(err);
                writer.println("ERROR - Command Parsing - " + ex.getMessage());
                return;
            }
            this.packageFilePath = PathResolver.resolveFileSystemPath(this.packageFilePath);
            this.reportFile = PathResolver.resolveFileSystemPath(this.reportFile);
            boolean toReport = this.reportFile != null && !Type.documentation.name().equals(this.typeExtraction);
            try {
                if (toReport) {
                    Throwable throwable = null;
                    Object var7_10 = null;
                    try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(this.reportFile, (boolean)this.append));){
                        this.doExecute(writer, os, err);
                        break block14;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                this.doExecute(writer, out, err);
            }
            catch (Exception ex) {
                writer.println("ERROR - Initialization - " + ex.getMessage());
                writer.flush();
                ex.printStackTrace(err);
                err.flush();
            }
        }
    }

    public String getName() {
        return "extractPackageInfo";
    }

    public String getShortDescription() {
        return "Generate a checksum for all the sources included in a package";
    }

    public String getUsage() {
        return "extractPackageInfo -package <packageFilePath>  -extract [sourceList|mainProcessList|manifest|date|user|packageId|processNames|conf|documentation] [-outputFile <reportFile>]";
    }

    private void parseLine(String line) throws Exception {
        CommandAnalyzer helper = new CommandAnalyzer();
        helper.prepare((Object)this, line);
    }

    /*
     * Loose catch block
     */
    private IStatus perform(OutputStream out, PrintStream err) throws Exception {
        if (this.typeExtraction == null) {
            throw new Exception("Missing argument -extract");
        }
        Type type = Type.valueOf(this.typeExtraction);
        if (type == null) {
            throw new Exception(this.typeExtraction + "not a valid type. Allowed values " + String.valueOf(Type.values()));
        }
        if (type == Type.documentation && this.reportFile == null) {
            throw new Exception("The parameter outputFile must be specified to extract documentation");
        }
        File packageFile = new File(this.packageFilePath);
        if (!packageFile.exists()) {
            throw new Exception("The package " + this.packageFilePath + " does not exists.");
        }
        if (!packageFile.isFile()) {
            throw new Exception(this.packageFilePath + " is not a file.");
        }
        Path srcPath = new Path("___internal___/__src/");
        class TmpInfo {
            IPath srcPath;
            String checkSum;
            String modelId;

            TmpInfo(IPath srcPath, byte[] digest) {
                this.srcPath = srcPath.makeAbsolute();
                this.checkSum = this.formatChecksum(digest);
            }

            TmpInfo(IPath srcPath, String checkSum) {
                this.srcPath = srcPath;
                this.checkSum = checkSum;
            }

            private String formatChecksum(byte[] digest) {
                Object result = "";
                int i = 0;
                while (i < digest.length) {
                    result = (String)result + Integer.toString((digest[i] & 0xFF) + 256, 16).substring(1);
                    ++i;
                }
                return result;
            }
        }
        ArrayList<TmpInfo> tmpRes = new ArrayList<TmpInfo>();
        File tmpManifestFile = File.createTempFile("stambiaDesigner", "manifest");
        boolean containSrc = false;
        try {
            byte[] buffer = new byte[1024];
            Throwable throwable = null;
            Iterator<Object> iterator = null;
            try {
                ZipSecureFile zipFile = new ZipSecureFile(packageFile);
                Enumeration entries = zipFile.getEntries();
                MessageDigest digest = MessageDigest.getInstance("MD5");
                {
                    catch (Throwable throwable2) {
                        if (zipFile != null) {
                            zipFile.close();
                        }
                        throw throwable2;
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        finally {
            try {
                Files.delete(tmpManifestFile.toPath());
            }
            catch (Exception e) {
                e.printStackTrace(err);
            }
        }
    }

    public void extractPackageInfo(String ... params) {
        StringBuilder b = new StringBuilder();
        b.append(this.getName() + " ");
        String[] stringArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.startsWith("-")) {
                b.append(s + " ");
            } else {
                b.append("\"" + s + "\" ");
            }
            ++n2;
        }
        this.execute(b.toString(), System.out, System.err);
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$semarchy$xdi$designer$generation$cli$PackageInfoShellCommand$Type() {
        if ($SWITCH_TABLE$com$semarchy$xdi$designer$generation$cli$PackageInfoShellCommand$Type != null) {
            return $SWITCH_TABLE$com$semarchy$xdi$designer$generation$cli$PackageInfoShellCommand$Type;
        }
        int[] nArray = new int[Type.values().length];
        try {
            nArray[Type.conf.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Type.date.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Type.documentation.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Type.mainProcessList.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Type.manifest.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Type.packageId.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Type.sourceList.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Type.user.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$semarchy$xdi$designer$generation$cli$PackageInfoShellCommand$Type = nArray;
        return nArray;
    }

    private static /* synthetic */ int lambda$0(1TmpInfo o1, 1TmpInfo o2) {
        return o1.modelId.compareTo(o2.modelId);
    }

    private static /* synthetic */ int lambda$1(PackageManifest.MainProcess o1, PackageManifest.MainProcess o2) {
        return o1.getProcessId().compareTo(o2.getProcessId());
    }

    private static enum Type {
        sourceList,
        mainProcessList,
        manifest,
        date,
        user,
        packageId,
        conf,
        documentation;

    }
}

