/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.cli;

import com.indy.shell.parser.CommandAnalyzer;
import com.indy.shell.parser.ShellCommand;
import com.indy.shell.parser.ShellCommandParameter;
import com.semarchy.xdi.designer.generation.ant.ManifestMarshallingHelper;
import com.semarchy.xdi.designer.generation.ant.PackageManifest;
import com.semarchy.xdi.designer.generation.cli.PathResolver;
import com.semarchy.xdi.security.zip.ZipArchiveThresholdInputStream;
import com.semarchy.xdi.security.zip.ZipSecureFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.felix.shell.Command;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.service.component.annotations.Component;

@ShellCommand
@Component(property={"osgi.command.scope=stb", "osgi.command.function=validatePackageSource"}, service={Command.class}, enabled=true)
public class PackageValidationShellCommand
implements Command {
    private static final String BUILD_UI_BUNDLE_NAME = "com.indy.ui.build";
    @ShellCommandParameter(commutator="package")
    private String packagePath;
    @ShellCommandParameter(commutator="md5Rule")
    private String md5Rule;

    private void parseLine(String line) throws Exception {
        CommandAnalyzer helper = new CommandAnalyzer();
        helper.prepare((Object)this, line);
    }

    public void execute(String line, PrintStream out, PrintStream err) {
        this.packagePath = null;
        this.md5Rule = null;
        PrintWriter writer = new PrintWriter(out);
        try {
            this.parseLine(line.trim().substring(this.getName().length() + 1));
        }
        catch (Exception ex) {
            ex.printStackTrace(err);
            writer.println("ERROR - Command Parsing - " + ex.getMessage());
            return;
        }
        this.packagePath = PathResolver.resolveFileSystemPath(this.packagePath);
        try {
            IStatus res = this.perform(err);
            if (res.isOK()) {
                writer.println("SUCCESS - validatePackageSource on " + this.packagePath);
            } else {
                StringBuilder b = new StringBuilder();
                IStatus[] iStatusArray = ((MultiStatus)res).getChildren();
                int n = iStatusArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus s = iStatusArray[n2];
                    b.append(s.getMessage());
                    b.append(",");
                    ++n2;
                }
                writer.println("ERROR - validatePackageSource on " + this.packagePath + " failed for models :" + b.toString());
                if (res.getException() != null) {
                    res.getException().printStackTrace(err);
                }
            }
        }
        catch (Exception ex) {
            writer.println("ERROR - Initialization - " + ex.getMessage());
            writer.flush();
            ex.printStackTrace(err);
            err.flush();
        }
    }

    /*
     * WARNING - void declaration
     */
    private IStatus perform(PrintStream err) throws Exception {
        PackageManifest mf;
        if (this.packagePath == null) {
            throw new Exception("Missing argument -package");
        }
        File packageFile = new File(this.packagePath);
        if (!packageFile.exists() || packageFile.isDirectory()) {
            throw new Exception("The package file " + this.packagePath + " does not exist");
        }
        if (this.packagePath == null) {
            throw new Exception("Missing argument -md5Rule");
        }
        HashMap<String, String> md5Rules = new HashMap<String, String>();
        HashSet<String> mandatoryFiles = new HashSet<String>();
        String[] rules = this.md5Rule.split(";");
        Object object = rules;
        int n = rules.length;
        int n2 = 0;
        while (n2 < n) {
            String r = object[n2];
            String[] stringArray = r.split(":");
            if (stringArray.length < 2 || stringArray.length > 3) {
                throw new Exception("Invalid md5Rule " + r);
            }
            String old = md5Rules.put(stringArray[0], stringArray[1]);
            if (old != null) {
                throw new Exception("The md5Rule cannot define multiple values for the same modelId (" + stringArray[0] + ")");
            }
            if (stringArray.length > 2) {
                String mandatory = stringArray[2];
                if (!mandatory.equals("true") || mandatory.equals("false")) {
                    throw new Exception("Wrong rule syntax on " + r + ". The mandatory value must be true or false.");
                }
                if (Boolean.parseBoolean(mandatory)) {
                    mandatoryFiles.add(stringArray[0]);
                }
            }
            ++n2;
        }
        File tmpManifestFile = File.createTempFile("stambiaDesigner", "manifest");
        try {
            byte[] buffer = new byte[1024];
            object = null;
            Object var10_15 = null;
            try (ZipSecureFile zipFile = new ZipSecureFile(packageFile);){
                Enumeration entries = zipFile.getEntries();
                while (entries.hasMoreElements()) {
                    String fileName;
                    ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                    if (entry.isDirectory() || !(fileName = entry.getName()).equals("___internal___/manifest.xml")) continue;
                    Throwable throwable = null;
                    Object var16_35 = null;
                    try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(tmpManifestFile));){
                        Throwable throwable2 = null;
                        Object var20_41 = null;
                        try (ZipArchiveThresholdInputStream inputStream = zipFile.getInputStream(entry);){
                            int len;
                            while ((len = inputStream.read(buffer)) > 0) {
                                ((OutputStream)fos).write(buffer, 0, len);
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                } else if (object != throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                throw object;
            }
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            try {
                Throwable throwable = null;
                Iterator<PackageManifest.SourceEntry> iterator = null;
                try (BufferedInputStream fis = new BufferedInputStream(new FileInputStream(tmpManifestFile));){
                    mf = ManifestMarshallingHelper.unmarshal(fis);
                }
                catch (Throwable throwable5) {
                    void var10_20;
                    if (throwable == null) {
                        Throwable throwable6 = throwable5;
                    } else if (throwable != throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    throw var10_20;
                }
            }
            finally {
                try {
                    Files.delete(tmpManifestFile.toPath());
                }
                catch (IOException e) {
                    e.printStackTrace(err);
                }
                Thread.currentThread().setContextClassLoader(ccl);
            }
        }
        catch (Exception ex) {
            throw new Exception("Unable to read package manifest", ex);
        }
        MultiStatus ms = new MultiStatus(BUILD_UI_BUNDLE_NAME, 0, "", null);
        HashSet<String> entriesIds = new HashSet<String>();
        for (PackageManifest.SourceEntry sourceEntry : mf.getSources()) {
            entriesIds.add(sourceEntry.getSourceId());
            String md5 = (String)md5Rules.get(sourceEntry.getSourceId());
            if (md5 == null || md5.equals(sourceEntry.getSourceChecksum())) continue;
            ms.add((IStatus)new Status(4, BUILD_UI_BUNDLE_NAME, "Wrong MD5 checksum for " + sourceEntry.getSourceId()));
        }
        for (String string : mandatoryFiles) {
            if (entriesIds.contains(string)) continue;
            ms.add((IStatus)new Status(4, BUILD_UI_BUNDLE_NAME, "The mandatory source " + string + " does not belong to the package"));
        }
        return ms;
    }

    public String getName() {
        return "validatePackageSource";
    }

    public String getShortDescription() {
        return "validate the sources in the package";
    }

    public String getUsage() {
        return "validatePackageSource -package <packageFilePath> -md5Rule modelId:md5Checksum[:<mandatory>][;...]";
    }

    public void validatePackageSource(String ... params) {
        StringBuilder b = new StringBuilder();
        b.append(this.getName() + " ");
        String[] stringArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.startsWith("-")) {
                b.append(s + " ");
            } else {
                b.append("\"" + s + "\" ");
            }
            ++n2;
        }
        this.execute(b.toString(), System.out, System.err);
    }
}

